/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.LambDynLights;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin<T extends Entity> {
    @Inject(method={"getBlockLightLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetBlockLight(T entity, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (!LambDynLights.isEnabled()) {
            return;
        }
        int vanilla = cir.getReturnValueI();
        int entityLuminance = ((DynamicLightSource)entity).tdv$getLuminance();
        if (entityLuminance >= 15) {
            cir.setReturnValue((Object)entityLuminance);
        }
        int posLuminance = (int)LambDynLights.get().getDynamicLightLevel(pos);
        cir.setReturnValue((Object)Math.max(Math.max(vanilla, entityLuminance), posLuminance));
    }
}

