/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.tile;

import io.socol.presencenotrequired.api.FurnaceAccess;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.level.Level;

public class FurnaceSimulator {
    private final Container items;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private boolean dataChanged;
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public FurnaceSimulator(Container items, int litTime, int litDuration, int cookingProgress, int cookingTotalTime) {
        this.items = items;
        this.litTime = litTime;
        this.litDuration = litDuration;
        this.cookingProgress = cookingProgress;
        this.cookingTotalTime = cookingTotalTime;
    }

    public void simulate(int tickPassed, Level level, FurnaceAccess furnace) {
        if (!this.ingredient().m_41619_() && this.hasFuel()) {
            AbstractCookingRecipe recipe = level.m_7465_().m_44015_(furnace.getRecipeType(), this.items, level).orElse(null);
            if (recipe == null || recipe.m_43753_() == 0) {
                return;
            }
            this.cookingTotalTime = recipe.m_43753_();
            ItemStack recipeResult = recipe.m_5874_(this.items);
            int availableRecipeCount = this.getAvailableRecipeCount(this.items, recipeResult);
            if (availableRecipeCount == 0) {
                return;
            }
            int availableTime = Math.min(tickPassed, this.getAvailableFuelTicks(furnace));
            int possibleRecipeCount = Math.min(availableRecipeCount, (availableTime + this.cookingProgress) / this.cookingTotalTime);
            if (possibleRecipeCount > 0) {
                this.recipesUsed.addTo((Object)recipe.m_6423_(), possibleRecipeCount);
                this.ingredient().m_41774_(possibleRecipeCount);
                if (this.result().m_41619_()) {
                    this.items.m_6836_(2, recipeResult.m_41777_());
                    this.result().m_41764_(possibleRecipeCount * recipeResult.m_41613_());
                } else {
                    this.result().m_41769_(possibleRecipeCount * recipeResult.m_41613_());
                }
            }
            int existedCookingProgress = this.cookingProgress;
            this.cookingProgress = possibleRecipeCount < availableRecipeCount ? (availableTime + this.cookingProgress) % this.cookingTotalTime : 0;
            int fuelTicks = possibleRecipeCount * this.cookingTotalTime - existedCookingProgress + this.cookingProgress;
            this.consumeFuelTicks(furnace, fuelTicks);
            this.dataChanged = true;
        }
    }

    private boolean hasFuel() {
        return this.litTime > 0 || !this.fuel().m_41619_();
    }

    private int getAvailableRecipeCount(Container container, ItemStack recipeResult) {
        if (recipeResult.m_41619_() || !this.result().m_41619_() && !recipeResult.m_41656_(this.result())) {
            return 0;
        }
        int maxResultSize = this.getMaxStackSize(container, recipeResult);
        int maxRecipeOutputs = (maxResultSize - this.result().m_41613_()) / recipeResult.m_41613_();
        return Math.min(this.ingredient().m_41613_(), maxRecipeOutputs);
    }

    private void consumeFuelTicks(FurnaceAccess furnace, int fuelTicks) {
        if (this.litTime > 0) {
            if (this.litTime >= fuelTicks) {
                this.litTime -= fuelTicks;
                return;
            }
            fuelTicks -= this.litTime;
            this.litTime = 0;
        }
        if (fuelTicks > 0) {
            int burnTime = furnace.getFuelBurnTime(this.fuel());
            if (burnTime == 0) {
                return;
            }
            int requiredFuelAmount = (fuelTicks % burnTime == 0 ? 0 : 1) + fuelTicks / burnTime;
            if (this.fuel().hasContainerItem()) {
                this.items.m_6836_(1, this.fuel().getContainerItem());
            } else {
                this.fuel().m_41774_(requiredFuelAmount);
                if (this.fuel().m_41619_()) {
                    this.items.m_6836_(1, this.fuel().getContainerItem());
                }
            }
            this.litDuration = burnTime;
            this.litTime = requiredFuelAmount * burnTime - fuelTicks;
        }
    }

    private int getAvailableFuelTicks(FurnaceAccess furnace) {
        if (this.fuel().m_41619_()) {
            return this.litTime;
        }
        int burnTime = furnace.getFuelBurnTime(this.fuel());
        int fuelAmount = this.fuel().hasContainerItem() ? 1 : this.fuel().m_41613_();
        return fuelAmount * burnTime + this.litTime;
    }

    private int getMaxStackSize(Container container, ItemStack stack) {
        return Math.min(container.m_6893_(), stack.m_41741_());
    }

    public Container getContainer() {
        return this.items;
    }

    private ItemStack ingredient() {
        return this.items.m_8020_(0);
    }

    private ItemStack fuel() {
        return this.items.m_8020_(1);
    }

    private ItemStack result() {
        return this.items.m_8020_(2);
    }

    public int getLitTime() {
        return this.litTime;
    }

    public int getLitDuration() {
        return this.litDuration;
    }

    public int getCookingProgress() {
        return this.cookingProgress;
    }

    public int getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public Object2IntOpenHashMap<ResourceLocation> getRecipesUsed() {
        return this.recipesUsed;
    }
}

