/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.tile;

import io.socol.presencenotrequired.api.CampfireAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CampfireSimulator {
    private final Container items;
    private final int[] cookingProgress;
    private final int[] cookingTime;
    private boolean containerChanged;
    private boolean dataChanged;

    public CampfireSimulator(Container items, int[] cookingProgress, int[] cookingTime) {
        this.items = items;
        this.cookingProgress = cookingProgress;
        this.cookingTime = cookingTime;
    }

    public void simulate(int tickPassed, Level level, BlockPos pos, CampfireAccess campfire) {
        for (int i = 0; i < this.items.m_6643_(); ++i) {
            ItemStack stack = this.items.m_8020_(i);
            if (stack.m_41619_()) continue;
            int n = i;
            this.cookingProgress[n] = this.cookingProgress[n] + tickPassed;
            this.dataChanged = true;
            if (this.cookingProgress[i] < this.cookingTime[i]) continue;
            this.cookingProgress[i] = this.cookingTime[i];
            this.items.m_6836_(i, ItemStack.f_41583_);
            this.containerChanged = true;
            SimpleContainer container = new SimpleContainer(new ItemStack[]{stack});
            ItemStack result = level.m_7465_().m_44015_(RecipeType.f_44111_, (Container)container, level).map(arg_0 -> CampfireSimulator.lambda$simulate$0((Container)container, arg_0)).orElse(stack);
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)result);
        }
    }

    public boolean isContainerChanged() {
        return this.containerChanged;
    }

    public Container getContainer() {
        return this.items;
    }

    public int[] getCookingProgress() {
        return this.cookingProgress;
    }

    public int[] getCookingTime() {
        return this.cookingTime;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    private static /* synthetic */ ItemStack lambda$simulate$0(Container container, CampfireCookingRecipe recipe) {
        return recipe.m_5874_(container);
    }
}

