/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.tile;

import io.socol.presencenotrequired.api.BrewingStandAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;

public class BrewingStandSimulator {
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    private final NonNullList<ItemStack> items;
    private int brewTime;
    private int fuel;
    private Item ingredientItem;
    private boolean dataChanged;

    public BrewingStandSimulator(NonNullList<ItemStack> items, int brewTime, int fuel, Item ingredient) {
        this.items = items;
        this.brewTime = brewTime;
        this.fuel = fuel;
        this.ingredientItem = ingredient;
    }

    public void simulate(int tickPassed, Level level, BlockPos pos, BrewingStandAccess brewingStand) {
        this.consumeFuel();
        if (!this.isBrewable()) {
            return;
        }
        this.dataChanged = true;
        if (this.brewTime <= 0 && this.fuel > 0) {
            --this.fuel;
            this.brewTime = 400;
            this.ingredientItem = ((ItemStack)this.items.get(3)).m_41720_();
            this.consumeFuel();
            --tickPassed;
        }
        if (this.brewTime > 0) {
            this.brewTime -= tickPassed;
            if (this.brewTime <= 0) {
                this.brewTime = 0;
                this.brew(level, pos);
            }
        }
    }

    private void consumeFuel() {
        ItemStack fuelStack = (ItemStack)this.items.get(4);
        if (this.fuel <= 0 && fuelStack.m_150930_(Items.f_42593_)) {
            this.fuel = 20;
            fuelStack.m_41774_(1);
            this.dataChanged = true;
        }
    }

    private boolean isBrewable() {
        ItemStack ingredient = (ItemStack)this.items.get(3);
        return !ingredient.m_41619_() && BrewingRecipeRegistry.canBrew(this.items, (ItemStack)ingredient, (int[])SLOTS_FOR_SIDES);
    }

    private void brew(Level level, BlockPos pos) {
        if (ForgeEventFactory.onPotionAttemptBrew(this.items)) {
            return;
        }
        ItemStack ingredient = (ItemStack)this.items.get(3);
        BrewingRecipeRegistry.brewPotions(this.items, (ItemStack)ingredient, (int[])SLOTS_FOR_SIDES);
        ForgeEventFactory.onPotionBrewed(this.items);
        if (ingredient.hasContainerItem()) {
            ItemStack container = ingredient.getContainerItem();
            ingredient.m_41774_(1);
            if (ingredient.m_41619_()) {
                this.items.set(3, (Object)container);
            } else {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)container);
            }
        } else {
            ingredient.m_41774_(1);
        }
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public Item getIngredientItem() {
        return this.ingredientItem;
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getBrewTime() {
        return this.brewTime;
    }
}

