/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.plant;

import io.socol.presencenotrequired.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.ForgeHooks;

public class SugarCaneSimulator {
    private static final int MAX_CANE_LENGTH = 3;

    public static void simulate(int tickPassed, LevelChunk chunk, BlockPos pos, BlockState state, SugarCaneBlock sugarCane) {
        BlockPos above;
        Level level = chunk.m_62953_();
        if (!level.m_46859_(above = pos.m_7494_())) {
            return;
        }
        int caneLength = WorldUtils.getHeightBelow(level, pos, Blocks.f_50130_, 3);
        if (caneLength < 3) {
            SugarCaneSimulator.growSugarCane(level, pos.m_7949_(), above, state, sugarCane, tickPassed, caneLength);
        }
    }

    private static void growSugarCane(Level level, BlockPos pos, BlockPos above, BlockState state, SugarCaneBlock sugarCane, int tickPassed, int caneLength) {
        BlockState aboveState;
        BlockPos nextAbove;
        if (!ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)SugarCaneBlock.f_57164_);
        int newAge = Math.min(age + tickPassed, 16);
        BlockState newState = (BlockState)state.m_61124_((Property)SugarCaneBlock.f_57164_, (Comparable)Integer.valueOf(newAge % 16));
        if (age != newAge % 16) {
            level.m_7731_(pos, newState, 4);
        }
        tickPassed -= newAge - age;
        if (newAge == 16) {
            BlockState aboveState2 = sugarCane.m_49966_();
            level.m_46597_(above, aboveState2);
            ++caneLength;
        }
        ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        if (newAge == 16 && tickPassed > 0 && caneLength < 3 && level.m_46859_(nextAbove = above.m_7494_()) && (aboveState = level.m_8055_(above)).m_60713_((Block)sugarCane)) {
            SugarCaneSimulator.growSugarCane(level, above, nextAbove, aboveState, sugarCane, tickPassed, caneLength);
        }
    }
}

