/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.plant;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class StemSimulator {
    private static final Random RND = new Random();

    public static void simulate(int tickPassed, LevelChunk chunk, BlockPos pos, BlockState state, StemBlock stem) {
        Level level = chunk.m_62953_();
        if (level.m_45524_(pos, 0) < 9) {
            return;
        }
        float growthSpeed = CropBlock.m_52272_((Block)stem, (BlockGetter)level, (BlockPos)pos);
        if (growthSpeed <= 0.0f) {
            return;
        }
        float perTickGrowth = 25.0f / growthSpeed + 1.0f;
        int growAmount = (int)(perTickGrowth * (float)tickPassed);
        if (growAmount < 1) {
            return;
        }
        BlockPos imPos = pos.m_7949_();
        if (!ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)imPos, (BlockState)state, (boolean)true)) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
        int newAge = age + growAmount;
        if (newAge <= 7) {
            level.m_7731_(imPos, (BlockState)state.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(newAge)), 2);
        } else {
            List<Direction> growthDirections = StemSimulator.getGrowthDirections(level, pos, stem);
            if (!growthDirections.isEmpty()) {
                float growChance = ((float)newAge - 7.0f) / (float)growthDirections.size();
                if (RND.nextFloat() <= growChance) {
                    Direction fruitDirection = growthDirections.get(RND.nextInt(growthDirections.size()));
                    BlockPos fruitPos = pos.m_142300_(fruitDirection);
                    BlockState newState = (BlockState)stem.m_57056_().m_7810_().m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)fruitDirection);
                    level.m_46597_(fruitPos, stem.m_57056_().m_49966_());
                    level.m_46597_(imPos, newState);
                }
            } else if (age != 7) {
                level.m_7731_(imPos, (BlockState)state.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(7)), 2);
            }
        }
        ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)imPos, (BlockState)state);
    }

    private static List<Direction> getGrowthDirections(Level level, BlockPos pos, StemBlock stem) {
        ArrayList<Direction> result = new ArrayList<Direction>();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos sidePos = pos.m_142300_(dir);
            if (!level.m_46859_(sidePos)) continue;
            BlockPos soilPos = sidePos.m_7495_();
            BlockState soilState = level.m_8055_(soilPos);
            Block soilBlock = soilState.m_60734_();
            if (!soilState.canSustainPlant((BlockGetter)level, soilPos, Direction.UP, (IPlantable)stem) && soilBlock != Blocks.f_50093_ && soilBlock != Blocks.f_50493_ && soilBlock != Blocks.f_50546_ && soilBlock != Blocks.f_50599_ && soilBlock != Blocks.f_50440_) continue;
            result.add(dir);
        }
        return result;
    }
}

