/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.plant;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.ForgeHooks;

public class CropSimulator {
    private static final HashMap<ResourceLocation, CropProperties> properties = new HashMap();

    public static void simulate(int tickPassed, LevelChunk chunk, BlockPos pos, BlockState state, CropBlock crop) {
        int maxAge;
        Level level = chunk.m_62953_();
        CropProperties props = properties.get(crop.getRegistryName());
        if (props == null) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)crop.m_7959_());
        if (age >= (maxAge = crop.m_7419_())) {
            return;
        }
        if (level.m_45524_(pos, 0) < 9) {
            return;
        }
        float growthSpeed = CropBlock.m_52272_((Block)crop, (BlockGetter)level, (BlockPos)pos);
        if (growthSpeed <= 0.0f) {
            return;
        }
        float perTickGrowth = props.speedModifier / (25.0f / growthSpeed + 1.0f);
        int growAmount = (int)(perTickGrowth * (float)tickPassed);
        if (growAmount < 1) {
            return;
        }
        BlockPos imPos = pos.m_7949_();
        if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)imPos, (BlockState)state, (boolean)true)) {
            int newAge = Math.min(age + growAmount, maxAge);
            level.m_7731_(imPos, crop.m_52289_(newAge), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)imPos, (BlockState)state);
        }
    }

    static {
        properties.put(Blocks.f_50092_.getRegistryName(), new CropProperties(1.0f));
        properties.put(Blocks.f_50249_.getRegistryName(), new CropProperties(1.0f));
        properties.put(Blocks.f_50250_.getRegistryName(), new CropProperties(1.0f));
        properties.put(Blocks.f_50444_.getRegistryName(), new CropProperties(0.33333334f));
    }

    private static class CropProperties {
        public float speedModifier;

        public CropProperties(float speedModifier) {
            this.speedModifier = speedModifier;
        }
    }
}

