/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.plant;

import io.socol.presencenotrequired.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.ForgeHooks;

public class CactusSimulator {
    private static final int MAX_CACTUS_LENGTH = 3;

    public static void simulate(int tickPassed, LevelChunk chunk, BlockPos pos, BlockState state, CactusBlock cactus) {
        BlockPos above;
        Level level = chunk.m_62953_();
        if (!level.m_46859_(above = pos.m_7494_())) {
            return;
        }
        int cactusLength = WorldUtils.getHeightBelow(level, pos, Blocks.f_50128_, 3);
        if (cactusLength < 3) {
            CactusSimulator.growCactus(level, pos.m_7949_(), above, state, cactus, tickPassed, cactusLength);
        }
    }

    private static void growCactus(Level level, BlockPos pos, BlockPos above, BlockState state, CactusBlock cactus, int tickPassed, int cactusLength) {
        BlockState aboveState;
        BlockPos nextAbove;
        if (!ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            return;
        }
        int age = (Integer)state.m_61143_((Property)CactusBlock.f_51131_);
        int newAge = Math.min(age + tickPassed, 16);
        if (newAge == 16 && !cactus.m_7898_(cactus.m_49966_(), (LevelReader)level, above)) {
            newAge = 15;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)CactusBlock.f_51131_, (Comparable)Integer.valueOf(newAge % 16));
        if (age != newAge % 16) {
            level.m_7731_(pos, newState, 4);
        }
        tickPassed -= newAge - age;
        if (newAge == 16) {
            BlockState aboveState2 = cactus.m_49966_();
            level.m_46597_(above, aboveState2);
            newState.m_60690_(level, above, (Block)cactus, pos, false);
            ++cactusLength;
        }
        ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        if (newAge == 16 && tickPassed > 0 && cactusLength < 3 && level.m_46859_(nextAbove = above.m_7494_()) && (aboveState = level.m_8055_(above)).m_60713_((Block)cactus)) {
            CactusSimulator.growCactus(level, above, nextAbove, aboveState, cactus, tickPassed, cactusLength);
        }
    }
}

