/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate.plant;

import io.socol.presencenotrequired.util.WorldUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.ForgeHooks;

public class BambooSimulator {
    private static final int SAPLING_GROW_TICKS = 3;
    private static final int MAX_BAMBOO_LENGTH = 16;
    private static final int MIN_BRIGHTNESS = 9;
    private static final float BAMBOO_GROWTH_SPEED = 0.33333334f;
    private static final Random RND = new Random();

    public static void simulateSapling(int tickPassed, LevelChunk chunk, BlockPos pos, BlockState state) {
        if (tickPassed < 3) {
            return;
        }
        BlockPos above = pos.m_7494_();
        BlockState stateAbove = (BlockState)Blocks.f_50571_.m_49966_().m_61124_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.SMALL);
        chunk.m_62953_().m_7731_(above, stateAbove, 3);
        int growAmount = (int)(0.33333334f * (float)(tickPassed -= 3));
        if (growAmount > 0) {
            BlockPos nextAbove = above.m_7494_();
            if (BambooSimulator.canGrowInto(chunk.m_62953_(), nextAbove)) {
                BambooSimulator.growBamboo(chunk.m_62953_(), above, nextAbove, stateAbove, growAmount, 2);
            }
        }
    }

    public static void simulate(int tickPassed, LevelChunk chunk, BlockPos pos, BlockState state) {
        BlockPos above;
        if ((Integer)state.m_61143_((Property)BambooBlock.f_48871_) != 0) {
            return;
        }
        int growAmount = (int)(0.33333334f * (float)tickPassed);
        if (growAmount <= 0) {
            return;
        }
        Level level = chunk.m_62953_();
        if (!BambooSimulator.canGrowInto(level, above = pos.m_7494_())) {
            return;
        }
        int bambooLength = WorldUtils.getHeightBelow(level, pos, Blocks.f_50571_, 16);
        if (bambooLength < 16) {
            BambooSimulator.growBamboo(level, pos, above, state, growAmount, bambooLength);
        }
    }

    private static void growBamboo(Level level, BlockPos pos, BlockPos above, BlockState state, int growAmount, int bambooLength) {
        if (!ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            return;
        }
        BlockPos below1 = pos.m_7495_();
        BlockState belowState1 = level.m_8055_(below1);
        BlockPos below2 = pos.m_6625_(2);
        BlockState belowState2 = level.m_8055_(below2);
        BambooLeaves bambooLeaves = BambooLeaves.NONE;
        if (belowState1.m_60713_(Blocks.f_50571_) && belowState1.m_61143_((Property)BambooBlock.f_48870_) != BambooLeaves.NONE) {
            if (belowState1.m_60713_(Blocks.f_50571_) && belowState1.m_61143_((Property)BambooBlock.f_48870_) != BambooLeaves.NONE) {
                bambooLeaves = BambooLeaves.LARGE;
                if (belowState2.m_60713_(Blocks.f_50571_)) {
                    level.m_7731_(below1, (BlockState)belowState1.m_61124_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.SMALL), 3);
                    level.m_7731_(below2, (BlockState)belowState2.m_61124_((Property)BambooBlock.f_48870_, (Comparable)BambooLeaves.NONE), 3);
                }
            }
        } else {
            bambooLeaves = BambooLeaves.SMALL;
        }
        int age = (Integer)state.m_61143_((Property)BambooBlock.f_48869_) != 1 && !belowState2.m_60713_(Blocks.f_50571_) ? 0 : 1;
        int stage = !(bambooLength >= 11 && RND.nextFloat() < 0.25f || bambooLength >= 15) ? 0 : 1;
        BlockState newState = (BlockState)((BlockState)((BlockState)Blocks.f_50571_.m_49966_().m_61124_((Property)BambooBlock.f_48869_, (Comparable)Integer.valueOf(age))).m_61124_((Property)BambooBlock.f_48870_, (Comparable)bambooLeaves)).m_61124_((Property)BambooBlock.f_48871_, (Comparable)Integer.valueOf(stage));
        level.m_7731_(above, newState, 3);
        ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        if (++bambooLength < 16 && --growAmount > 0 && stage == 0) {
            BambooSimulator.growBamboo(level, above, above.m_7494_(), newState, growAmount, bambooLength);
        }
    }

    private static boolean canGrowInto(Level level, BlockPos pos) {
        return level.m_46859_(pos) && level.m_45524_(pos, 0) >= 9;
    }
}

