/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.simulate;

import io.socol.presencenotrequired.PresenceNotRequired;
import io.socol.presencenotrequired.SimulationConfig;
import io.socol.presencenotrequired.api.BrewingStandAccess;
import io.socol.presencenotrequired.api.CampfireAccess;
import io.socol.presencenotrequired.api.FurnaceAccess;
import io.socol.presencenotrequired.simulate.plant.BambooSimulator;
import io.socol.presencenotrequired.simulate.plant.BerryBushSimulator;
import io.socol.presencenotrequired.simulate.plant.CactusSimulator;
import io.socol.presencenotrequired.simulate.plant.CropSimulator;
import io.socol.presencenotrequired.simulate.plant.NetherWartSimulator;
import io.socol.presencenotrequired.simulate.plant.StemSimulator;
import io.socol.presencenotrequired.simulate.plant.SugarCaneSimulator;
import io.socol.presencenotrequired.simulate.tile.BrewingStandSimulator;
import io.socol.presencenotrequired.simulate.tile.CampfireSimulator;
import io.socol.presencenotrequired.simulate.tile.FurnaceSimulator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;

public class ChunkLifeSimulator {
    public static void simulate(LevelChunk chunk, long timePassed) {
        Level level = chunk.m_62953_();
        if (level.f_46443_ || timePassed < 10L) {
            return;
        }
        SimulationConfig config = PresenceNotRequired.getConfig();
        for (Map.Entry entry : chunk.m_62954_().entrySet()) {
            Object simulator;
            Object access;
            BlockPos pos = (BlockPos)entry.getKey();
            BlockEntity tile = (BlockEntity)entry.getValue();
            if (tile instanceof AbstractFurnaceBlockEntity) {
                if (!config.isFurnacesEnable()) continue;
                access = (FurnaceAccess)tile;
                simulator = access.createSimulator();
                ((FurnaceSimulator)simulator).simulate((int)timePassed, level, (FurnaceAccess)access);
                access.apply(level, pos, tile.m_58900_(), (FurnaceSimulator)simulator);
                continue;
            }
            if (tile instanceof CampfireBlockEntity) {
                if (!config.isCampfiresEnable()) continue;
                access = (CampfireAccess)tile;
                simulator = access.createSimulator();
                ((CampfireSimulator)simulator).simulate((int)timePassed, level, pos, (CampfireAccess)access);
                access.apply(level, pos, tile.m_58900_(), (CampfireSimulator)simulator);
                continue;
            }
            if (!(tile instanceof BrewingStandBlockEntity) || !config.isBrewingStandsEnable()) continue;
            access = (BrewingStandAccess)tile;
            simulator = access.createSimulator();
            ((BrewingStandSimulator)simulator).simulate((int)timePassed, level, pos, (BrewingStandAccess)access);
            access.apply(level, pos, tile.m_58900_(), (BrewingStandSimulator)simulator);
        }
        List entities = level.m_6249_((Entity)null, new AABB((double)chunk.m_7697_().m_45604_(), (double)level.m_141937_(), (double)chunk.m_7697_().m_45605_(), (double)chunk.m_7697_().m_45608_(), (double)level.m_151558_(), (double)chunk.m_7697_().m_45609_()), EntitySelector.f_20403_);
        for (Entity entity : entities) {
            Chicken chicken;
            if (config.isMobGrowingEnable() && entity instanceof AgeableMob) {
                AgeableMob ageable = (AgeableMob)entity;
                int age = ageable.m_146764_();
                int ageDelta = Math.min((int)timePassed, Math.abs(age));
                ageable.m_146762_(age += age < 0 ? ageDelta : -ageDelta);
            }
            if (!config.isChickenEggLayingEnable() || !(entity instanceof Chicken) || (chicken = (Chicken)entity).m_6162_() || chicken.m_28264_()) continue;
            chicken.f_28231_ = (int)((long)chicken.f_28231_ - timePassed);
        }
        int n = level.m_46469_().m_46215_(GameRules.f_46143_);
        if (n == 0) {
            return;
        }
        long randomTicks = (int)((long)n * timePassed);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        if (!config.isCropsGrowingEnable()) {
            return;
        }
        for (int i = chunk.m_7103_().length - 1; i >= 0; --i) {
            LevelChunkSection section = chunk.m_7103_()[i];
            if (!section.m_63015_()) continue;
            int perBlockTicks = (int)(randomTicks / 4096L);
            int extraBlockTicks = (int)(randomTicks % 4096L);
            for (int y = 15; y >= 0; --y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState state = section.m_62982_(x, y, z);
                        if (!state.m_60823_()) continue;
                        blockPos.m_122178_(chunk.m_7697_().m_45604_() + x, section.m_63017_() + y, chunk.m_7697_().m_45605_() + z);
                        int blockTicks = perBlockTicks;
                        if (extraBlockTicks > 0) {
                            --extraBlockTicks;
                            ++blockTicks;
                        }
                        if (state.m_60734_() instanceof CropBlock) {
                            CropSimulator.simulate(blockTicks, chunk, (BlockPos)blockPos, state, (CropBlock)state.m_60734_());
                            continue;
                        }
                        if (state.m_60734_() instanceof StemBlock) {
                            StemSimulator.simulate(blockTicks, chunk, (BlockPos)blockPos, state, (StemBlock)state.m_60734_());
                            continue;
                        }
                        if (state.m_60713_(Blocks.f_50200_)) {
                            NetherWartSimulator.simulate(blockTicks, chunk, (BlockPos)blockPos, state);
                            continue;
                        }
                        if (state.m_60713_(Blocks.f_50685_)) {
                            BerryBushSimulator.simulate(blockTicks, chunk, (BlockPos)blockPos, state);
                            continue;
                        }
                        if (state.m_60713_(Blocks.f_50128_)) {
                            CactusSimulator.simulate(blockTicks, chunk, (BlockPos)blockPos, state, (CactusBlock)state.m_60734_());
                            continue;
                        }
                        if (state.m_60713_(Blocks.f_50130_)) {
                            SugarCaneSimulator.simulate(blockTicks, chunk, (BlockPos)blockPos, state, (SugarCaneBlock)state.m_60734_());
                            continue;
                        }
                        if (state.m_60713_(Blocks.f_50570_)) {
                            BambooSimulator.simulateSapling(blockTicks, chunk, (BlockPos)blockPos, state);
                            continue;
                        }
                        if (!state.m_60713_(Blocks.f_50571_)) continue;
                        BambooSimulator.simulate(blockTicks, chunk, (BlockPos)blockPos, state);
                    }
                }
            }
        }
    }
}

