/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.mixin;

import io.socol.presencenotrequired.api.TickableChunk;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public class ChunkSerializerMixin {
    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void onRead(ServerLevel level, PoiManager poi, ChunkPos pos, CompoundTag tag, CallbackInfoReturnable<ProtoChunk> cir) {
        ProtoChunk protoChunk = (ProtoChunk)cir.getReturnValue();
        TickableChunk chunk = (TickableChunk)protoChunk;
        long lastUpdateTime = tag.m_128425_("LastUpdateTime", 99) ? tag.m_128454_("LastUpdateTime") : -1L;
        chunk.setLastUpdateTime(lastUpdateTime);
        if (protoChunk instanceof ImposterProtoChunk) {
            ((TickableChunk)((ImposterProtoChunk)protoChunk).m_62768_()).setLastUpdateTime(lastUpdateTime);
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private static void onWrite(ServerLevel level, ChunkAccess chunkAccess, CallbackInfoReturnable<CompoundTag> cir) {
        TickableChunk chunk = (TickableChunk)chunkAccess;
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        if (chunk.getLastUpdateTime() != -1L) {
            tag.m_128356_("LastUpdateTime", chunk.getLastUpdateTime());
        }
    }
}

