/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.mixin;

import io.socol.presencenotrequired.api.TickableChunk;
import io.socol.presencenotrequired.simulate.ChunkLifeSimulator;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkAccess.class})
public class ChunkAccessMixin
implements TickableChunk {
    private long lastUpdateTime = -1L;

    @Inject(method={"incrementInhabitedTime"}, at={@At(value="HEAD")})
    public void onIncrementInhabitedTime(long time, CallbackInfo ci) {
        ChunkAccess chunk = (ChunkAccess)this;
        if (chunk instanceof LevelChunk) {
            Level level = ((LevelChunk)chunk).m_62953_();
            long currentTime = level.m_46467_();
            long timePassed = currentTime - this.lastUpdateTime;
            if (this.lastUpdateTime != -1L && timePassed > 1L) {
                if (!ChunkAccessMixin.nearChunksLoaded((LevelChunk)chunk)) {
                    return;
                }
                ChunkLifeSimulator.simulate((LevelChunk)chunk, timePassed);
            }
            this.lastUpdateTime = currentTime;
        }
    }

    private static boolean nearChunksLoaded(LevelChunk chunk) {
        Level level = chunk.m_62953_();
        ChunkPos pos = chunk.m_7697_();
        return level.m_7232_(pos.f_45578_ - 1, pos.f_45579_) && level.m_7232_(pos.f_45578_ + 1, pos.f_45579_) && level.m_7232_(pos.f_45578_, pos.f_45579_ - 1) && level.m_7232_(pos.f_45578_, pos.f_45579_ + 1);
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(long time) {
        this.lastUpdateTime = time;
    }
}

