/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired.mixin;

import io.socol.presencenotrequired.api.FurnaceAccess;
import io.socol.presencenotrequired.simulate.tile.FurnaceSimulator;
import io.socol.presencenotrequired.util.BlockEntityUtils;
import io.socol.presencenotrequired.util.ContainerUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin
implements FurnaceAccess {
    @Shadow
    protected NonNullList<ItemStack> f_58310_;
    @Shadow
    int f_58316_;
    @Shadow
    int f_58317_;
    @Shadow
    int f_58318_;
    @Shadow
    int f_58319_;
    @Shadow
    @Final
    private RecipeType<? extends AbstractCookingRecipe> f_58312_;
    @Shadow
    @Final
    private Object2IntOpenHashMap<ResourceLocation> f_58320_;

    @Shadow
    protected abstract int m_7743_(ItemStack var1);

    @Override
    public FurnaceSimulator createSimulator() {
        return new FurnaceSimulator(ContainerUtils.createContainer(this.f_58310_), this.f_58316_, this.f_58317_, this.f_58318_, this.f_58319_);
    }

    @Override
    public int getFuelBurnTime(ItemStack fuel) {
        return this.m_7743_(fuel);
    }

    @Override
    public RecipeType<? extends AbstractCookingRecipe> getRecipeType() {
        return this.f_58312_;
    }

    @Override
    public void apply(Level level, BlockPos pos, BlockState state, FurnaceSimulator simulator) {
        boolean oldLit = this.f_58316_ > 0;
        boolean dataChanged = simulator.isDataChanged();
        ContainerUtils.extractContainer(simulator.getContainer(), this.f_58310_);
        this.f_58316_ = simulator.getLitTime();
        this.f_58317_ = simulator.getLitDuration();
        this.f_58318_ = simulator.getCookingProgress();
        this.f_58319_ = simulator.getCookingTotalTime();
        for (Object2IntMap.Entry entry : simulator.getRecipesUsed().object2IntEntrySet()) {
            this.f_58320_.addTo((Object)((ResourceLocation)entry.getKey()), entry.getIntValue());
        }
        if (oldLit != this.f_58316_ > 0) {
            state = (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.f_58316_ > 0));
            level.m_7731_(pos, state, 3);
            dataChanged = true;
        }
        if (dataChanged) {
            BlockEntityUtils.markChanged(level, pos, state);
        }
    }
}

