/*
 * Decompiled with CFR 0.152.
 */
package io.socol.presencenotrequired;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class SimulationConfig {
    private final ForgeConfigSpec config;
    private final ForgeConfigSpec.BooleanValue furnaces;
    private final ForgeConfigSpec.BooleanValue brewingStands;
    private final ForgeConfigSpec.BooleanValue campfires;
    private final ForgeConfigSpec.BooleanValue mobGrowing;
    private final ForgeConfigSpec.BooleanValue chickenLayingEggs;
    private final ForgeConfigSpec.BooleanValue cropsGrowing;

    public SimulationConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("unloadedChunksProgress");
        this.furnaces = builder.comment("Furnaces smelt in unloaded chunks").define("furnacesSmelt", true);
        this.brewingStands = builder.comment("Brewing Stands brew in unloaded chunks").define("brewingStandsBrew", true);
        this.campfires = builder.comment("Campfires cook in unloaded chunks").define("campfiresCook", true);
        this.mobGrowing = builder.comment("Mobs grow in unloaded chunks").define("mobGrowing", true);
        this.chickenLayingEggs = builder.comment("Chickens lay eggs in unloaded chunks").define("chickenLayingEggs", true);
        this.cropsGrowing = builder.comment("Crops grow in unloaded chunks").define("cropsGrowing", true);
        builder.pop();
        this.config = builder.build();
    }

    public static SimulationConfig create() {
        SimulationConfig configImpl = new SimulationConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configImpl.config);
        return configImpl;
    }

    public boolean isFurnacesEnable() {
        return (Boolean)this.furnaces.get();
    }

    public boolean isBrewingStandsEnable() {
        return (Boolean)this.brewingStands.get();
    }

    public boolean isCampfiresEnable() {
        return (Boolean)this.campfires.get();
    }

    public boolean isMobGrowingEnable() {
        return (Boolean)this.mobGrowing.get();
    }

    public boolean isChickenEggLayingEnable() {
        return (Boolean)this.chickenLayingEggs.get();
    }

    public boolean isCropsGrowingEnable() {
        return (Boolean)this.cropsGrowing.get();
    }
}

