/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.world;

import com.github.alexthe668.cloudstorage.misc.CloudIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CSWorldData
extends SavedData {
    private static final String IDENTIFIER = "cloudstorage_world_data";
    private List<CloudIndex> privateClouds = new ArrayList<CloudIndex>();
    private List<CloudIndex> publicClouds = new ArrayList<CloudIndex>();
    private List<CloudIndex> lootClouds = new ArrayList<CloudIndex>();

    private CSWorldData() {
    }

    public static CSWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_142572_().m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            CSWorldData data = (CSWorldData)storage.m_164861_(CSWorldData::load, CSWorldData::new, IDENTIFIER);
            if (data != null) {
                data.m_77762_();
            }
            return data;
        }
        return null;
    }

    public static CSWorldData load(CompoundTag nbt) {
        CompoundTag innerTag;
        int i;
        ListTag listtag;
        CSWorldData data = new CSWorldData();
        if (nbt.m_128441_("PrivateClouds")) {
            listtag = nbt.m_128437_("PrivateClouds", 10);
            for (i = 0; i < listtag.size(); ++i) {
                innerTag = listtag.m_128728_(i);
                data.privateClouds.add(new CloudIndex(innerTag));
            }
        }
        if (nbt.m_128441_("PublicClouds")) {
            listtag = nbt.m_128437_("PublicClouds", 10);
            for (i = 0; i < listtag.size(); ++i) {
                innerTag = listtag.m_128728_(i);
                data.publicClouds.add(new CloudIndex(innerTag));
            }
        }
        if (nbt.m_128441_("LootClouds")) {
            listtag = nbt.m_128437_("LootClouds", 10);
            for (i = 0; i < listtag.size(); ++i) {
                innerTag = listtag.m_128728_(i);
                data.lootClouds.add(new CloudIndex(innerTag));
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag tag;
        ListTag listTag;
        if (!this.privateClouds.isEmpty()) {
            listTag = new ListTag();
            for (CloudIndex cloud : this.privateClouds) {
                tag = new CompoundTag();
                cloud.writeToNBT(tag);
                listTag.add((Object)tag);
            }
            compound.m_128365_("PrivateClouds", (Tag)listTag);
        }
        if (!this.publicClouds.isEmpty()) {
            listTag = new ListTag();
            for (CloudIndex cloud : this.publicClouds) {
                tag = new CompoundTag();
                cloud.writeToNBT(tag);
                listTag.add((Object)tag);
            }
            compound.m_128365_("PublicClouds", (Tag)listTag);
        }
        if (!this.lootClouds.isEmpty()) {
            listTag = new ListTag();
            for (CloudIndex cloud : this.lootClouds) {
                tag = new CompoundTag();
                cloud.writeToNBT(tag);
                listTag.add((Object)tag);
            }
            compound.m_128365_("LootClouds", (Tag)listTag);
        }
        return compound;
    }

    public CloudIndex getPrivateCloud(UUID player, int color) {
        for (CloudIndex cloud : this.privateClouds) {
            if (cloud.getBalloonColor() != color || !cloud.getPlayerUUID().equals(player)) continue;
            return cloud;
        }
        return null;
    }

    public void addPrivateCloud(CloudIndex cloud) {
        this.privateClouds.add(cloud);
    }

    public CloudIndex getPublicCloud(int color) {
        for (CloudIndex cloud : this.publicClouds) {
            if (cloud.getBalloonColor() != color) continue;
            return cloud;
        }
        return null;
    }

    public void addPublicCloud(CloudIndex cloud) {
        this.publicClouds.add(cloud);
    }

    public CloudIndex getLootCloud(UUID player, int color) {
        for (CloudIndex cloud : this.lootClouds) {
            if (cloud.getBalloonColor() != color || !cloud.getPlayerUUID().equals(player)) continue;
            return cloud;
        }
        return null;
    }

    public void addLootCloud(CloudIndex cloud) {
        this.lootClouds.add(cloud);
    }
}

