/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.network;

import com.github.alexthe668.cloudstorage.CloudStorage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageSortCloudChest {
    public int type;

    public MessageSortCloudChest(int type) {
        this.type = type;
    }

    public MessageSortCloudChest() {
    }

    public static MessageSortCloudChest read(FriendlyByteBuf buf) {
        return new MessageSortCloudChest(buf.readInt());
    }

    public static void write(MessageSortCloudChest message, FriendlyByteBuf buf) {
        buf.writeInt(message.type);
    }

    public static class Handler {
        public static void handle(MessageSortCloudChest message, Supplier<NetworkEvent.Context> context) {
            context.get().setPacketHandled(true);
            ServerPlayer player = context.get().getSender();
            if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                player = CloudStorage.PROXY.getClientSidePlayer();
            }
            if (player != null) {
                CloudStorage.PROXY.processSortPacket((Player)player, message.type);
            }
        }
    }
}

