/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.misc;

import com.github.alexthe668.cloudstorage.CommonProxy;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class DyeRandomlyLootFunction
extends LootItemConditionalFunction {
    DyeRandomlyLootFunction(LootItemCondition[] others) {
        super(others);
    }

    public LootItemFunctionType m_7162_() {
        return CommonProxy.DYE_RANDOMLY_LOOT_FUNCTION;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        Random random = context.m_78933_();
        Item item = stack.m_41720_();
        if (item instanceof DyeableLeatherItem) {
            DyeableLeatherItem leatherItem = (DyeableLeatherItem)item;
            leatherItem.m_41115_(stack, (int)(random.nextFloat() * 1.6777215E7f));
        }
        if (stack.m_41720_() == Items.f_42688_) {
            DyeColor dyecolor = (DyeColor)Util.m_137545_((Object[])DyeColor.values(), (Random)random);
            FireworkRocketItem.Shape shape = (FireworkRocketItem.Shape)Util.m_137545_((Object[])FireworkRocketItem.Shape.values(), (Random)random);
            int i = random.nextInt(3);
            return this.generateRandomFirework(stack, dyecolor, shape, i);
        }
        return stack;
    }

    private ItemStack generateRandomFirework(ItemStack firework, DyeColor color, FireworkRocketItem.Shape shape, int length) {
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag compoundtag = itemstack1.m_41698_("Explosion");
        ArrayList list = Lists.newArrayList();
        list.add(color.m_41070_());
        compoundtag.m_128408_("Colors", (List)list);
        compoundtag.m_128344_("Type", (byte)shape.m_41236_());
        CompoundTag compoundtag1 = firework.m_41698_("Fireworks");
        ListTag listtag = new ListTag();
        CompoundTag compoundtag2 = itemstack1.m_41737_("Explosion");
        if (compoundtag2 != null) {
            listtag.add((Object)compoundtag2);
        }
        compoundtag1.m_128344_("Flight", (byte)length);
        if (!listtag.isEmpty()) {
            compoundtag1.m_128365_("Explosions", (Tag)listtag);
        }
        return firework;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<DyeRandomlyLootFunction> {
        public void serialize(JsonObject p_80454_, DyeRandomlyLootFunction p_80455_, JsonSerializationContext p_80456_) {
            super.m_6170_(p_80454_, (LootItemConditionalFunction)p_80455_, p_80456_);
        }

        public DyeRandomlyLootFunction deserialize(JsonObject p_80450_, JsonDeserializationContext p_80451_, LootItemCondition[] p_80452_) {
            return new DyeRandomlyLootFunction(p_80452_);
        }
    }
}

