/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity.ai;

import com.github.alexthe668.cloudstorage.entity.BadloonEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonFace;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class BadloonFearCactusGoal
extends Goal {
    private final int searchLength;
    private final int verticalSearchRange;
    protected BlockPos destinationBlock;
    protected int runDelay = 30;
    private Vec3 flightTarget;
    private BadloonEntity badloon;
    private float speed;

    public BadloonFearCactusGoal(BadloonEntity badloon, float speed) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.searchLength = 10;
        this.verticalSearchRange = 5;
        this.badloon = badloon;
        this.speed = speed;
    }

    public boolean m_8045_() {
        return this.destinationBlock != null && this.isCactus(this.badloon.f_19853_, this.destinationBlock.m_122032_()) && this.isCloseToCactus(10.0);
    }

    public boolean isCloseToCactus(double dist) {
        return this.destinationBlock == null || this.badloon.m_20238_(Vec3.m_82512_((Vec3i)this.destinationBlock)) < dist * dist;
    }

    public boolean m_8036_() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 40 + this.badloon.m_21187_().nextInt(70);
        return this.searchForDestination();
    }

    public Vec3 getPosAwayFrom(Vec3 fleePos, float radiusAdd) {
        float radius = -radiusAdd - (float)this.badloon.m_21187_().nextInt(5);
        float neg = this.badloon.m_21187_().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.badloon.f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.badloon.m_21187_().nextFloat() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos pos = new BlockPos(fleePos.m_7096_() + extraX, this.badloon.m_20186_(), fleePos.m_7094_() + extraZ);
        return Vec3.m_82512_((Vec3i)pos);
    }

    public void m_8056_() {
        Vec3 vec = this.getPosAwayFrom(Vec3.m_82512_((Vec3i)this.destinationBlock), 10.0f);
        this.badloon.setFace(BalloonFace.SCARED);
        if (vec != null) {
            this.flightTarget = vec;
            this.badloon.m_21566_().m_6849_(vec.f_82479_, vec.f_82480_, vec.f_82481_, (double)this.speed);
        }
    }

    public void m_8037_() {
        if (this.isCloseToCactus(10.0)) {
            Vec3 vec;
            this.badloon.setFace(BalloonFace.SCARED);
            if ((this.flightTarget == null || this.badloon.m_20238_(this.flightTarget) < 2.0) && (vec = this.getPosAwayFrom(Vec3.m_82512_((Vec3i)this.destinationBlock), 10.0f)) != null) {
                this.flightTarget = vec;
            }
            if (this.flightTarget != null) {
                this.badloon.m_21566_().m_6849_(this.flightTarget.f_82479_, this.flightTarget.f_82480_, this.flightTarget.f_82481_, (double)this.speed);
            }
        }
    }

    public void m_8041_() {
        this.flightTarget = null;
        this.badloon.setFace(BalloonFace.NEUTRAL);
        this.badloon.fearOfBeingPoppedCooldown = 100 + this.badloon.m_21187_().nextInt(100);
    }

    protected boolean searchForDestination() {
        int i = this.searchLength;
        int j = this.verticalSearchRange;
        BlockPos blockpos = this.badloon.m_142538_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = -5; k <= j; ++k) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, i1, k, j1);
                        if (this.badloon.m_21444_((BlockPos)blockpos$mutableblockpos) && this.isCactus(this.badloon.f_19853_, blockpos$mutableblockpos)) {
                            this.destinationBlock = blockpos$mutableblockpos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
        }
        return false;
    }

    private boolean isCactus(Level world, BlockPos.MutableBlockPos pos) {
        return world.m_8055_((BlockPos)pos).m_60713_(Blocks.f_50128_);
    }
}

