/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.block.CSBlockRegistry;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BalloonTieEntity
extends Entity {
    private static final EntityDataAccessor<Integer> BALLOON_COUNT = SynchedEntityData.m_135353_(BalloonTieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float popTick = 0.0f;
    private Vec3 randomMoveOffset = null;

    public BalloonTieEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public BalloonTieEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)CSEntityRegistry.BALLOON_TIE.get(), world);
    }

    public BalloonTieEntity(Level level, BlockPos pos) {
        this((EntityType)CSEntityRegistry.BALLOON_TIE.get(), level);
        this.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (!(this.f_19853_.f_46443_ || this.f_19797_ <= 5 || this.getBalloonCount() > 0 && (this.m_20075_().m_204336_(BlockTags.f_13039_) || this.m_20075_().m_60713_((Block)CSBlockRegistry.BALLOON_STAND.get())))) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void pushEntities() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                this.m_7334_(entity);
            }
        }
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BALLOON_COUNT, (Object)0);
    }

    public void setBalloonCount(int count) {
        this.f_19804_.m_135381_(BALLOON_COUNT, (Object)count);
    }

    public int getBalloonCount() {
        return (Integer)this.f_19804_.m_135370_(BALLOON_COUNT);
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float f) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        this.m_142687_(Entity.RemovalReason.KILLED);
        return true;
    }

    public static BalloonTieEntity getOrCreateKnot(Level level, BlockPos pos) {
        int k;
        int j;
        int i = pos.m_123341_();
        if (!level.m_45976_(LeashFenceKnotEntity.class, new AABB((double)i - 1.0, (double)(j = pos.m_123342_()) - 1.0, (double)(k = pos.m_123343_()) - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0)).isEmpty()) {
            return null;
        }
        for (BalloonTieEntity leashfenceknotentity : level.m_45976_(BalloonTieEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!leashfenceknotentity.m_142538_().equals((Object)pos)) continue;
            return leashfenceknotentity;
        }
        BalloonTieEntity leashfenceknotentity1 = new BalloonTieEntity(level, pos);
        if (level.m_8055_(pos).m_60734_() == CSBlockRegistry.BALLOON_STAND.get()) {
            leashfenceknotentity1.m_6034_(leashfenceknotentity1.m_20185_(), leashfenceknotentity1.m_20186_() + (double)0.3f, leashfenceknotentity1.m_20189_());
        }
        level.m_7967_((Entity)leashfenceknotentity1);
        return leashfenceknotentity1;
    }

    protected void m_7378_(CompoundTag compound) {
        this.setBalloonCount(compound.m_128451_("BalloonCount"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("BalloonCount", this.getBalloonCount());
    }

    public boolean m_7313_(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !this.f_19853_.m_7966_(player, this.m_142538_()) ? true : this.m_6469_(DamageSource.m_19344_((Player)player), 0.0f);
        }
        return false;
    }

    public ItemStack m_142340_() {
        return null;
    }
}

