/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.CommonProxy;
import com.github.alexthe668.cloudstorage.client.particle.CSParticleRegistry;
import com.github.alexthe668.cloudstorage.entity.BalloonCargoEntity;
import com.github.alexthe668.cloudstorage.entity.BalloonTieEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import com.github.alexthe668.cloudstorage.item.BalloonItem;
import com.github.alexthe668.cloudstorage.item.CSItemRegistry;
import com.github.alexthe668.cloudstorage.misc.CSSoundRegistry;
import com.github.alexthe668.cloudstorage.misc.CloudIndex;
import com.github.alexthe668.cloudstorage.world.CSWorldData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BalloonEntity
extends Entity {
    public static final int DEFAULT_STRING_LENGTH = 1;
    private static final EntityDataAccessor<Integer> BALLOON_COLOR = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> POPPED = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STRING_LENGTH = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> UPLOADING = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ARROW = SynchedEntityData.m_135353_(BalloonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float popTick = 0.0f;
    private float prevUploadProgress;
    private float uploadProgress;
    private Vec3 randomMoveOffset = null;
    private int arrowTime = 0;

    public BalloonEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public BalloonEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)CSEntityRegistry.BALLOON.get(), world);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.prevUploadProgress = this.uploadProgress;
        Entity child = this.getChild();
        if (!this.f_19853_.f_46443_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.05f, 0.0));
            if (child != null) {
                this.f_19804_.m_135381_(CHILD_ID, (Object)child.m_142049_());
                float f = 0.08f;
                if (child instanceof AbstractArrow) {
                    f = 0.1f;
                }
                if (this.m_20270_(child) > (float)this.getStringLength()) {
                    Vec3 back = child.m_20182_().m_82520_(0.0, (double)this.getStringLength(), 0.0).m_82546_(this.m_20182_());
                    this.m_20256_(this.m_20184_().m_82549_(back.m_82490_((double)f)));
                }
                if (this.isArrow() && !(child instanceof AbstractArrow)) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.1f, 0.0));
                    child.m_20256_(child.m_20184_().m_82520_(0.0, (double)0.1f, 0.0).m_82542_((double)0.7f, (double)0.7f, (double)0.7f));
                }
                if (child instanceof BalloonCargoEntity) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.08f, 0.0));
                }
            }
            if (this.randomMoveOffset == null || this.f_19796_.nextInt(20) == 0) {
                this.randomMoveOffset = new Vec3((double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f)).m_82541_();
            }
            this.pushEntities();
            if (this.randomMoveOffset != null) {
                Vec3 add = this.randomMoveOffset.m_82490_((double)0.003f);
                this.m_20256_(this.m_20184_().m_82549_(add));
            }
            if (!this.f_19853_.m_45756_((Entity)this, this.m_142469_())) {
                this.m_20314_(this.m_20185_(), (this.m_142469_().f_82289_ + this.m_142469_().f_82292_) / 2.0, this.m_20189_());
            }
            this.m_20256_(this.m_20184_().m_82542_((double)0.8f, (double)0.6f, (double)0.8f));
        } else if (this.isCharged()) {
            double d0 = (double)((this.f_19796_.nextFloat() - 0.5f) * this.m_20205_()) + this.m_20184_().f_82479_;
            double d1 = (double)((this.f_19796_.nextFloat() - 0.5f) * this.m_20206_() * 0.5f) + this.m_20184_().f_82480_;
            double d2 = (double)((this.f_19796_.nextFloat() - 0.5f) * this.m_20205_()) + this.m_20184_().f_82481_;
            double dist = 0.2f + this.f_19796_.nextFloat() * 0.2f;
            double d3 = d0 * dist;
            double d4 = d1 * dist;
            double d5 = d2 * dist;
            this.f_19853_.m_7106_((ParticleOptions)CSParticleRegistry.STATIC_LIGHTNING, this.m_20185_() + d0, this.m_20227_(1.0) + d1, this.m_20189_() + d2, d3, d4, d5);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (!this.f_19853_.f_46443_ && !this.isUploading() && this.m_20186_() > (double)(this.f_19853_.m_151558_() + 2) && this.f_19796_.nextInt(20) == 0) {
            if (child instanceof BalloonCargoEntity) {
                this.setUploading(true);
            } else {
                this.setPopped(true);
            }
        }
        if (this.isUploading() && this.uploadProgress < 10.0f) {
            this.uploadProgress += 0.25f;
        }
        if (!this.isUploading() && this.uploadProgress > 0.0f) {
            this.uploadProgress -= 1.0f;
        }
        if (this.isUploading()) {
            if (this.f_19853_.f_46443_) {
                for (int i = 0; i < 4; ++i) {
                    Vec3 vec = this.m_20182_().m_82520_(0.0, (double)(-1.0f - (float)this.getStringLength()), 0.0);
                    Vec3 vec1 = new Vec3((double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f), (double)(this.f_19796_.nextFloat() - 0.5f)).m_82490_(2.0).m_82549_(vec);
                    Vec3 vec32 = vec.m_82546_(vec1).m_82541_().m_82490_((double)0.3f);
                    this.f_19853_.m_7106_((ParticleOptions)CSParticleRegistry.BLOVIATOR_BREATH, vec1.f_82479_, vec1.f_82480_, vec1.f_82481_, vec32.f_82479_, vec32.f_82480_, vec32.f_82481_);
                }
            }
            if (this.uploadProgress >= 10.0f) {
                this.upload();
                this.setPopped(true);
            } else if (this.uploadProgress >= 5.0f) {
                this.m_20256_(Vec3.f_82478_);
            }
        }
        if (this.isPopped()) {
            if (this.popTick == 0.0f && !this.m_20067_()) {
                this.m_5496_(CSSoundRegistry.BALLOON_POP, 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
            }
            this.popTick += 1.0f;
            if (this.popTick > 3.0f) {
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_7605_((Entity)this, (byte)67);
                    if (this.getStringLength() > 1) {
                        this.m_19983_(new ItemStack((ItemLike)Items.f_42401_, this.getStringLength() - 1));
                    }
                    if (child instanceof AbstractArrow) {
                        AbstractArrow arrow = (AbstractArrow)child;
                        arrow.m_20242_(false);
                    }
                } else {
                    int color = this.getBalloonColor();
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    for (int i = 0; i < 5 + this.f_19796_.nextInt(2) + 5; ++i) {
                        this.f_19853_.m_7106_((ParticleOptions)CSParticleRegistry.BALLOON_SHARD, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (double)r, (double)g, (double)b);
                    }
                }
                if (child instanceof BalloonTieEntity) {
                    BalloonTieEntity tie = (BalloonTieEntity)child;
                    tie.setBalloonCount(tie.getBalloonCount() - 1);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else if (this.isArrow() && child instanceof AbstractArrow) {
            boolean fast;
            AbstractArrow arrow = (AbstractArrow)child;
            boolean bl = fast = arrow.m_20184_().m_82556_() > (double)0.08f;
            if (fast) {
                arrow.m_20256_(arrow.m_20184_().m_82542_((double)0.98f, (double)0.98f, (double)0.98f));
                arrow.m_20242_(true);
            } else if (arrow.f_19797_ > 10) {
                arrow.m_20242_(false);
                this.setStringLength(1);
                this.setChildId(null);
                this.f_19804_.m_135381_(CHILD_ID, (Object)-1);
            }
        } else if (this.isArrow() && child != null) {
            if (this.arrowTime > 0) {
                --this.arrowTime;
            } else {
                this.setPopped(true);
            }
        }
        if (child == null && this.getStringLength() < 1) {
            this.setStringLength(1);
        }
    }

    private void upload() {
        CSWorldData data;
        BalloonCargoEntity cargo;
        Entity entity = this.getChild();
        if (entity instanceof BalloonCargoEntity && (cargo = (BalloonCargoEntity)entity).getPlayerUUID() != null && cargo.getContainerSize() > 0 && (data = CSWorldData.get(this.f_19853_)) != null) {
            Player player;
            CloudIndex prev;
            int maximum = this.isCharged() ? (Integer)CloudStorage.CONFIG.maxStaticCloudSlots.get() : (Integer)CloudStorage.CONFIG.maxCloudSlots.get();
            CloudIndex cloudIndex = prev = this.isCharged() ? data.getPublicCloud(this.getBalloonColor()) : data.getPrivateCloud(cargo.getPlayerUUID(), this.getBalloonColor());
            if (prev != null) {
                prev.resize(Math.min(prev.getContainerSize() + cargo.getContainerSize(), maximum));
                for (ItemStack stack : cargo.getContainerItems()) {
                    ItemStack add = prev.getContainer().m_19173_(stack);
                    if (add.m_41619_()) continue;
                    cargo.m_5552_(add, 0.5f);
                }
            } else {
                CloudIndex cloud = new CloudIndex(cargo.getPlayerUUID(), this.getBalloonColor(), Math.min(cargo.getContainerSize(), maximum));
                for (ItemStack stack : cargo.getContainerItems()) {
                    ItemStack add = cloud.getContainer().m_19173_(stack);
                    if (add.m_41619_()) continue;
                    cargo.m_5552_(add, 0.5f);
                }
                if (this.isCharged()) {
                    data.addPublicCloud(cloud);
                } else {
                    data.addPrivateCloud(cloud);
                }
            }
            if (this.f_19853_ instanceof ServerLevel && (player = this.f_19853_.m_46003_(cargo.getPlayerUUID())) instanceof ServerPlayer) {
                CommonProxy.UPLOAD_TRIGGER.trigger((ServerPlayer)player);
            }
            cargo.m_146870_();
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected boolean pushEntities() {
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_(0.5, 0.0, 0.5), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                this.m_7334_(entity);
            }
        }
        return !list.isEmpty();
    }

    public void m_7334_(Entity p_20293_) {
        if (!(this.m_20365_(p_20293_) || p_20293_.f_19794_ || this.f_19794_)) {
            double d1;
            double d0;
            double d2;
            BalloonEntity balloon;
            if (this.isCharged() && p_20293_ instanceof BalloonEntity && !(balloon = (BalloonEntity)p_20293_).isCharged()) {
                this.m_5496_(CSSoundRegistry.STATIC_SHOCK, 0.5f, this.f_19796_.nextFloat() * 0.25f + 0.9f);
                balloon.setCharged(true);
            }
            if ((d2 = Mth.m_14005_((double)(d0 = p_20293_.m_20185_() - this.m_20185_()), (double)(d1 = p_20293_.m_20189_() - this.m_20189_()))) >= (double)0.01f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.025f;
                d1 *= (double)0.025f;
                if (!this.m_20160_()) {
                    this.m_5997_(-d0, 0.0, -d1);
                }
                if (!p_20293_.m_20160_()) {
                    // empty if block
                }
            }
        }
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BALLOON_COLOR, (Object)15149353);
        this.f_19804_.m_135372_(POPPED, (Object)false);
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_ID, (Object)-1);
        this.f_19804_.m_135372_(STRING_LENGTH, (Object)1);
        this.f_19804_.m_135372_(CHARGED, (Object)false);
        this.f_19804_.m_135372_(UPLOADING, (Object)false);
        this.f_19804_.m_135372_(ARROW, (Object)false);
    }

    public int getBalloonColor() {
        return (Integer)this.f_19804_.m_135370_(BALLOON_COLOR);
    }

    public void setBalloonColor(int color) {
        this.f_19804_.m_135381_(BALLOON_COLOR, (Object)color);
    }

    public boolean isPopped() {
        return (Boolean)this.f_19804_.m_135370_(POPPED);
    }

    public void setPopped(boolean popped) {
        this.f_19804_.m_135381_(POPPED, (Object)popped);
    }

    public boolean isArrow() {
        return (Boolean)this.f_19804_.m_135370_(ARROW);
    }

    public void setArrow(boolean arrow) {
        this.f_19804_.m_135381_(ARROW, (Object)arrow);
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(CHARGED);
    }

    public void setCharged(boolean popped) {
        this.f_19804_.m_135381_(CHARGED, (Object)popped);
    }

    public int getStringLength() {
        return (Integer)this.f_19804_.m_135370_(STRING_LENGTH);
    }

    public void setStringLength(int length) {
        this.f_19804_.m_135381_(STRING_LENGTH, (Object)length);
    }

    public boolean isUploading() {
        return (Boolean)this.f_19804_.m_135370_(UPLOADING);
    }

    public void setUploading(boolean uploading) {
        this.f_19804_.m_135381_(UPLOADING, (Object)uploading);
    }

    public boolean m_20068_() {
        return true;
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getTieForRendering() {
        return this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(CHILD_ID)).intValue());
    }

    public boolean m_6087_() {
        return !(this.getChild() instanceof AbstractArrow);
    }

    public boolean m_6469_(DamageSource source, float f) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!source.m_19360_() || source.m_7640_() == null || this.getChildId() == null || !source.m_7640_().m_142081_().equals(this.getChildId())) {
            this.m_5834_();
            this.setPopped(true);
            return true;
        }
        return false;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42401_)) {
            this.setStringLength(this.getStringLength() + 1);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 67) {
            int color = this.getBalloonColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            for (int i = 0; i < 5 + this.f_19796_.nextInt(2) + 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)CSParticleRegistry.BALLOON_SHARD, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), (double)r, (double)g, (double)b);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public float getPopProgress(float partialTick) {
        if (this.popTick == 0.0f) {
            return 0.0f;
        }
        return (this.popTick + partialTick - 1.0f) / 3.0f;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("ChildUUID")) {
            this.setChildId(compound.m_128342_("ChildUUID"));
        }
        this.setBalloonColor(compound.m_128451_("BalloonColor"));
        this.setStringLength(compound.m_128451_("StringLength"));
        this.setCharged(compound.m_128471_("Charged"));
        this.setUploading(compound.m_128471_("Uploading"));
        this.setArrow(compound.m_128471_("Arrow"));
        this.arrowTime = compound.m_128451_("ArrowTime");
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.getChildId() != null) {
            compound.m_128362_("ChildUUID", this.getChildId());
        }
        compound.m_128405_("BalloonColor", this.getBalloonColor());
        compound.m_128405_("StringLength", this.getStringLength());
        compound.m_128379_("Charged", this.isCharged());
        compound.m_128379_("Uploading", this.isUploading());
        compound.m_128379_("Arrow", this.isArrow());
        compound.m_128405_("ArrowTime", this.arrowTime);
    }

    public boolean m_7313_(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !this.f_19853_.m_7966_(player, this.m_142538_()) || this.m_6469_(DamageSource.m_19344_((Player)player), 0.0f);
        }
        return false;
    }

    public ItemStack m_142340_() {
        ItemStack itemstack = new ItemStack((ItemLike)CSItemRegistry.BALLOON.get());
        ((BalloonItem)itemstack.m_41720_()).m_41115_(itemstack, this.getBalloonColor());
        return itemstack;
    }

    public float getUploadProgress(float partialTicks) {
        return (this.prevUploadProgress + (this.uploadProgress - this.prevUploadProgress) * partialTicks) / 10.0f;
    }

    public void setArrowTime(int timeIn) {
        this.arrowTime = timeIn;
    }
}

