/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.entity;

import com.github.alexthe668.cloudstorage.entity.BalloonEntity;
import com.github.alexthe668.cloudstorage.entity.CSEntityRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class BalloonCargoEntity
extends Entity {
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(BalloonCargoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Optional<UUID>> BALLOON_UUID = SynchedEntityData.m_135353_(BalloonCargoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID = SynchedEntityData.m_135353_(BalloonCargoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> BALLOON_ID = SynchedEntityData.m_135353_(BalloonCargoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int time;
    public boolean dropItem = true;
    @Nullable
    public CompoundTag blockData;
    private BlockState blockState = Blocks.f_49992_.m_49966_();
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    private int containerSize;
    private List<ItemStack> containerItems = new ArrayList<ItemStack>();

    public BalloonCargoEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public BalloonCargoEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType)CSEntityRegistry.BALLOON_CARGO.get(), world);
    }

    private BalloonCargoEntity(Level p_31953_, double p_31954_, double p_31955_, double p_31956_, BlockState p_31957_) {
        this((EntityType)CSEntityRegistry.BALLOON_CARGO.get(), p_31953_);
        this.blockState = p_31957_;
        this.f_19850_ = true;
        this.m_6034_(p_31954_, p_31955_, p_31956_);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = p_31954_;
        this.f_19855_ = p_31955_;
        this.f_19856_ = p_31956_;
        this.setStartPos(this.m_142538_());
    }

    public static BalloonCargoEntity createCargo(Level level, BlockPos pos, BlockState state, @Nullable CompoundTag tag) {
        BalloonCargoEntity fallingblockentity = new BalloonCargoEntity(level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, state.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : state);
        fallingblockentity.blockData = tag;
        level.m_7967_((Entity)fallingblockentity);
        return fallingblockentity;
    }

    public boolean m_6097_() {
        return false;
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    public void setStartPos(BlockPos p_31960_) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)p_31960_);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public void m_7334_(Entity entity) {
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Entity balloon = this.getBalloon();
        if (!this.f_19853_.f_46443_) {
            if (balloon == null || !balloon.m_6084_()) {
                FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (BlockState)this.blockState);
                fallingblockentity.f_31944_ = this.blockData;
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (balloon instanceof BalloonEntity) {
                float length = ((BalloonEntity)balloon).getStringLength();
                if (this.m_20270_(balloon) > length) {
                    Vec3 back = balloon.m_20182_().m_82520_(0.0, (double)(-length - 1.0f), 0.0).m_82546_(this.m_20182_());
                    this.m_20256_(this.m_20184_().m_82549_(back.m_82490_((double)0.08f)));
                }
            }
        }
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory p_31962_) {
        super.m_7976_(p_31962_);
        p_31962_.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public void m_141965_(ClientboundAddEntityPacket p_149654_) {
        super.m_141965_(p_149654_);
        this.blockState = Block.m_49803_((int)p_149654_.m_131509_());
        this.f_19850_ = true;
        double d0 = p_149654_.m_131500_();
        double d1 = p_149654_.m_131501_();
        double d2 = p_149654_.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_142538_());
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(PLAYER_UUID, Optional.empty());
        this.f_19804_.m_135372_(BALLOON_UUID, Optional.empty());
        this.f_19804_.m_135372_(BALLOON_ID, (Object)-1);
    }

    public boolean m_20068_() {
        return true;
    }

    public Entity getBalloon() {
        UUID id = this.getBalloonUUID();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    @Nullable
    public UUID getBalloonUUID() {
        return ((Optional)this.f_19804_.m_135370_(BALLOON_UUID)).orElse(null);
    }

    public void setBalloonUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(BALLOON_UUID, Optional.ofNullable(uniqueId));
    }

    @Nullable
    public UUID getPlayerUUID() {
        return ((Optional)this.f_19804_.m_135370_(PLAYER_UUID)).orElse(null);
    }

    public void setPlayerUUID(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PLAYER_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getBalloonForRendering() {
        return this.f_19853_.m_6815_(((Integer)this.f_19804_.m_135370_(BALLOON_ID)).intValue());
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        return InteractionResult.PASS;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("BalloonUUID")) {
            this.setBalloonUUID(compound.m_128342_("BalloonUUID"));
        }
        if (compound.m_128403_("PlayerUUID")) {
            this.setBalloonUUID(compound.m_128342_("PlayerUUID"));
        }
        this.blockState = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("BlockState"));
        this.time = compound.m_128451_("Time");
        if (compound.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = compound.m_128471_("HurtEntities");
            this.fallDamagePerDistance = compound.m_128457_("FallHurtAmount");
            this.fallDamageMax = compound.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (compound.m_128425_("DropItem", 99)) {
            this.dropItem = compound.m_128471_("DropItem");
        }
        if (compound.m_128425_("TileEntityData", 10)) {
            this.blockData = compound.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_50087_.m_49966_();
        }
        this.containerSize = compound.m_128451_("ContainerSize");
        ListTag tag = compound.m_128437_("ContainerItems", 10);
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag compoundtag = tag.m_128728_(i);
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
            this.containerItems.add(itemstack);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.getBalloonUUID() != null) {
            compound.m_128362_("BalloonUUID", this.getBalloonUUID());
        }
        if (this.getPlayerUUID() != null) {
            compound.m_128362_("PlayerUUID", this.getPlayerUUID());
        }
        compound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        compound.m_128405_("Time", this.time);
        compound.m_128379_("DropItem", this.dropItem);
        compound.m_128379_("HurtEntities", this.hurtEntities);
        compound.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        compound.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            compound.m_128365_("TileEntityData", (Tag)this.blockData);
        }
        compound.m_128405_("ContainerSize", this.containerSize);
        ListTag tag = new ListTag();
        for (int i = 0; i < this.containerItems.size(); ++i) {
            if (this.containerItems.get(i).m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            this.containerItems.get(i).m_41739_(compoundtag);
            tag.add((Object)compoundtag);
        }
        compound.m_128365_("ContainerItems", (Tag)tag);
    }

    public void copyContainerData(Container container) {
        this.containerSize = container.m_6643_();
        for (int i = 0; i < this.containerSize; ++i) {
            ItemStack at = container.m_8020_(i);
            if (at.m_41619_()) continue;
            this.containerItems.add(at);
        }
    }

    public List<ItemStack> getContainerItems() {
        return this.containerItems;
    }

    public int getContainerSize() {
        return this.containerSize;
    }
}

