/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.render;

import com.github.alexthe668.cloudstorage.block.AbstractCloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.block.CloudChestBlock;
import com.github.alexthe668.cloudstorage.block.StaticCloudChestBlockEntity;
import com.github.alexthe668.cloudstorage.client.model.BalloonModel;
import com.github.alexthe668.cloudstorage.client.model.CloudChestModel;
import com.github.alexthe668.cloudstorage.client.render.BalloonTextures;
import com.github.alexthe668.cloudstorage.client.render.StringRenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RenderCloudChest<T extends AbstractCloudChestBlockEntity>
implements BlockEntityRenderer<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cloudstorage:textures/entity/cloud_chest.png");
    private static final ResourceLocation TEXTURE_LIGHTNING = new ResourceLocation("cloudstorage:textures/entity/cloud_chest_static.png");
    private static CloudChestModel CHEST_MODEL = new CloudChestModel();
    private static final BalloonModel BALLOON_MODEL = new BalloonModel();

    public RenderCloudChest(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.m_85836_();
        Direction dir = (Direction)tileEntityIn.m_58900_().m_61143_((Property)CloudChestBlock.HORIZONTAL_FACING);
        if (dir == Direction.NORTH) {
            matrixStackIn.m_85837_(0.5, 1.5, 0.5);
        } else if (dir == Direction.EAST) {
            matrixStackIn.m_85837_(0.5, 1.5, 0.5);
        } else if (dir == Direction.SOUTH) {
            matrixStackIn.m_85837_(0.5, 1.5, 0.5);
        } else if (dir == Direction.WEST) {
            matrixStackIn.m_85837_(0.5, 1.5, 0.5);
        }
        if (((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).lastValidPlayer != null && ((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).hasBalloonFor(((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).lastValidPlayer)) {
            float ageInTicks = (float)((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).tickCount + partialTicks;
            float emerge = ((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).getEmergence(partialTicks);
            float scale = Mth.m_14036_((float)Mth.m_14116_((float)emerge), (float)0.5f, (float)1.0f);
            matrixStackIn.m_85836_();
            Vec3 swingVec = new Vec3(Math.sin(ageInTicks * 0.1f) * (double)0.2f, 0.0, Math.cos(ageInTicks * 0.1f) * (double)0.2f).m_82490_((double)emerge);
            int color = ((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).getBalloonFor(((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).lastValidPlayer);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            BALLOON_MODEL.setColor(r, g, b);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(scale, scale, scale);
            matrixStackIn.m_85837_(swingVec.f_82479_, (double)(2.8f * emerge - 1.3f), swingVec.f_82481_);
            float rotX = 0.0f;
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f + rotX));
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)BalloonTextures.BALLOON));
            BALLOON_MODEL.resetToDefaultPose();
            BALLOON_MODEL.m_7695_(matrixStackIn, ivertexbuilder, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            BALLOON_MODEL.setColor(1.0f, 1.0f, 1.0f);
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BalloonTextures.BALLOON_SHEEN));
            BALLOON_MODEL.m_7695_(matrixStackIn, ivertexbuilder2, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.75f);
            VertexConsumer ivertexbuilder3 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BalloonTextures.STRING_TIE));
            BALLOON_MODEL.m_7695_(matrixStackIn, ivertexbuilder3, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (((AbstractCloudChestBlockEntity)((Object)tileEntityIn)).hasLootBalloon()) {
                VertexConsumer ivertexbuilder4 = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BalloonTextures.LOOT));
                BALLOON_MODEL.m_7695_(matrixStackIn, ivertexbuilder4, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, -1.5, 0.0);
            Vec3 to = new Vec3(swingVec.f_82479_, (double)(1.5f * emerge + 0.2f), swingVec.f_82481_);
            StringRenderHelper.renderSting((Entity)Minecraft.m_91087_().f_91074_, to, partialTicks, matrixStackIn, bufferIn, Vec3.f_82478_, combinedLightIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85849_();
        }
        matrixStackIn.m_85837_(0.0, (double)1.0E-4f, 0.0);
        matrixStackIn.m_85845_(dir.m_122424_().m_122406_());
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStackIn.m_85836_();
        CHEST_MODEL.renderChest((AbstractCloudChestBlockEntity)((Object)tileEntityIn), partialTicks);
        CHEST_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (tileEntityIn instanceof StaticCloudChestBlockEntity) {
            CHEST_MODEL.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_173235_((ResourceLocation)TEXTURE_LIGHTNING)), 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }
}

