/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.cloudstorage.client.gui;

import com.github.alexthe668.cloudstorage.CloudStorage;
import com.github.alexthe668.cloudstorage.client.gui.CloudMiniButton;
import com.github.alexthe668.cloudstorage.inventory.CloudChestMenu;
import com.github.alexthe668.cloudstorage.network.MessageSearchCloudChest;
import com.github.alexthe668.cloudstorage.network.MessageSortCloudChest;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CloudChestScreen
extends AbstractContainerScreen<CloudChestMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cloudstorage:textures/gui/cloud_chest_gui.png");
    private final int slots;
    private float prevScrollOffs;
    private float scrollOffs;
    private boolean scrolling;
    private CloudMiniButton balloonButton;
    private CloudMiniButton sortButton;
    private CloudMiniButton searchButton;
    private EditBox searchBox;
    public int mode = 0;
    private boolean ignoreTextInput;

    public CloudChestScreen(CloudChestMenu menu, Inventory playerInv, Component component) {
        super((AbstractContainerMenu)menu, playerInv, component);
        this.f_97726_ = 195;
        this.f_97727_ = 222;
        this.f_97731_ = this.f_97727_ - 94;
        this.slots = CloudStorage.PROXY.getVisibleCloudSlots();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.resetButtons();
    }

    public void resetButtons() {
        this.m_169413_();
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.balloonButton = new CloudMiniButton((Screen)this, i + 174, j + 141, 0, button -> {
            this.searchFor("");
            this.mode = 0;
            this.resetButtons();
        });
        this.m_142416_((GuiEventListener)this.balloonButton);
        this.sortButton = new CloudMiniButton((Screen)this, i + 174, j + 141 + 16, 1, button -> {
            this.searchFor("");
            this.mode = 1;
            this.resetButtons();
        });
        this.m_142416_((GuiEventListener)this.sortButton);
        this.searchButton = new CloudMiniButton((Screen)this, i + 174, j + 141 + 32, 2, button -> {
            this.mode = 2;
            this.resetButtons();
        });
        this.m_142416_((GuiEventListener)this.searchButton);
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 82, this.f_97736_ + 6, 80, 9, (Component)new TranslatableComponent("itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(this.mode == 2);
        this.searchBox.m_94178_(this.mode == 2);
        this.searchBox.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.balloonButton.f_93623_ = this.mode != 0;
        this.sortButton.f_93623_ = this.mode != 1;
        this.searchButton.f_93623_ = this.mode != 2;
    }

    public void m_6305_(PoseStack stack, int x, int y, float partialTicks) {
        this.m_7333_(stack);
        this.m_7286_(stack, partialTicks, x, y);
        super.m_6305_(stack, x, y, partialTicks);
        this.renderGraySlots(stack, x, y);
        this.m_7025_(stack, x, y);
    }

    private void renderGraySlots(PoseStack poseStack, int x, int y) {
        this.m_93250_(this.m_93252_() + 300);
        RenderSystem.m_69482_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        int i = this.f_97735_;
        int j = this.f_97736_;
        int clampedSize = Math.min(this.slots, 54);
        int ySlots = clampedSize / 9;
        for (int k = 0; k < ySlots; ++k) {
            for (int l = 0; l < 9 && l + k * 9 < clampedSize; ++l) {
                if (!((CloudChestMenu)this.f_97732_).isSlotGray(l + k * 9)) continue;
                this.m_93228_(poseStack, i + 7 + l * 18, j + 17 + k * 18, 126, 222, 18, 18);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93250_(this.m_93252_() - 300);
    }

    public boolean m_5534_(char p_98521_, int p_98522_) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (this.mode != 2) {
            return false;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(p_98521_, p_98522_)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    private void refreshSearchResults() {
        String s = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        this.searchFor(s);
    }

    private void searchFor(String s) {
        ((CloudChestMenu)this.f_97732_).scrollTo(0.0f, true);
        CloudStorage.NETWORK_WRAPPER.sendToServer((Object)new MessageSearchCloudChest(s));
        ((CloudChestMenu)this.f_97732_).updateGrays((Player)this.f_96541_.f_91074_, s);
    }

    protected void m_7027_(PoseStack stack, int x, int y) {
        if (this.mode == 2) {
            this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("cloudstorage.container.cloud_chest.searchbar"), (float)this.f_97728_ + 20.0f, (float)this.f_97729_, 0x404040);
        } else {
            this.f_96547_.m_92889_(stack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
        }
        this.f_96547_.m_92889_(stack, this.f_169604_, (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    public boolean m_7933_(int p_98547_, int p_98548_, int p_98549_) {
        this.ignoreTextInput = false;
        if (this.mode == 2) {
            boolean flag = this.f_97734_ != null && this.f_97734_.m_6657_();
            boolean flag1 = InputConstants.m_84827_((int)p_98547_, (int)p_98548_).m_84876_().isPresent();
            if (flag && flag1 && this.m_97805_(p_98547_, p_98548_)) {
                this.ignoreTextInput = true;
                return true;
            }
            String s = this.searchBox.m_94155_();
            if (this.searchBox.m_7933_(p_98547_, p_98548_, p_98549_)) {
                if (!Objects.equals(s, this.searchBox.m_94155_())) {
                    this.refreshSearchResults();
                }
                return true;
            }
            return this.searchBox.m_93696_() && this.searchBox.m_94213_() && p_98547_ != 256 ? true : super.m_7933_(p_98547_, p_98548_, p_98549_);
        }
        return super.m_7933_(p_98547_, p_98548_, p_98549_);
    }

    public boolean m_7920_(int p_98612_, int p_98613_, int p_98614_) {
        this.ignoreTextInput = false;
        return super.m_7920_(p_98612_, p_98613_, p_98614_);
    }

    public boolean m_6050_(double p_98527_, double p_98528_, double p_98529_) {
        if (!this.canScroll()) {
            return false;
        }
        int i = (this.slots + 9 - 1) / 9 - 5;
        float f = (float)(p_98529_ / (double)i);
        this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
        ((CloudChestMenu)this.f_97732_).scrollTo(this.scrollOffs, true);
        return true;
    }

    public boolean m_7979_(double p_98535_, double p_98536_, int p_98537_, double p_98538_, double p_98539_) {
        if (this.scrolling) {
            int i = this.f_97736_ + 18;
            int j = i + 112;
            this.scrollOffs = ((float)p_98536_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            ((CloudChestMenu)this.f_97732_).scrollTo(this.scrollOffs, true);
            return true;
        }
        return super.m_7979_(p_98535_, p_98536_, p_98537_, p_98538_, p_98539_);
    }

    public boolean m_6375_(double x, double y, int mouseBtn) {
        if (mouseBtn == 0 && this.insideScrollbar(x, y)) {
            double d0 = x - (double)this.f_97735_;
            double d1 = y - (double)this.f_97736_;
            this.scrolling = this.canScroll();
        }
        return super.m_6375_(x, y, mouseBtn);
    }

    protected boolean insideScrollbar(double p_98524_, double p_98525_) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + 112;
        return p_98524_ >= (double)k && p_98525_ >= (double)l && p_98524_ < (double)i1 && p_98525_ < (double)j1;
    }

    private boolean canScroll() {
        return this.slots > 54;
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        int l;
        int k;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(poseStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int clampedSize = Math.min(this.slots, 54);
        int ySlots = clampedSize / 9;
        for (k = 0; k < ySlots; ++k) {
            for (l = 0; l < 9 && l + k * 9 < clampedSize; ++l) {
                boolean hidden = ((CloudChestMenu)this.f_97732_).isSlotGray(l + k * 9);
                this.m_93228_(poseStack, i + 7 + l * 18, j + 17 + k * 18, hidden ? 18 : 0, 222, 18, 18);
            }
        }
        k = j + 18;
        l = j + 130;
        float scrollOffsForRender = this.prevScrollOffs + (this.scrollOffs - this.prevScrollOffs) * partialTicks;
        this.m_93228_(poseStack, i + 175, k + (int)((float)(l - k - 17) * scrollOffsForRender), 232 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        if (this.mode == 2) {
            this.m_93228_(poseStack, i + 79, k - 14, 36, 222, 90, 12);
            this.searchBox.m_6305_(poseStack, x, y, partialTicks);
        }
    }

    public void m_7379_() {
        this.searchFor("");
        super.m_7379_();
    }

    protected void m_181908_() {
        if (this.prevScrollOffs != this.scrollOffs) {
            ((CloudChestMenu)this.f_97732_).updateGrays((Player)this.f_96541_.f_91074_, this.searchBox.m_94155_().toLowerCase(Locale.ROOT));
        }
        this.prevScrollOffs = this.scrollOffs;
        if (this.mode == 1) {
            this.mode = 0;
            ((CloudChestMenu)this.f_97732_).scrollTo(0.0f, true);
            CloudStorage.NETWORK_WRAPPER.sendToServer((Object)new MessageSortCloudChest(0));
            this.resetButtons();
        }
    }
}

