/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.networking;

import com.nitespring.bloodborne.common.items.bullets.BulletItem;
import com.nitespring.bloodborne.common.items.weapons.guns.GunItem;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ReloadPacket {
    private final int id;

    public ReloadPacket(FriendlyByteBuf buf) {
        this.id = buf.readInt();
    }

    public ReloadPacket(int id) {
        this.id = id;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer playerIn = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack mainHand = playerIn.m_21205_();
            ItemStack offHand = playerIn.m_21206_();
            if (mainHand.m_41720_() instanceof GunItem) {
                CompoundTag nbt = mainHand.m_41782_() ? mainHand.m_41783_() : new CompoundTag();
                if (!nbt.m_128441_("Charged")) {
                    nbt.m_128359_("Charged", ((BulletItem)this.findAmmo((Player)playerIn).m_41720_()).typeTag);
                    if (!playerIn.m_7500_()) {
                        this.findAmmo((Player)playerIn).m_41774_(1);
                    }
                    mainHand.m_41751_(nbt);
                }
                playerIn.m_36335_().m_41524_(mainHand.m_41720_(), 30);
            } else if (offHand.m_41720_() instanceof GunItem) {
                CompoundTag nbt = offHand.m_41782_() ? offHand.m_41783_() : new CompoundTag();
                if (!nbt.m_128441_("Charged")) {
                    nbt.m_128359_("Charged", ((BulletItem)this.findAmmo((Player)playerIn).m_41720_()).typeTag);
                    if (!playerIn.m_7500_()) {
                        this.findAmmo((Player)playerIn).m_41774_(1);
                    }
                    offHand.m_41751_(nbt);
                }
                playerIn.m_36335_().m_41524_(offHand.m_41720_(), 30);
                playerIn.f_19853_.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 1.5f, 1.8f);
            }
        });
        return true;
    }

    private ItemStack findAmmo(Player playerIn) {
        if (playerIn.m_21205_().m_41720_() instanceof BulletItem) {
            return playerIn.m_21205_();
        }
        if (playerIn.m_21206_().m_41720_() instanceof BulletItem) {
            return playerIn.m_21206_();
        }
        for (int i = 0; i < playerIn.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = playerIn.m_150109_().m_8020_(i);
            if (!(itemstack.m_41720_() instanceof BulletItem)) continue;
            return itemstack;
        }
        return null;
    }
}

