/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.core.helpers;

import com.nitespring.bloodborne.core.helpers.MathHelpers;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class AttackHitboxHelpers {
    private static final double d = (double)1.2f;
    private static final double angleVar = 0.2617993877991494;

    public static void LargeAttack(DamageSource source, float damage, float knockback, PathfinderMob entityIn, Vec3 pos0, double radius, double angleFirst, double angleLast, double hInf, double hSup) {
        AttackHitboxHelpers.LargeAttack(source, damage, knockback, entityIn, pos0, radius, angleFirst, angleLast, hInf, hSup, null, 0, 0, false);
    }

    public static void LargeAttack(DamageSource source, float damage, float knockback, PathfinderMob entityIn, Vec3 pos0, double radius, double angleFirst, double angleLast, double hInf, double hSup, boolean shouldBreakShield) {
        AttackHitboxHelpers.LargeAttack(source, damage, knockback, entityIn, pos0, radius, angleFirst, angleLast, hInf, hSup, null, 0, 0, shouldBreakShield);
    }

    public static void LargeAttack(DamageSource source, float damage, float knockback, PathfinderMob entityIn, Vec3 pos0, double radius, double angleFirst, double angleLast, double hInf, double hSup, @Nullable MobEffect effect, int duration, int amplification, boolean shouldBreakShield) {
        Vec2 knockVec = MathHelpers.OrizontalAimVector(MathHelpers.AimVector(new Vec3(-entityIn.m_20182_().f_82479_, -entityIn.m_20182_().f_82480_, -entityIn.m_20182_().f_82481_), new Vec3(-entityIn.m_5448_().m_20182_().f_82479_, -entityIn.m_5448_().m_20182_().f_82480_, -entityIn.m_5448_().m_20182_().f_82481_)));
        Vec2 aim = MathHelpers.OrizontalAimVector(entityIn.m_20154_());
        Level worldIn = entityIn.f_19853_;
        pos0.m_82520_(-0.5 * (double)aim.f_82470_, 0.0, -0.5 * (double)aim.f_82471_);
        ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
        int i = 0;
        while ((double)i <= radius / (double)1.2f) {
            int j = 0;
            while ((double)j <= (angleLast - angleFirst) / 0.2617993877991494) {
                double angle = angleFirst + 0.2617993877991494 * (double)j;
                double x = pos0.f_82479_ + (double)i * (double)1.2f * ((double)aim.f_82470_ * Math.cos(angle) - (double)aim.f_82471_ * Math.sin(angle));
                double z = pos0.f_82481_ + (double)i * (double)1.2f * ((double)aim.f_82471_ * Math.cos(angle) + (double)aim.f_82470_ * Math.sin(angle));
                int k = 0;
                while ((double)k <= (hSup - hInf) / (double)1.2f) {
                    double y = pos0.f_82480_ + hInf + (double)k * (double)1.2f;
                    AABB scanAbove = new AABB(x - (double)1.2f, y - (double)4.8f, z - (double)1.2f, x + (double)1.2f, y + (double)2.4f, z + (double)1.2f);
                    ArrayList entities = new ArrayList(worldIn.m_45976_(LivingEntity.class, scanAbove));
                    if (!entities.isEmpty()) {
                        for (int n = 0; n < entities.size(); ++n) {
                            LivingEntity target = (LivingEntity)entities.get(n);
                            if (target == entityIn || entityIn.m_7307_((Entity)target) || target.m_7307_((Entity)entityIn) || hitEntities.contains(target)) continue;
                            target.m_6469_(source, damage);
                            if (target instanceof Player) {
                                AttackHitboxHelpers.maybeDisableShield(entityIn, (Player)target, entityIn.m_21205_(), target.m_6117_() ? target.m_21211_() : ItemStack.f_41583_, shouldBreakShield);
                            }
                            target.m_6703_((LivingEntity)entityIn);
                            target.m_147240_((double)knockback, (double)knockVec.f_82470_, (double)knockVec.f_82471_);
                            if (effect != null) {
                                target.m_147207_(new MobEffectInstance(effect, duration, amplification), (Entity)entityIn);
                            }
                            hitEntities.add(target);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void maybeDisableShield(PathfinderMob e, Player p, ItemStack attackerItem, ItemStack defenderItem, boolean shouldBreakShield) {
        if (!defenderItem.m_41619_() && defenderItem.m_41720_() instanceof ShieldItem && (shouldBreakShield || !attackerItem.m_41619_() && attackerItem.m_41720_() instanceof AxeItem || attackerItem.m_41720_().canDisableShield(attackerItem, defenderItem, (LivingEntity)p, (LivingEntity)e))) {
            p.m_36335_().m_41524_(p.m_21211_().m_41720_(), 100);
            e.f_19853_.m_7605_((Entity)p, (byte)30);
        }
    }

    public static void LargeAttackWithTargetCheck(DamageSource source, float damage, float knockback, PathfinderMob entityIn, Vec3 pos0, double radius, double angleFirst, double angleLast, double hInf, double hSup) {
        Vec2 knockVec = MathHelpers.OrizontalAimVector(MathHelpers.AimVector(new Vec3(-entityIn.m_20182_().f_82479_, -entityIn.m_20182_().f_82480_, -entityIn.m_20182_().f_82481_), new Vec3(-entityIn.m_5448_().m_20182_().f_82479_, -entityIn.m_5448_().m_20182_().f_82480_, -entityIn.m_5448_().m_20182_().f_82481_)));
        Vec2 aim = MathHelpers.OrizontalAimVector(entityIn.m_20154_());
        Level worldIn = entityIn.f_19853_;
        ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
        int i = 0;
        while ((double)i <= radius / (double)1.2f) {
            int j = 0;
            while ((double)j <= (angleLast - angleFirst) / 0.2617993877991494) {
                double angle = angleFirst + 0.2617993877991494 * (double)j;
                double x = pos0.f_82479_ + (double)i * (double)1.2f * ((double)aim.f_82470_ * Math.cos(angle) - (double)aim.f_82471_ * Math.sin(angle));
                double z = pos0.f_82481_ + (double)i * (double)1.2f * ((double)aim.f_82471_ * Math.cos(angle) + (double)aim.f_82470_ * Math.sin(angle));
                int k = 0;
                while ((double)k <= (hSup - hInf) / (double)1.2f) {
                    double y = pos0.f_82480_ + hInf + (double)k * (double)1.2f;
                    AABB scanAbove = new AABB(x - (double)1.2f, y - 4.0, z - (double)1.2f, x + (double)1.2f, y + 2.0, z + (double)1.2f);
                    ArrayList entities = new ArrayList(worldIn.m_45976_(LivingEntity.class, scanAbove));
                    if (!entities.isEmpty()) {
                        for (int n = 0; n < entities.size(); ++n) {
                            LivingEntity target = (LivingEntity)entities.get(n);
                            if (target != entityIn.m_5448_() || hitEntities.contains(target)) continue;
                            target.m_6469_(source, damage);
                            target.m_6703_((LivingEntity)entityIn);
                            target.m_147240_((double)knockback, (double)knockVec.f_82470_, (double)knockVec.f_82471_);
                            hitEntities.add(target);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void LongAttackWithTargetCheck(DamageSource source, float damage, float knockback, PathfinderMob entityIn, Vec3 pos0, double radius, double edgeS, double edgeR, double hInf, double hSup) {
        Vec2 knockVec = MathHelpers.OrizontalAimVector(MathHelpers.AimVector(new Vec3(-entityIn.m_20182_().f_82479_, -entityIn.m_20182_().f_82480_, -entityIn.m_20182_().f_82481_), new Vec3(-entityIn.m_5448_().m_20182_().f_82479_, -entityIn.m_5448_().m_20182_().f_82480_, -entityIn.m_5448_().m_20182_().f_82481_)));
        Vec2 aim = MathHelpers.OrizontalAimVector(entityIn.m_20154_());
        Level worldIn = entityIn.f_19853_;
        ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
        int i = 0;
        while ((double)i <= radius / (double)1.2f) {
            int j = Math.round(Math.round(edgeS / (double)1.2f));
            while ((double)j <= edgeR / (double)1.2f) {
                double angle = edgeR * Math.PI * -4.0 / 4.0 + 0.2617993877991494 * (double)j;
                double x = pos0.f_82479_ + (double)aim.f_82470_ * ((double)1.2f * (double)i + (double)1.2f * (double)j);
                double z = pos0.f_82481_ + (double)aim.f_82471_ * ((double)1.2f * (double)i + (double)1.2f * (double)j);
                int k = 0;
                while ((double)k <= (hSup - hInf) / (double)1.2f) {
                    double y = pos0.f_82480_ + hInf + (double)k * (double)1.2f;
                    AABB scanAbove = new AABB(x - (double)1.2f, y - 4.0, z - (double)1.2f, x + (double)1.2f, y + 2.0, z + (double)1.2f);
                    ArrayList entities = new ArrayList(worldIn.m_45976_(LivingEntity.class, scanAbove));
                    if (!entities.isEmpty()) {
                        for (int n = 0; n < entities.size(); ++n) {
                            LivingEntity target = (LivingEntity)entities.get(n);
                            if (target != entityIn.m_5448_() || hitEntities.contains(target)) continue;
                            target.m_6469_(source, damage);
                            target.m_6703_((LivingEntity)entityIn);
                            target.m_147240_((double)knockback, (double)knockVec.f_82470_, (double)knockVec.f_82471_);
                            hitEntities.add(target);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

