/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.core.helpers;

import com.nitespring.bloodborne.common.customdamage.CustomDamageType;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.common.items.weapons.parent.BloodborneWeapon;
import com.nitespring.bloodborne.config.CommonConfig;
import com.nitespring.bloodborne.core.helpers.MathHelpers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackDamageCalculators {
    public static void calculateAttackDamage(ItemStack stack, Player playerIn, Entity entityIn, float physIn, float fireIn, float boltIn, float arcaneIn, float bloodIn, float knockBackIn) {
        Vec2 knockVec = MathHelpers.OrizontalAimVector(MathHelpers.AimVector(new Vec3(-playerIn.m_20182_().f_82479_, -playerIn.m_20182_().f_82480_, -playerIn.m_20182_().f_82481_), new Vec3(-entityIn.m_20182_().f_82479_, -entityIn.m_20182_().f_82480_, -entityIn.m_20182_().f_82481_)));
        float damageModifier = AttackDamageCalculators.ultimateAttackDamageModifierCalculations(stack, playerIn, entityIn);
        entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)playerIn), physIn * damageModifier);
        entityIn.f_19802_ = 0;
        entityIn.m_6469_(CustomDamageType.FIRE_DAMAGE, fireIn * damageModifier);
        entityIn.f_19802_ = 0;
        entityIn.m_6469_(CustomDamageType.BOLT_DAMAGE, boltIn * damageModifier);
        entityIn.f_19802_ = 0;
        entityIn.m_6469_(CustomDamageType.ARCANE_DAMAGE, arcaneIn * damageModifier);
        entityIn.f_19802_ = 0;
        entityIn.m_6469_(CustomDamageType.BLOOD_DAMAGE, bloodIn * damageModifier);
        if (entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_6703_((LivingEntity)playerIn);
            ((LivingEntity)entityIn).m_147240_((double)(knockBackIn + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)stack)), (double)knockVec.f_82470_, (double)knockVec.f_82471_);
        }
    }

    public static float ultimateAttackDamageModifierCalculations(ItemStack stack, Player playerIn, Entity entityIn) {
        float swingProgressModifier = playerIn.m_36403_(0.0f);
        float effectModifier = 1.0f;
        float enchantmentsModifier = 1.0f;
        float mobModifier = 1.0f;
        float levelModifier = 1.0f;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BBLevel")) {
            int level = stack.m_41783_().m_128451_("BBLevel");
            levelModifier = (float)((double)levelModifier + (double)level * (Double)CommonConfig.upgrade_level_scaling.get());
        }
        if (playerIn.m_21023_(MobEffects.f_19600_)) {
            effectModifier += (float)(1 + playerIn.m_21124_(MobEffects.f_19600_).m_19564_()) * 0.2f;
        }
        if (playerIn.m_21023_(MobEffects.f_19613_)) {
            effectModifier -= (float)(1 + playerIn.m_21124_(MobEffects.f_19613_).m_19564_()) * 0.2f;
        }
        if (stack.m_41793_()) {
            if (entityIn instanceof LivingEntity) {
                MobType type = ((LivingEntity)entityIn).m_6336_();
                enchantmentsModifier += 0.1f * EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)type);
            }
            enchantmentsModifier += 0.1f * (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack);
        }
        if (entityIn instanceof AbstractBloodborneEntity && stack.m_41720_() instanceof BloodborneWeapon) {
            Item item = stack.m_41720_();
            if (((AbstractBloodborneEntity)entityIn).isBeastly() && ((BloodborneWeapon)item).isSerrated) {
                mobModifier += 0.2f;
            }
            if (((AbstractBloodborneEntity)entityIn).isCorrupted() && ((BloodborneWeapon)item).isRighteous) {
                mobModifier += 0.2f;
            }
        }
        float f = effectModifier * enchantmentsModifier * mobModifier * levelModifier * swingProgressModifier;
        if (((Boolean)CommonConfig.apply_dawncraft_patch.get()).booleanValue()) {
            f /= 2.0f;
        }
        return f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float calculateDisplayDamageValues(ItemStack stack) {
        float enchantmentsModifier = 1.0f;
        float levelModifier = 1.0f;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BBLevel")) {
            int level = stack.m_41783_().m_128451_("BBLevel");
            levelModifier = (float)((double)levelModifier + (double)level * (Double)CommonConfig.upgrade_level_scaling.get());
        }
        float f = (enchantmentsModifier += 0.1f * (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack)) * levelModifier;
        return f;
    }
}

