/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.core.events;

import com.mojang.math.Vector3f;
import com.nitespring.bloodborne.common.customdamage.CustomDamageType;
import com.nitespring.bloodborne.common.entities.mobs.boss.GascoigneBeastBossEntity;
import com.nitespring.bloodborne.common.entities.mobs.boss.MicolashBossEntity;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.common.entities.projectiles.CallBeyondProjectileEntity;
import com.nitespring.bloodborne.config.CommonConfig;
import java.util.Random;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bloodandmadness")
public class DamageEvents {
    @SubscribeEvent
    public static void bloodParticlesEvent(LivingHurtEvent event) {
        boolean spawnBlood = (Boolean)CommonConfig.spawn_blood_particles.get();
        if (spawnBlood) {
            LivingEntity target = event.getEntityLiving();
            Float damage = Float.valueOf(event.getAmount());
            DamageSource type = event.getSource();
            float maxLife = target.m_21233_();
            Random rng = target.m_21187_();
            int quantity = 50;
            if (damage.floatValue() <= 50000.0f) {
                ItemParticleOption blood = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42259_));
                if (type.m_19384_() || type == CustomDamageType.FIRE_DAMAGE) {
                    blood = ParticleTypes.f_123744_;
                } else if (type.m_19387_() || type == CustomDamageType.ARCANE_DAMAGE) {
                    blood = CallBeyondProjectileEntity.particle;
                } else if (type == CustomDamageType.BOLT_DAMAGE) {
                    blood = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f), 1.0f);
                } else if (type != DamageSource.f_19312_) {
                    Level world = target.f_19853_;
                    Vec3 pos = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
                    world.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11917_, SoundSource.AMBIENT, 0.2f, 0.4f, true);
                    if (target instanceof Skeleton) {
                        blood = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42499_));
                    }
                    if (target instanceof EnderMan || target instanceof EnderDragon || target instanceof Endermite) {
                        blood = ParticleTypes.f_123799_;
                    }
                    if (target instanceof Slime) {
                        blood = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42204_));
                    }
                    if (target instanceof MagmaCube || target instanceof Blaze) {
                        blood = ParticleTypes.f_123744_;
                    }
                    if (target instanceof AbstractGolem) {
                        blood = ParticleTypes.f_123809_;
                    }
                    if (target instanceof AbstractBloodborneEntity && ((AbstractBloodborneEntity)target).isKin()) {
                        blood = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_41932_));
                    }
                }
                float width = target.m_20205_() * 0.5f;
                float height = target.m_20206_() * 0.5f;
                Vec3 pos = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
                Level world = target.f_19853_;
                double size = width * height;
                double rand = 1.0 / (1.0 + (double)(rng.nextInt(10) - 4) * 0.1);
                int i = 0;
                while ((double)i < (double)((float)quantity * damage.floatValue()) * rand * size / (double)maxLife + (double)damage.floatValue() * 0.5) {
                    Vec3 off = new Vec3(rng.nextDouble() * (double)width - (double)(width / 2.0f), rng.nextDouble() * (double)height - (double)(height / 2.0f), rng.nextDouble() * (double)width - (double)(width / 2.0f));
                    if (world instanceof ServerLevel) {
                        ((ServerLevel)world).m_8767_((ParticleOptions)blood, pos.f_82479_, pos.f_82480_, pos.f_82481_, 5, off.f_82479_, off.f_82480_ + 0.05, off.f_82481_, 0.05 + (double)damage.floatValue() * 0.003);
                    }
                    ++i;
                }
            }
        }
    }

    @SubscribeEvent
    public static void addResistances(LivingDamageEvent event) {
        Float damage = Float.valueOf(event.getAmount());
        DamageSource type = event.getSource();
        if (type.m_146707_() && event.getEntity() instanceof GascoigneBeastBossEntity) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof AbstractBloodborneEntity) {
            AbstractBloodborneEntity target = (AbstractBloodborneEntity)event.getEntity();
            if (type.m_19384_() || type == CustomDamageType.FIRE_DAMAGE) {
                event.setAmount(damage.floatValue() * (float)(1 - target.fireRes() / 999));
            } else if (type.m_19387_() || type == CustomDamageType.ARCANE_DAMAGE) {
                event.setAmount(damage.floatValue() * (float)(1 - target.arcRes() / 999));
            } else if (type == CustomDamageType.BOLT_DAMAGE || type == DamageSource.f_19306_) {
                event.setAmount(damage.floatValue() * (float)(1 - target.boltRes() / 999));
            } else if (type == CustomDamageType.BLOOD_DAMAGE) {
                event.setAmount(damage.floatValue() * (float)(1 - target.bloodRes() / 999));
            } else if (type != DamageSource.f_19312_) {
                event.setAmount(damage.floatValue() * (float)(1 - target.physRes() / 999));
            }
        }
    }

    public static void MicolashTeleport(LivingDamageEvent event) {
        if (event.getEntity() instanceof MicolashBossEntity) {
            ((MicolashBossEntity)event.getEntity()).teleport();
        }
    }
}

