/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.items.weapons.special;

import com.nitespring.bloodborne.client.render.items.animatedweapons.ThreadedCaneGeoRenderer;
import com.nitespring.bloodborne.common.items.weapons.parent.IAnimatedWeapon;
import com.nitespring.bloodborne.common.items.weapons.parent.TrickWeapon;
import com.nitespring.bloodborne.core.init.WeaponInit;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.renderers.geo.GeoItemRenderer;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ThreadedCaneWhip
extends TrickWeapon
implements IAnimatedWeapon,
IAnimatable,
ISyncable {
    public static final String CONTROLLER_NAME = "swingController";
    private static final int SWING = 0;
    public AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ThreadedCaneWhip(float physicalDamageIn, float fireDamageIn, float boltDamageIn, float arcaneDamageIn, float bloodDamageIn, float attackSpeedIn, float knockbackIn, boolean isSerrated, boolean isRighteous, Item.Properties properties) {
        super(physicalDamageIn, fireDamageIn, boltDamageIn, arcaneDamageIn, bloodDamageIn, attackSpeedIn, knockbackIn, isSerrated, isRighteous, properties);
        GeckoLibNetwork.registerSyncable((ForgeRegistryEntry)this);
    }

    private <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, CONTROLLER_NAME, 1.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void leftClickAnimatedAction(Player playerIn, ItemStack mainHand) {
        Level worldIn = playerIn.f_19853_;
        if (!worldIn.f_46443_) {
            int id = GeckoLibUtil.guaranteeIDForStack((ItemStack)mainHand, (ServerLevel)((ServerLevel)worldIn));
            PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerIn);
            GeckoLibNetwork.syncAnimation((PacketDistributor.PacketTarget)target, (ISyncable)this, (int)id, (int)0);
        }
    }

    public void onAnimationSync(int id, int state) {
        AnimationController controller;
        if (state == 0 && (controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)CONTROLLER_NAME)).getAnimationState() == AnimationState.Stopped) {
            Minecraft instance = Minecraft.m_91087_();
            LocalPlayer player = instance.f_91074_;
            if (player != null) {
                // empty if block
            }
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.threaded_cane_trick.swing", Boolean.valueOf(false)));
        }
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final GeoItemRenderer<ThreadedCaneWhip> renderer = new ThreadedCaneGeoRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    @Override
    public Item getTransformedWeapon() {
        return (Item)WeaponInit.THREADED_CANE_CANE.get();
    }
}

