/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.items.weapons.parent;

import com.nitespring.bloodborne.common.items.weapons.parent.BloodborneWeapon;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TrickWeapon
extends BloodborneWeapon {
    public abstract Item getTransformedWeapon();

    public TrickWeapon(float physicalDamageIn, float fireDamageIn, float boltDamageIn, float arcaneDamageIn, float bloodDamageIn, float attackSpeedIn, float knockbackIn, boolean isSerrated, boolean isRighteous, Item.Properties properties) {
        this(physicalDamageIn, fireDamageIn, boltDamageIn, arcaneDamageIn, bloodDamageIn, attackSpeedIn, knockbackIn, isSerrated, isRighteous, 0, properties);
    }

    public TrickWeapon(float physicalDamageIn, float fireDamageIn, float boltDamageIn, float arcaneDamageIn, float bloodDamageIn, float attackSpeedIn, float knockbackIn, boolean isSerrated, boolean isRighteous, int repairType, Item.Properties properties) {
        super(physicalDamageIn, fireDamageIn, boltDamageIn, arcaneDamageIn, bloodDamageIn, attackSpeedIn, knockbackIn, isSerrated, isRighteous, repairType, properties);
    }

    public SoundEvent m_142602_() {
        return SoundEvents.f_11672_;
    }

    public void transform(Player playerIn, Level worldIn) {
        ItemStack itemstack = playerIn.m_21120_(InteractionHand.MAIN_HAND);
        Component name = itemstack.m_41611_();
        CompoundTag compound = itemstack.m_41783_();
        Vec3 pos = playerIn.m_20182_();
        ItemStack trick = new ItemStack((ItemLike)this.getTransformedWeapon(), 1, compound).m_41714_(name);
        playerIn.m_21008_(InteractionHand.MAIN_HAND, trick);
        trick.m_41751_(compound);
        this.playTrickSound(worldIn, pos);
    }

    public void playTrickSound(Level worldIn, Vec3 pos) {
        worldIn.m_6263_((Player)null, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.m_142602_(), SoundSource.PLAYERS, 0.6f, 0.4f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        String info = "\u00a78\u00a7oPress left_alt to transform";
        tooltip.add((Component)new TextComponent(info));
        super.m_7373_(stack, p_41422_, tooltip, p_41424_);
    }
}

