/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.items.weapons.parent;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import com.nitespring.bloodborne.config.CommonConfig;
import com.nitespring.bloodborne.core.helpers.AttackDamageCalculators;
import com.nitespring.bloodborne.core.init.ItemInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BloodborneWeapon
extends Item {
    private final float attackDamage;
    private final float attackSpeed;
    private final float knockback;
    public final boolean isSerrated;
    public final boolean isRighteous;
    private final float physicalDamage;
    private final float fireDamage;
    private final float boltDamage;
    private final float arcaneDamage;
    private final float bloodDamage;
    private double dmgVar = (Double)CommonConfig.upgrade_level_scaling.get();
    private final int RepairType;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public BloodborneWeapon(float physicalDamageIn, float fireDamageIn, float boltDamageIn, float arcaneDamageIn, float bloodDamageIn, float attackSpeedIn, float knockbackIn, boolean isSerrated, boolean isRighteous, Item.Properties properties) {
        this(physicalDamageIn, fireDamageIn, boltDamageIn, arcaneDamageIn, bloodDamageIn, attackSpeedIn, knockbackIn, isSerrated, isRighteous, 0, properties);
    }

    public BloodborneWeapon(float physicalDamageIn, float fireDamageIn, float boltDamageIn, float arcaneDamageIn, float bloodDamageIn, float attackSpeedIn, float knockbackIn, boolean isSerrated, boolean isRighteous, int repairType, Item.Properties properties) {
        super(properties);
        this.physicalDamage = physicalDamageIn;
        this.fireDamage = fireDamageIn;
        this.arcaneDamage = arcaneDamageIn;
        this.boltDamage = boltDamageIn;
        this.bloodDamage = bloodDamageIn;
        this.attackDamage = physicalDamageIn + fireDamageIn + arcaneDamageIn + boltDamageIn + bloodDamageIn;
        this.attackSpeed = attackSpeedIn;
        this.knockback = knockbackIn;
        this.isSerrated = isSerrated;
        this.isRighteous = isRighteous;
        this.RepairType = repairType;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage - 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean m_6777_(BlockState p_195938_1_, Level p_195938_2_, BlockPos p_195938_3_, Player p_195938_4_) {
        return !p_195938_4_.m_7500_();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BBLevel")) {
            int level = stack.m_41783_().m_128451_("BBLevel");
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage * (1.0 + this.dmgVar * (double)level) - 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            ImmutableMultimap defaultModifiers = builder.build();
            return slot == EquipmentSlot.MAINHAND ? defaultModifiers : super.getAttributeModifiers(slot, stack);
        }
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        String string;
        if (this.isSerrated) {
            string = "\u00a77\u00a7oSerrated";
            tooltip.add((Component)new TextComponent(string));
        }
        if (this.isRighteous) {
            string = "\u00a77\u00a7oRighteous";
            tooltip.add((Component)new TextComponent(string));
        }
        String info = "\u00a78\u00a7oPress shift for more information";
        tooltip.add((Component)new TextComponent(info));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            float dmgModifier = AttackDamageCalculators.calculateDisplayDamageValues(stack);
            String dmgPhys = "\u00a77" + (double)Math.round((double)(this.physicalDamage * dmgModifier) * 100.0) / 100.0 + " Physical Damage";
            tooltip.add((Component)new TextComponent(dmgPhys));
            String dmgFire = "\u00a76" + (double)Math.round((double)(this.fireDamage * dmgModifier) * 100.0) / 100.0 + " Fire Damage";
            tooltip.add((Component)new TextComponent(dmgFire));
            String dmgLightning = "\u00a7b" + (double)Math.round((double)(this.boltDamage * dmgModifier) * 100.0) / 100.0 + " Bolt Damage";
            tooltip.add((Component)new TextComponent(dmgLightning));
            String dmgMagic = "\u00a73" + (double)Math.round((double)(this.arcaneDamage * dmgModifier) * 100.0) / 100.0 + " Arcane Damage";
            tooltip.add((Component)new TextComponent(dmgMagic));
            String dmgDark = "\u00a74" + (double)Math.round((double)(this.bloodDamage * dmgModifier) * 100.0) / 100.0 + " Blood Damage";
            tooltip.add((Component)new TextComponent(dmgDark));
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BBLevel")) {
            int level = stack.m_41783_().m_128451_("BBLevel");
            String string = " +" + level;
            return new TextComponent(new TranslatableComponent(this.m_5671_(stack)).getString().concat(string));
        }
        return super.m_7626_(stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if ((double)player.m_36403_(0.0f) >= 0.4) {
            AttackDamageCalculators.calculateAttackDamage(stack, player, entity, this.physicalDamage, this.fireDamage, this.boltDamage, this.arcaneDamage, this.bloodDamage, this.knockback);
            if (this.fireDamage > 0.0f) {
                entity.m_20254_(1);
            }
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)CommonConfig.weapon_durability.get();
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean m_5812_(ItemStack p_77636_1_) {
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public Rarity m_41460_(ItemStack p_41461_) {
        return Rarity.create((String)"WORKSHOP", (ChatFormatting)ChatFormatting.RED);
    }

    public boolean m_8096_(BlockState p_43298_) {
        return p_43298_.m_60713_(Blocks.f_50033_);
    }

    public float m_8102_(ItemStack p_43288_, BlockState p_43289_) {
        if (p_43289_.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        Material material = p_43289_.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !p_43289_.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_7579_(ItemStack p_43278_, LivingEntity p_43279_, LivingEntity p_43280_) {
        p_43278_.m_41622_(1, p_43280_, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack p_43282_, Level p_43283_, BlockState p_43284_, BlockPos p_43285_, LivingEntity p_43286_) {
        if (p_43284_.m_60800_((BlockGetter)p_43283_, p_43285_) != 0.0f) {
            p_43282_.m_41622_(2, p_43286_, p_43276_ -> p_43276_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Item getWeaponPart() {
        return ItemStack.f_41583_.m_41720_();
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.m_6473_();
    }

    public int m_6473_() {
        return 22;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentCategory.BREAKABLE || enchantment.f_44672_ == EnchantmentCategory.VANISHABLE || enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_6832_(ItemStack p_41402_, ItemStack p_41403_) {
        switch (this.RepairType) {
            case 1: {
                return p_41403_.m_41720_() == ItemInit.SIDERITE_INGOT.get() || super.m_6832_(p_41402_, p_41403_);
            }
            case 2: {
                return p_41403_.m_41720_() == Items.f_42398_ || super.m_6832_(p_41402_, p_41403_);
            }
        }
        return p_41403_.m_41720_() == ItemInit.STEEL_INGOT.get() || super.m_6832_(p_41402_, p_41403_);
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean m_41475_() {
        return true;
    }
}

