/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.items.weapons.guns;

import com.mojang.blaze3d.platform.InputConstants;
import com.nitespring.bloodborne.common.entities.projectiles.BulletProjectileEntity;
import com.nitespring.bloodborne.common.items.bullets.BulletItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GunItem
extends Item {
    public int lifeTime;
    public float damage;

    public GunItem(float bulletDamage, int bulletLifeTime, Item.Properties p_41383_) {
        super(p_41383_);
        this.damage = bulletDamage;
        this.lifeTime = bulletLifeTime;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        CompoundTag nbt;
        ItemStack stack = playerIn.m_21120_(handIn);
        if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("Charged")) {
            float levelModifier = 1.0f;
            if (nbt.m_128441_("BBLevel")) {
                int level = nbt.m_128451_("BBLevel");
                levelModifier += (float)level * 0.4f;
            }
            BulletItem item = BulletItem.getTypeByTag(nbt.m_128461_("Charged"));
            Vec3 aim = playerIn.m_20154_();
            BulletProjectileEntity bullet = new BulletProjectileEntity(BulletItem.getEntityByTag(nbt.m_128461_("Charged")), this.damage * levelModifier, (int)((float)this.lifeTime + item.lifeTime), item, false, (LivingEntity)playerIn, worldIn);
            bullet.m_6034_(playerIn.m_20182_().f_82479_ + aim.f_82479_ * 1.25, playerIn.m_20182_().f_82480_ + 1.5, playerIn.m_20182_().f_82481_ + aim.f_82481_ * 1.25);
            bullet.f_36813_ = aim.f_82479_ * 0.3;
            bullet.f_36814_ = aim.f_82480_ * 0.3;
            bullet.f_36815_ = aim.f_82481_ * 0.3;
            worldIn.m_5594_(null, playerIn.m_142538_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.6f);
            worldIn.m_7967_((Entity)bullet);
            nbt.m_128473_("Charged");
            playerIn.m_36335_().m_41524_(stack.m_41720_(), 20);
            playerIn.m_6674_(handIn);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Charged")) {
            String reload = "\u00a78Loaded";
            tooltip.add((Component)new TextComponent(reload));
        } else {
            String reloadTranslatable = "bloodandmadness.itemdescription.reload";
            tooltip.add((Component)new TranslatableComponent(reloadTranslatable));
        }
        String info = "\u00a78\u00a7oPress shift for more information";
        tooltip.add((Component)new TextComponent(info));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            float levelModifier = 1.0f;
            if (stack.m_41782_() && stack.m_41783_().m_128441_("BBLevel")) {
                int level = stack.m_41783_().m_128451_("BBLevel");
                levelModifier += (float)level * 0.4f;
            }
            String dmg = "\u00a77" + (double)Math.round((double)(this.damage * levelModifier) * 100.0) / 100.0 + " Base Damage";
            tooltip.add((Component)new TextComponent(dmg));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public boolean m_5812_(ItemStack p_77636_1_) {
        return false;
    }

    public Rarity m_41460_(ItemStack p_41461_) {
        return Rarity.create((String)"WORKSHOP", (ChatFormatting)ChatFormatting.RED);
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BBLevel")) {
            int level = stack.m_41783_().m_128451_("BBLevel");
            String string = " +" + level;
            return new TextComponent(new TranslatableComponent(this.m_5671_(stack)).getString().concat(string));
        }
        return super.m_7626_(stack);
    }
}

