/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.items.bullets;

import com.nitespring.bloodborne.common.entities.projectiles.BulletProjectileEntity;
import com.nitespring.bloodborne.core.init.ItemInit;
import com.nitespring.bloodborne.core.init.ProjectileInit;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BulletItem
extends Item {
    public final float baseDamage;
    public final float lifeTime;
    public final String typeTag;

    public BulletItem(String typeTag, float dmg, int lifeTime, Item.Properties p_41383_) {
        super(p_41383_);
        this.baseDamage = dmg;
        this.lifeTime = lifeTime;
        this.typeTag = typeTag;
    }

    public String getTypeTag() {
        return this.typeTag;
    }

    public void onHitTarget(float dmg, BulletProjectileEntity entity, LivingEntity owner, Entity target) {
        target.m_6469_(DamageSource.m_19340_((Entity)entity, (LivingEntity)owner), dmg + this.baseDamage);
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).m_6703_(owner);
        }
    }

    public static BulletItem getTypeByTag(String s) {
        switch (s) {
            case "Quicksilver": {
                return (BulletItem)((Object)ItemInit.QUICKSILVER_BULLET.get());
            }
            case "Copper": {
                return (BulletItem)((Object)ItemInit.COPPER_BULLET.get());
            }
            case "Iron": {
                return (BulletItem)((Object)ItemInit.IRON_BULLET.get());
            }
            case "Gold": {
                return (BulletItem)((Object)ItemInit.GOLDEN_BULLET.get());
            }
            case "Poisonous": {
                return (BulletItem)((Object)ItemInit.POISONOUS_BULLET.get());
            }
            case "Explosive": {
                return (BulletItem)((Object)ItemInit.EXPLOSIVE_BULLET.get());
            }
            case "Electric": {
                return (BulletItem)((Object)ItemInit.ELECTRIC_BULLET.get());
            }
            case "Netherite": {
                return (BulletItem)((Object)ItemInit.NETHERITE_BULLET.get());
            }
            case "Fire": {
                return (BulletItem)((Object)ItemInit.FIRE_BULLET.get());
            }
            case "Withering": {
                return (BulletItem)((Object)ItemInit.WITHERING_BULLET.get());
            }
            case "Glowing": {
                return (BulletItem)((Object)ItemInit.GLOWING_BULLET.get());
            }
            case "Sniper": {
                return (BulletItem)((Object)ItemInit.SNIPER_BULLET.get());
            }
        }
        return null;
    }

    public static EntityType<? extends AbstractHurtingProjectile> getEntityByTag(String s) {
        switch (s) {
            case "Fire": {
                return (EntityType)ProjectileInit.FIRE_BULLET_ENTITY.get();
            }
            case "Explosive": {
                return (EntityType)ProjectileInit.EXPLOSIVE_BULLET_ENTITY.get();
            }
        }
        return (EntityType)ProjectileInit.BULLET_ENTITY.get();
    }

    public Rarity m_41460_(ItemStack p_41461_) {
        return Rarity.create((String)"WORKSHOP", (ChatFormatting)ChatFormatting.RED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        String dmg = "\u00a77" + (double)Math.round((double)this.baseDamage * 100.0) / 100.0 + " Damage";
        tooltip.add((Component)new TextComponent(dmg));
    }
}

