/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.items;

import com.nitespring.bloodborne.client.render.items.MusicBoxGeoRenderer;
import com.nitespring.bloodborne.common.entities.mobs.boss.FatherGascoigneBossEntity;
import com.nitespring.bloodborne.common.entities.mobs.boss.GascoigneBeastBossEntity;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.core.init.CourtOfAzathoth;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistryEntry;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.network.GeckoLibNetwork;
import software.bernie.geckolib3.network.ISyncable;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MusicBoxItem
extends Item
implements IAnimatable,
ISyncable {
    private static final String CONTROLLER_NAME = "controller";
    private static final int ANIM_PLAY = 0;
    public AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public MusicBoxItem(Item.Properties properties) {
        super(properties);
        GeckoLibNetwork.registerSyncable((ForgeRegistryEntry)this);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new MusicBoxGeoRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    private <P extends Item> PlayState predicate(AnimationEvent<P> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, CONTROLLER_NAME, 1.0f, this::predicate);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_5496_(SoundEvents.f_12088_, 0.4f, 0.4f);
        this.doShit(world, player, hand);
        return super.m_7203_(world, player, hand);
    }

    public void doShit(Level world, Player player, InteractionHand hand) {
        Vec3 pos = player.m_20182_();
        double d = 50.0;
        AABB scanAbove = new AABB(pos.f_82479_ - d, pos.f_82480_ - 4.0 * d, pos.f_82481_ - d, pos.f_82479_ + d, pos.f_82480_ + 2.0 * d, pos.f_82481_ + d);
        ArrayList entities = new ArrayList(world.m_45976_(AbstractBloodborneEntity.class, scanAbove));
        for (int n = 0; n < entities.size(); ++n) {
            AbstractBloodborneEntity target = (AbstractBloodborneEntity)((Object)entities.get(n));
            if (!(target instanceof GascoigneBeastBossEntity) && !(target instanceof FatherGascoigneBossEntity)) continue;
            target.setAnimationState(5);
        }
        player.m_5496_((SoundEvent)CourtOfAzathoth.MUSIC_BOX.get(), 1.0f, 1.0f);
        player.m_36335_().m_41524_((Item)this, 600);
        if (!world.f_46443_) {
            ItemStack stack = player.m_21120_(hand);
            int id = GeckoLibUtil.guaranteeIDForStack((ItemStack)stack, (ServerLevel)((ServerLevel)world));
            PacketDistributor.PacketTarget target = PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player);
            GeckoLibNetwork.syncAnimation((PacketDistributor.PacketTarget)target, (ISyncable)this, (int)id, (int)0);
        }
    }

    public void onAnimationSync(int id, int state) {
        AnimationController controller;
        if (state == 0 && (controller = GeckoLibUtil.getControllerForID((AnimationFactory)this.factory, (Integer)id, (String)CONTROLLER_NAME)).getAnimationState() == AnimationState.Stopped) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            controller.markNeedsReload();
            controller.setAnimation(new AnimationBuilder().addAnimation("animation.music_box.play_new", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level p_77624_2_, List<Component> tooltip, TooltipFlag p_77624_4_) {
        super.m_7373_(stack, p_77624_2_, tooltip, p_77624_4_);
        String text = "\u00a75Plays a soothing lullaby";
        tooltip.add((Component)new TextComponent(text));
        String info = "\u00a78\u00a7oIt appears to have a special connection to the Old Hunter Father Gascoigne's past";
        tooltip.add((Component)new TextComponent(info));
        String text1 = "\u00a75\u00a7oIn order to survive the beastly scourge, one must not forget their own past";
        tooltip.add((Component)new TextComponent(text1));
    }

    public Rarity m_41460_(ItemStack p_77613_1_) {
        return Rarity.RARE;
    }
}

