/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.projectiles;

import com.nitespring.bloodborne.common.entities.GenericAnimatedEntity;
import com.nitespring.bloodborne.common.entities.projectiles.AugurOfEbrietasProjectileEntity;
import com.nitespring.bloodborne.core.init.ProjectileInit;
import java.util.Random;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class AugurOfEbrietasEntity
extends GenericAnimatedEntity
implements IAnimatable,
IAnimationTickable {
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private Vec3 aim = new Vec3(0.0, 1.0, 0.0);
    private final float damage;
    private int lifetime = 30;
    public boolean isPersistent = true;

    public AugurOfEbrietasEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.damage = 6.0f;
    }

    public AugurOfEbrietasEntity(EntityType<?> p_19870_, Level p_19871_, float damageIn) {
        super(p_19870_, p_19871_);
        this.damage = damageIn;
    }

    public AugurOfEbrietasEntity(EntityType<?> e, Level level, float damageIn, int i) {
        this(e, level, damageIn);
        this.lifetime = i;
        this.isPersistent = false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int animState = this.getAnimationState();
        switch (animState) {
            case 1: {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.augur_of_ebrietas.loop", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                break;
            }
            default: {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.augur_of_ebrietas.start", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 1.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getOwner() != null && this.getOwner() instanceof Player) {
            Player playerIn = (Player)this.getOwner();
            if (playerIn.m_6117_()) {
                Vec3 pos = playerIn.m_20182_();
                Vec3 aim = playerIn.m_20154_();
                this.setAim(aim);
                this.m_6034_(pos.f_82479_ + 0.75 * aim.f_82479_, pos.f_82480_ + 1.25 + 0.75 * aim.f_82480_, pos.f_82481_ + 0.75 * aim.f_82481_);
                this.m_146926_(playerIn.m_5686_(1.0f) + 90.0f);
                this.m_146922_(180.0f - playerIn.m_5675_(1.0f));
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (this.livingTick >= 25) {
            AugurOfEbrietasProjectileEntity p = new AugurOfEbrietasProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.AUGUR_PROJECTILE.get()), this.f_19853_, this.damage, 8);
            p.m_146884_(this.m_20182_().m_82520_((double)new Random().nextFloat() * 0.5 - 0.25 - 0.26 * this.aim.f_82479_, (double)new Random().nextFloat() * 0.5 - 0.25 - 0.26 * this.aim.f_82480_, (double)new Random().nextFloat() * 0.5 - 0.25 - 0.26 * this.aim.f_82481_));
            p.m_20256_(this.getAim().m_82520_((double)new Random().nextFloat() * 0.6 - 0.3, (double)new Random().nextFloat() * 0.6 - 0.3, (double)new Random().nextFloat() * 0.6 - 0.3));
            if (this.getOwner() != null) {
                p.m_5602_((Entity)this.getOwner());
            }
            this.m_183503_().m_7967_((Entity)p);
            if (this.getAnimationState() != 1) {
                this.setAnimationState(1);
            }
        }
        if (!this.isPersistent && this.livingTick >= this.lifetime) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public Vec3 getAim() {
        return this.aim;
    }

    public void setAim(Vec3 aim) {
        this.aim = aim;
    }

    public int tickTimer() {
        return this.livingTick;
    }
}

