/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.mobs.parent;

import com.nitespring.bloodborne.common.entities.ai.teams.GetTargetByTeamGoal;
import com.nitespring.bloodborne.common.entities.ai.teams.HurtByTargetAlertTeamGoal;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class AbstractBloodborneEntity
extends PathfinderMob {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(AbstractBloodborneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(AbstractBloodborneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(AbstractBloodborneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BNMTEAM = SynchedEntityData.m_135353_(AbstractBloodborneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public abstract boolean isBoss();

    public abstract boolean isBeastly();

    public abstract boolean isCorrupted();

    public abstract boolean isKin();

    public abstract int physRes();

    public abstract int fireRes();

    public abstract int boltRes();

    public abstract int arcRes();

    public abstract int bloodRes();

    public AbstractBloodborneEntity(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.f_19811_ = true;
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    public int getBnMTeam() {
        return (Integer)this.f_19804_.m_135370_(BNMTEAM);
    }

    public void setBnMTeam(int anim) {
        this.f_19804_.m_135381_(BNMTEAM, (Object)anim);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
        this.f_19804_.m_135372_(BNMTEAM, (Object)this.getBnMDefaultTeam());
    }

    protected abstract int getBnMDefaultTeam();

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAnimationState(tag.m_128451_("AnimationId"));
        this.setCombatState(tag.m_128451_("CombatStateId"));
        this.setEntityState(tag.m_128451_("EntityStateId"));
        this.setBnMTeam(tag.m_128451_("BnMTeam"));
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AnimationId", this.getAnimationState());
        tag.m_128405_("CombatStateId", this.getCombatState());
        tag.m_128405_("EntityStateId", this.getEntityState());
        tag.m_128405_("BnMTeam", this.getBnMTeam());
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity p_33995_) {
        this.owner = p_33995_;
        this.ownerUUID = p_33995_.m_142081_();
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_6457_(ServerPlayer p_184178_1_) {
        super.m_6457_(p_184178_1_);
        if (this.isBoss()) {
            this.bossEvent.m_6543_(p_184178_1_);
        }
    }

    public void m_6452_(ServerPlayer p_184203_1_) {
        super.m_6452_(p_184203_1_);
        this.bossEvent.m_6539_(p_184203_1_);
    }

    public void m_8119_() {
        float h = this.m_21223_();
        this.bossEvent.m_142711_(h / this.m_21233_());
        super.m_8119_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        if (!this.serializeNBT().m_128441_("BnMTeam")) {
            this.setBnMTeam(this.getBnMDefaultTeam());
        }
        if (this.owner != null) {
            if (this.owner.serializeNBT().m_128441_("BnMTeam")) {
                this.setBnMTeam(this.owner.serializeNBT().m_128451_("BnMTeam"));
            } else if (this.owner instanceof Player) {
                this.setBnMTeam(4);
            }
        }
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public boolean m_7307_(Entity e) {
        if (this.getOwner() != null) {
            return this.getOwner().m_7307_(e);
        }
        if (this.serializeNBT().m_128441_("BnMTeam")) {
            int teamOwner = this.serializeNBT().m_128451_("BnMTeam");
            if (e.serializeNBT().m_128441_("BnMTeam")) {
                int teamTarget = e.serializeNBT().m_128451_("BnMTeam");
                switch (teamOwner) {
                    case 0: {
                        return super.m_7307_(e);
                    }
                    case 1: {
                        switch (teamTarget) {
                            case 1: 
                            case 3: {
                                return true;
                            }
                        }
                        return super.m_7307_(e);
                    }
                    case 2: {
                        switch (teamTarget) {
                            case 2: {
                                return true;
                            }
                        }
                        return super.m_7307_(e);
                    }
                    case 3: {
                        switch (teamTarget) {
                            case 1: 
                            case 3: {
                                return true;
                            }
                        }
                        return super.m_7307_(e);
                    }
                    case 6: {
                        switch (teamTarget) {
                            case 6: {
                                return true;
                            }
                        }
                        return super.m_7307_(e);
                    }
                }
                return super.m_7307_(e);
            }
            switch (teamOwner) {
                case 1: 
                case 3: {
                    if (!(e instanceof Villager) && (!(e instanceof IronGolem) || ((IronGolem)e).m_28876_())) break;
                    return true;
                }
            }
            return super.m_7307_(e);
        }
        return super.m_7307_(e);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 1.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetAlertTeamGoal(this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new CopyOwnerTargetGoal(this));
        this.f_21346_.m_25352_(2, new GetTargetByTeamGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
    }

    public static boolean checkHuntsmanSpawnRules(EntityType<? extends AbstractBloodborneEntity> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos p_219017_, Random p_219018_) {
        return p_219015_.m_46791_() != Difficulty.PEACEFUL && AbstractBloodborneEntity.isDarkEnoughToSpawn(p_219015_, p_219017_, p_219018_) && AbstractBloodborneEntity.m_21400_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)p_219017_, (Random)p_219018_);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends AbstractBloodborneEntity> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos p_219017_, Random p_219018_) {
        return p_219015_.m_46791_() != Difficulty.PEACEFUL && AbstractBloodborneEntity.isDarkEnoughToSpawn(p_219015_, p_219017_, p_219018_) && AbstractBloodborneEntity.m_21400_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)p_219017_, (Random)p_219018_);
    }

    public static boolean checkAnyLightMonsterSpawnRules(EntityType<? extends AbstractBloodborneEntity> p_219020_, LevelAccessor p_219021_, MobSpawnType p_219022_, BlockPos p_219023_, Random p_219024_) {
        return p_219021_.m_46791_() != Difficulty.PEACEFUL && AbstractBloodborneEntity.m_21400_(p_219020_, (LevelAccessor)p_219021_, (MobSpawnType)p_219022_, (BlockPos)p_219023_, (Random)p_219024_);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor p_33009_, BlockPos p_33010_, Random p_33011_) {
        if (p_33009_.m_45517_(LightLayer.SKY, p_33010_) > p_33011_.nextInt(32)) {
            return false;
        }
        if (p_33009_.m_45517_(LightLayer.BLOCK, p_33010_) > 0) {
            return false;
        }
        int i = p_33009_.m_6018_().m_46470_() ? p_33009_.m_46849_(p_33010_, 10) : p_33009_.m_46803_(p_33010_);
        return i <= p_33011_.nextInt(8);
    }

    public class CopyOwnerTargetGoal
    extends TargetGoal {
        private final TargetingConditions copyOwnerTargeting;

        public CopyOwnerTargetGoal(PathfinderMob p_34056_) {
            super((Mob)p_34056_, false);
            this.copyOwnerTargeting = TargetingConditions.m_148353_().m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            return AbstractBloodborneEntity.this.getOwner() != null && AbstractBloodborneEntity.this.getOwner() instanceof Mob && ((Mob)AbstractBloodborneEntity.this.getOwner()).m_5448_() != null && this.m_26150_(((Mob)AbstractBloodborneEntity.this.getOwner()).m_5448_(), this.copyOwnerTargeting);
        }

        public void m_8056_() {
            AbstractBloodborneEntity.this.m_6710_(((Mob)AbstractBloodborneEntity.this.getOwner()).m_5448_());
            super.m_8056_();
        }
    }
}

