/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.mobs.kin;

import com.mojang.math.Vector3f;
import com.nitespring.bloodborne.common.entities.mobs.kin.CelestialEmissary;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.common.entities.projectiles.BindingSpellProjectileEntity;
import com.nitespring.bloodborne.config.CommonConfig;
import com.nitespring.bloodborne.core.helpers.AttackHitboxHelpers;
import com.nitespring.bloodborne.core.init.EffectInit;
import com.nitespring.bloodborne.core.init.ProjectileInit;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Brainsucker
extends AbstractBloodborneEntity
implements IAnimatable {
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> CHARGE_LEVEL = SynchedEntityData.m_135353_(Brainsucker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Brainsucker(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.f_21364_ = 8;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int animState = this.getAnimationState();
        int entityState = this.getEntityState();
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
        } else {
            block0 : switch (animState) {
                case 11: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.transform", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 12: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.grab_continue", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                default: {
                    switch (entityState) {
                        case 1: {
                            switch (animState) {
                                case 21: {
                                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.attack_suck", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                                    break block0;
                                }
                                case 22: {
                                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.shoot_suck", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                                    break block0;
                                }
                                case 23: {
                                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.charge_suck", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                                    break block0;
                                }
                                case 24: {
                                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.grab_suck", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                                    break block0;
                                }
                            }
                            if (!(event.getLimbSwingAmount() > -0.06f) || !(event.getLimbSwingAmount() < 0.06f)) {
                                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.walk_suck", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                                break block0;
                            }
                            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.idle_suck", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                            break block0;
                        }
                    }
                    switch (animState) {
                        case 21: {
                            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.attack", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                            break block0;
                        }
                        case 22: {
                            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.shoot", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                            break block0;
                        }
                        case 23: {
                            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.charge", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                            break block0;
                        }
                        case 24: {
                            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.grab", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                            break block0;
                        }
                    }
                    if (!(event.getLimbSwingAmount() > -0.06f) || !(event.getLimbSwingAmount() < 0.06f)) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        break;
                    }
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.brainsucker.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 1.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int getChargeLevel() {
        return (Integer)this.f_19804_.m_135370_(CHARGE_LEVEL);
    }

    public void setChargeLevel(int anim) {
        this.f_19804_.m_135381_(CHARGE_LEVEL, (Object)anim);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE_LEVEL, (Object)0);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAnimationState(tag.m_128451_("ChargeLevel"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ChargeLevel", this.getAnimationState());
    }

    @Override
    public boolean isBoss() {
        return false;
    }

    @Override
    public boolean isBeastly() {
        return false;
    }

    @Override
    public boolean isCorrupted() {
        return false;
    }

    @Override
    public boolean isKin() {
        return true;
    }

    @Override
    public int physRes() {
        return 150;
    }

    @Override
    public int fireRes() {
        return 100;
    }

    @Override
    public int boltRes() {
        return -500;
    }

    @Override
    public int arcRes() {
        return 450;
    }

    @Override
    public int bloodRes() {
        return 100;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 30.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Cow.class, true));
        super.m_8099_();
    }

    @Override
    public boolean m_7307_(Entity p_32665_) {
        if (p_32665_ == null) {
            return false;
        }
        if (p_32665_ == this) {
            return true;
        }
        if (super.m_7307_(p_32665_)) {
            return true;
        }
        return p_32665_ instanceof Brainsucker || p_32665_ instanceof CelestialEmissary;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11911_;
    }

    protected SoundEvent m_7975_(DamageSource p_33579_) {
        return SoundEvents.f_12321_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11818_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12470_;
    }

    public static boolean checkBrainsuckerSpawnRules(EntityType<? extends AbstractBloodborneEntity> e, ServerLevelAccessor access, MobSpawnType type, BlockPos pos, Random r) {
        return Brainsucker.checkAnyLightMonsterSpawnRules(e, (LevelAccessor)access, type, pos, r) && (Boolean)CommonConfig.should_brainsucker_spawn.get() != false;
    }

    public void m_7332_(Entity p_184232_1_) {
        super.m_7332_(p_184232_1_);
        float f3 = (float)Math.sin(this.f_20883_ * ((float)Math.PI / 180));
        float f = (float)Math.cos(this.f_20883_ * ((float)Math.PI / 180));
        p_184232_1_.m_6034_(this.m_20185_() - (double)(1.0f * f3), this.m_20186_() - (double)0.4f, this.m_20189_() + (double)(1.0f * f));
    }

    @Override
    protected int getBnMDefaultTeam() {
        return 0;
    }

    public class AttackGoal
    extends Goal {
        private final double speedModifier = 1.0;
        private final boolean followingTargetEvenIfNotSeen = true;
        protected final Brainsucker mob;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int ticksUntilNextSpell;
        private int ticksUntilNextCharge;
        private int ticksUntilTransform;
        private int animTime = 0;

        public AttackGoal(Brainsucker entityIn) {
            this.mob = entityIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.f_19853_.m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            Objects.requireNonNull(this);
            if (!this.mob.m_21444_(livingentity.m_142538_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            if (this.mob.getEntityState() != 1) {
                this.ticksUntilTransform = 400;
            }
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            switch (animState) {
                case 11: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime < 16) break;
                    this.mob.setAnimationState(0);
                    this.mob.setEntityState(1);
                    this.animTime = 0;
                    break;
                }
                case 12: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    switch (this.animTime) {
                        case 12: 
                        case 24: 
                        case 36: 
                        case 48: 
                        case 64: {
                            target.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 4.0f);
                            this.mob.m_5496_(SoundEvents.f_11911_, 1.0f, 0.8f);
                        }
                    }
                    if (this.animTime <= 72) {
                        if (target.m_20159_()) {
                            if (target.m_20202_() != this.mob) {
                                target.m_8127_();
                                target.m_20329_((Entity)this.mob);
                            }
                        } else {
                            target.m_20329_((Entity)this.mob);
                        }
                        target.m_7313_((Entity)this.mob);
                        target.m_7292_(new MobEffectInstance((MobEffect)EffectInit.TRAPPED.get()));
                    }
                    if (this.animTime == 72) {
                        target.m_8127_();
                    }
                    if (this.animTime < 84) break;
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.animTime = 0;
                    break;
                }
                case 21: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime == 6) {
                        this.performAttack();
                    }
                    if (this.animTime < 10) break;
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.animTime = 0;
                    break;
                }
                case 22: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime == 4) {
                        this.performSpellAttack();
                        this.mob.setChargeLevel(this.mob.getChargeLevel() - 1);
                    }
                    if (this.animTime < 5) break;
                    this.mob.setAnimationState(0);
                    this.ticksUntilNextSpell = 35 - this.mob.getChargeLevel() * 8;
                    this.animTime = 0;
                    break;
                }
                case 23: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime == 10) {
                        this.createParticles();
                        this.mob.setChargeLevel(this.mob.getChargeLevel() + 1);
                        this.mob.m_5496_(SoundEvents.f_12376_, 1.0f, 0.2f);
                    }
                    if (this.animTime < 14) break;
                    this.mob.setAnimationState(0);
                    this.ticksUntilNextCharge = 30;
                    this.animTime = 0;
                    break;
                }
                case 24: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime < 12) break;
                    if (distance <= reach) {
                        this.mob.setAnimationState(12);
                        this.mob.setEntityState(1);
                        if (target.m_20159_()) {
                            target.m_8127_();
                        }
                        target.m_20329_((Entity)this.mob);
                        target.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 2.0f);
                    } else {
                        this.mob.setAnimationState(0);
                    }
                    this.animTime = 0;
                    break;
                }
                default: {
                    this.doMovement(target, reach);
                    this.checkForAttack(distance, reach);
                    if (this.mob.getEntityState() != 1) {
                        int r;
                        this.ticksUntilTransform = Math.max(this.ticksUntilTransform - 1, 0);
                        if (this.ticksUntilTransform <= 0 && (r = this.mob.m_21187_().nextInt(2048)) <= 40) {
                            this.mob.setAnimationState(11);
                        }
                    }
                    this.ticksUntilNextSpell = Math.max(this.ticksUntilNextSpell - 1, 0);
                    this.ticksUntilNextCharge = Math.max(this.ticksUntilNextCharge - 1, 0);
                }
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }

        private void checkForPreciseAttack() {
            if (this.ticksUntilNextAttack <= 0) {
                this.mob.setAnimationState(21);
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            Objects.requireNonNull(this);
            if (this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                if (this.mob.m_5448_().m_21023_((MobEffect)EffectInit.TRAPPED.get())) {
                    this.mob.setAnimationState(24);
                } else {
                    int r = this.mob.m_21187_().nextInt(2048);
                    if (r <= 1000) {
                        this.mob.setAnimationState(21);
                    } else {
                        this.mob.setAnimationState(24);
                    }
                }
            } else {
                int r;
                if (this.ticksUntilNextSpell <= 0 && this.mob.getChargeLevel() >= 1 && this.mob.m_21574_().m_148306_((Entity)this.mob.m_5448_()) && !this.mob.m_5448_().m_21023_((MobEffect)EffectInit.TRAPPED.get()) && (r = this.mob.m_21187_().nextInt(2048)) <= 200) {
                    this.mob.setAnimationState(22);
                }
                if (this.ticksUntilNextCharge <= 0 && this.mob.getChargeLevel() < 3 && (r = this.mob.m_21187_().nextInt(2048)) <= 500) {
                    this.mob.setAnimationState(23);
                }
            }
        }

        protected void performAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 6.0f, 0.6f, this.mob, pos, 2.5, -0.7853981633974483, 0.7853981633974483, -1.0, 3.0);
        }

        protected void performSpellAttack() {
            Vec3 pos = this.mob.m_20182_();
            Vec3 aim = this.mob.m_20154_();
            this.mob.m_5496_(SoundEvents.f_12376_, 1.0f, 0.2f);
            BindingSpellProjectileEntity spell = new BindingSpellProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.BINDING_SPELL.get()), Brainsucker.this.f_19853_, 1.0f);
            spell.m_146884_(pos.m_82520_(0.0, 1.25, 0.0).m_82549_(aim));
            spell.m_5602_((Entity)this.mob);
            spell.setTarget((Entity)this.mob.m_5448_());
            Brainsucker.this.f_19853_.m_7967_((Entity)spell);
        }

        private void createParticles() {
            Level worldIn = this.mob.f_19853_;
            DustParticleOptions lightning = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f), 1.0f);
            Vec3 pos = this.mob.m_20182_();
            double x0 = pos.f_82479_;
            double y0 = pos.f_82480_;
            double z0 = pos.f_82481_;
            for (int k = 0; k <= 64; ++k) {
                double x = x0 + 1.0 * Math.cos((double)k * Math.PI / 8.0);
                double y = y0 + 0.25;
                double z = z0 + 1.0 * Math.sin((double)k * Math.PI / 8.0);
                if (!(worldIn instanceof ServerLevel)) continue;
                ((ServerLevel)worldIn).m_8767_((ParticleOptions)lightning, x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 20;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + p_179512_1_.m_20205_();
        }
    }
}

