/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.mobs.huntsmen;

import com.nitespring.bloodborne.common.customdamage.CustomDamageType;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractHuntsmanEntity;
import com.nitespring.bloodborne.config.CommonConfig;
import com.nitespring.bloodborne.core.helpers.AttackHitboxHelpers;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class HuntsmanAxeEntity
extends AbstractHuntsmanEntity
implements IAnimatable,
IAnimationTickable {
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public HuntsmanAxeEntity(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.f_21364_ = 6;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int animState = this.getAnimationState();
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
        } else {
            switch (animState) {
                case 21: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.atk_heavy", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 22: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.atk_l1", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 23: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.atk_l2", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 24: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.atk_r1", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 25: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.atk_r2", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                default: {
                    if (!(event.getLimbSwingAmount() > -0.06f) || !(event.getLimbSwingAmount() < 0.06f)) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        break;
                    }
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState clothPredicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.huntsman_axe.cloth", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 2.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "cloth_controller", 10.0f, this::clothPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22277_, 30.0);
    }

    @Override
    protected int getBnMDefaultTeam() {
        return 1;
    }

    @Override
    public boolean isBoss() {
        return false;
    }

    @Override
    public boolean isBeastly() {
        return false;
    }

    @Override
    public boolean isCorrupted() {
        return false;
    }

    @Override
    public boolean isKin() {
        return false;
    }

    @Override
    public int physRes() {
        return 350;
    }

    @Override
    public int fireRes() {
        return 100;
    }

    @Override
    public int boltRes() {
        return 150;
    }

    @Override
    public int arcRes() {
        return 120;
    }

    @Override
    public int bloodRes() {
        return 180;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal(this, 0.4f, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.getHuntsmanGoals();
        super.m_8099_();
    }

    public static boolean checkHuntsmanAxeSpawnRules(EntityType<? extends AbstractBloodborneEntity> e, ServerLevelAccessor access, MobSpawnType type, BlockPos pos, Random r) {
        return HuntsmanAxeEntity.checkMonsterSpawnRules(e, access, type, pos, r) && (Boolean)CommonConfig.should_huntsman_axe_spawn.get() != false;
    }

    private class MeleeAttackGoal
    extends Goal {
        protected final HuntsmanAxeEntity mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;

        public MeleeAttackGoal(HuntsmanAxeEntity p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.f_19853_.m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_142538_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            Vec3 aim = this.mob.m_20154_();
            Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
            switch (animState) {
                case 20: {
                    this.tickRunToHeavyAttack();
                    break;
                }
                case 21: {
                    this.tickHeavyAttack();
                    break;
                }
                case 22: {
                    this.tickLightAttack();
                    break;
                }
                case 23: {
                    this.tickLightAttack2();
                    break;
                }
                case 24: {
                    this.tickTorchAttack();
                    break;
                }
                case 25: {
                    this.tickTorchAttack2();
                    break;
                }
                default: {
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                    this.checkForMediumRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                int r = this.mob.m_21187_().nextInt(2048);
                if (r <= 800) {
                    this.mob.setAnimationState(21);
                } else if (r <= 1300) {
                    this.mob.setAnimationState(22);
                } else if (r <= 1850) {
                    this.mob.setAnimationState(24);
                } else {
                    this.mob.setAnimationState(20);
                }
            }
        }

        protected void checkForMediumRangeAttack(double distance, double reach) {
            int r;
            if (distance <= 6.0 * reach && this.ticksUntilNextAttack <= 0 && (r = this.mob.m_21187_().nextInt(2048)) <= 120) {
                this.mob.setAnimationState(20);
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= 1.5 * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickLightAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.performLightAttack();
            }
            if (this.animTime >= 8) {
                this.animTime = 0;
                if (this.getRangeCheck()) {
                    this.mob.setAnimationState(23);
                } else {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.ticksUntilNextPathRecalculation = 0;
                }
            }
        }

        protected void tickLightAttack2() {
            ++this.animTime;
            if (this.animTime == 6) {
                this.performLightAttack();
            }
            if (this.animTime >= 10) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickRunToHeavyAttack() {
            ++this.animTime;
            this.doMovement((LivingEntity)this.mob, this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()));
            this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), 0.7);
            if (this.animTime >= 8 && (this.getRangeCheck() || this.animTime >= 70)) {
                this.animTime = 0;
                this.mob.setAnimationState(21);
                this.mob.m_21573_().m_26517_(1.0);
            }
        }

        protected void tickHeavyAttack() {
            ++this.animTime;
            if (this.animTime == 9) {
                this.performHeavyAttack();
            }
            if (this.animTime >= 17) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickTorchAttack() {
            ++this.animTime;
            if (this.animTime == 5) {
                this.performTorchAttack();
            }
            if (this.animTime >= 8) {
                this.animTime = 0;
                if (this.getRangeCheck()) {
                    this.mob.setAnimationState(25);
                } else {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                }
            }
        }

        protected void tickTorchAttack2() {
            ++this.animTime;
            if (this.animTime == 4) {
                this.performTorchAttack();
            }
            if (this.animTime >= 8) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }

        protected void performLightAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 6.0f, 0.2f, this.mob, pos, 2.5, -0.6283185307179586, 0.6283185307179586, -1.0, 3.0, true);
        }

        protected void performHeavyAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 8.0f, 0.5f, this.mob, pos, 3.0, -0.7853981633974483, 0.7853981633974483, -1.0, 3.5, true);
        }

        protected void performTorchAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_11937_, 1.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(CustomDamageType.FIRE_DAMAGE, 3.0f, 0.2f, this.mob, pos, 2.0, -0.6283185307179586, 0.6283185307179586, -1.0, 3.0, true);
            this.mob.m_5448_().m_20254_(10);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 20;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 20;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_179512_1_.m_20205_();
        }
    }
}

