/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.mobs.church;

import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.config.CommonConfig;
import com.nitespring.bloodborne.core.helpers.AttackHitboxHelpers;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ChurchDoctorLantern
extends AbstractBloodborneEntity
implements IAnimatable {
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public ChurchDoctorLantern(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.f_21364_ = 8;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int animState = this.getAnimationState();
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.church_doctor_lantern.death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
        } else {
            switch (animState) {
                case 21: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.church_doctor_lantern.attack", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 22: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.church_doctor_lantern.attack1", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 23: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.church_doctor_lantern.attack2", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                default: {
                    if (!(event.getLimbSwingAmount() > -0.06f) || !(event.getLimbSwingAmount() < 0.06f)) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.church_doctor_lantern.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        break;
                    }
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.church_doctor_lantern.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected int getBnMDefaultTeam() {
        return 3;
    }

    @Override
    public boolean isBoss() {
        return false;
    }

    @Override
    public boolean isBeastly() {
        return false;
    }

    @Override
    public boolean isCorrupted() {
        return false;
    }

    @Override
    public boolean isKin() {
        return false;
    }

    @Override
    public int physRes() {
        return 200;
    }

    @Override
    public int fireRes() {
        return 100;
    }

    @Override
    public int boltRes() {
        return 50;
    }

    @Override
    public int arcRes() {
        return 300;
    }

    @Override
    public int bloodRes() {
        return 200;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.24).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 15.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        super.m_8099_();
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource p_33579_) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    public static boolean checkChurchDoctorLanternSpawnRules(EntityType<? extends AbstractBloodborneEntity> e, ServerLevelAccessor access, MobSpawnType type, BlockPos pos, Random r) {
        return ChurchDoctorLantern.checkMonsterSpawnRules(e, access, type, pos, r) && (Boolean)CommonConfig.should_church_doctor_lantern_spawn.get() != false;
    }

    public class AttackGoal
    extends Goal {
        private final double speedModifier = 1.0;
        private final boolean followingTargetEvenIfNotSeen = true;
        protected final ChurchDoctorLantern mob;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;

        public AttackGoal(ChurchDoctorLantern entityIn) {
            this.mob = entityIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.f_19853_.m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            Objects.requireNonNull(this);
            if (!this.mob.m_21444_(livingentity.m_142538_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            switch (animState) {
                case 21: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime == 14) {
                        this.performAttack();
                    }
                    if (this.animTime < 20) break;
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.animTime = 0;
                    break;
                }
                case 22: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime == 8) {
                        this.performAttack();
                    }
                    if (this.animTime < 15) break;
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.animTime = 0;
                    break;
                }
                case 23: {
                    ++this.animTime;
                    this.mob.m_21573_().m_26517_(0.0);
                    if (this.animTime == 4) {
                        this.performLightAttack();
                    }
                    if (this.animTime < 8) break;
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.animTime = 0;
                    break;
                }
                default: {
                    this.doMovement(target, reach);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }

        private void checkForPreciseAttack() {
            if (this.ticksUntilNextAttack <= 0) {
                this.mob.setAnimationState(21);
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.mob.m_21563_().m_24960_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            Objects.requireNonNull(this);
            if (this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                int r = this.mob.m_21187_().nextInt(2048);
                if (r <= 600) {
                    this.mob.setAnimationState(21);
                } else if (r <= 1200) {
                    this.mob.setAnimationState(22);
                } else if (r <= 1800) {
                    this.mob.setAnimationState(23);
                }
            }
        }

        protected void performAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 0.7f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 5.0f, 0.4f, this.mob, pos, 3.0, -0.7853981633974483, 0.7853981633974483, -1.0, 2.0);
        }

        protected void performLightAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 0.7f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 2.0f, 0.25f, this.mob, pos, 2.5, -0.6283185307179586, 0.6283185307179586, -1.0, 2.0, true);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 20;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 3.0f * this.mob.m_20205_() * 2.0f + p_179512_1_.m_20205_();
        }
    }
}

