/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.mobs.boss;

import com.nitespring.bloodborne.common.entities.mobs.SkeletalPuppet;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.common.entities.projectiles.AugurOfEbrietasEntity;
import com.nitespring.bloodborne.common.entities.projectiles.CallBeyondProjectileEntity;
import com.nitespring.bloodborne.core.helpers.MathHelpers;
import com.nitespring.bloodborne.core.init.EntityInit;
import com.nitespring.bloodborne.core.init.ProjectileInit;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MicolashBossEntity
extends AbstractBloodborneEntity
implements IAnimatable {
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    @Nullable
    protected AugurOfEbrietasEntity tentacleEntity;

    public MicolashBossEntity(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.f_21364_ = 50;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int animState = this.getAnimationState();
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.micolash.death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
        } else {
            switch (animState) {
                case 51: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.micolash.a_call_beyond", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 52: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.micolash.augur_of_ebrietas", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 53: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.micolash.summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    break;
                }
                case 54: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.micolash.summon", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                    break;
                }
                default: {
                    if (!(event.getLimbSwingAmount() > -0.025f) || !(event.getLimbSwingAmount() < 0.025f)) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.micolash.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        break;
                    }
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.micolash.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    @Override
    protected int getBnMDefaultTeam() {
        return 6;
    }

    @Override
    public boolean isBeastly() {
        return false;
    }

    @Override
    public boolean isCorrupted() {
        return false;
    }

    @Override
    public boolean isKin() {
        return false;
    }

    @Override
    public int physRes() {
        return 150;
    }

    @Override
    public int fireRes() {
        return 350;
    }

    @Override
    public int boltRes() {
        return 250;
    }

    @Override
    public int arcRes() {
        return 600;
    }

    @Override
    public int bloodRes() {
        return 100;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1500.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22277_, 50.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new MicolashAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MicolashFleeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        super.m_8099_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6084_() && this.m_21223_() > 0.0f && !this.m_21224_() && !(amount >= this.m_21223_()) && this.getCombatState() != 1) {
            this.teleport1();
        }
        return super.m_6469_(source, amount);
    }

    public boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (double)(this.f_19796_.nextInt(8) - 4) * 4.0;
            double d1 = this.m_20186_() + 20.0;
            double d2 = this.m_20189_() + (double)(this.f_19796_.nextInt(8) - 4) * 4.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_12639_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12639_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    private boolean teleport1() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            for (int i = 0; i < 10; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
            double d0 = this.m_20185_() + (double)((this.f_19796_.nextInt(8) - 4) * 8);
            double d1 = this.m_20182_().m_7098_() * 2.0 + 10.0;
            double d2 = this.m_20189_() + (double)((this.f_19796_.nextInt(8) - 4) * 8);
            Vec3 dVec = new Vec3(d0 - this.m_20185_(), d1 - this.m_20186_(), d2 - this.m_20189_()).m_82541_();
            Vec3 pathedPos = this.m_20182_().m_82549_(dVec.m_82490_(-20.0));
            Path path = this.m_21573_().m_26524_(pathedPos.m_7096_(), pathedPos.m_7098_(), pathedPos.m_7094_(), 0);
            if (path == null || !path.m_77403_()) {
                int i = 0;
                while (!(path != null && path.m_77403_() || i > 12)) {
                    ++i;
                    while ((path == null || !path.m_77403_()) && d1 >= this.m_20186_() - 10.0) {
                        path = this.m_21573_().m_26524_(pathedPos.m_7096_(), d1 -= 1.0, pathedPos.m_7094_(), 0);
                    }
                    d0 = this.m_20185_() + (double)((this.f_19796_.nextInt(8) - 4) * 8);
                    d1 = this.m_20186_() + this.m_20182_().m_7098_();
                    d2 = this.m_20189_() + (double)((this.f_19796_.nextInt(8) - 4) * 8);
                    dVec = new Vec3(d0 - this.m_20185_(), d1 - this.m_20186_(), d2 - this.m_20189_()).m_82541_();
                    pathedPos = this.m_20182_().m_82549_(dVec.m_82490_(-20.0));
                    path = this.m_21573_().m_26524_(pathedPos.m_7096_(), pathedPos.m_7098_(), pathedPos.m_7094_(), 0);
                }
            }
            if (path != null && path.m_77403_()) {
                this.teleport1(pathedPos.m_7096_(), pathedPos.m_7098_(), pathedPos.m_7094_());
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean teleport1(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_12639_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12639_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    @Override
    public void m_8119_() {
        if (this.m_21223_() <= this.m_21233_() * 2.0f / 3.0f && this.getEntityState() != 1) {
            this.teleport1();
            this.setEntityState(1);
            this.setCombatState(0);
        }
        if (this.m_21224_() && this.tentacleEntity != null) {
            this.tentacleEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    public class MicolashAttackGoal
    extends Goal {
        private final MicolashBossEntity mob;
        private final double speedModifier = 1.0;
        @Nullable
        private LivingEntity target;
        private int attackCooldown;
        private int animationTick;
        private int goalTime;
        private final float attackRadiusSqr = 144.0f;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public MicolashAttackGoal(MicolashBossEntity entity) {
            this.mob = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && this.mob.getCombatState() == 1) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.getCombatState() == 1;
        }

        public void m_8041_() {
            this.mob.setAnimationState(0);
            if (this.mob.tentacleEntity != null) {
                this.mob.tentacleEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            super.m_8041_();
        }

        public void m_8037_() {
            if (this.mob.m_21223_() >= 350.0f) {
                ++this.goalTime;
                if (this.goalTime >= 1000) {
                    this.mob.teleport1();
                    this.mob.setCombatState(0);
                    this.m_8041_();
                }
            }
            int animState = this.mob.getAnimationState();
            switch (animState) {
                case 51: {
                    this.tickACallBeyond();
                    break;
                }
                case 52: {
                    this.tickAugurOfEbrietas();
                    break;
                }
                case 53: {
                    this.tickSummonSkeletons();
                    break;
                }
                case 54: {
                    this.tickSummonTentaclesBelowTarget();
                    break;
                }
                default: {
                    this.tickStrafing();
                    if (this.attackCooldown >= 0) {
                        --this.attackCooldown;
                        break;
                    }
                    this.selectAttack();
                }
            }
        }

        private void tickStrafing() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                Objects.requireNonNull(this);
                if (!(d0 > 144.0) && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.mob.m_21187_().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.mob.m_21187_().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
            }
        }

        private void selectAttack() {
            if (this.mob.getEntityState() == 1) {
                int rMax = 100;
                int r = Math.round(new Random().nextFloat() * (float)rMax);
                if (r <= rMax * 1 / 3) {
                    if (this.mob.m_20280_((Entity)this.mob.m_5448_()) <= 65.0) {
                        this.mob.setAnimationState(52);
                    }
                } else if (r <= rMax * 8 / 12) {
                    this.mob.setAnimationState(54);
                } else if (r <= rMax * 11 / 12) {
                    this.mob.setAnimationState(51);
                } else {
                    this.mob.setAnimationState(53);
                }
            } else {
                int rMax = 100;
                int r = Math.round(new Random().nextFloat() * (float)rMax);
                if (r <= rMax * 1 / 3) {
                    if (this.mob.m_20280_((Entity)this.mob.m_5448_()) <= 65.0) {
                        this.mob.setAnimationState(52);
                    }
                } else if (r <= rMax * 8 / 12) {
                    this.mob.setAnimationState(54);
                } else {
                    this.mob.setAnimationState(53);
                }
            }
        }

        private void tickACallBeyond() {
            ++this.animationTick;
            if (this.animationTick == 6) {
                this.aCallBeyond();
            }
            if (this.animationTick >= 15) {
                this.resetAnimationTick();
                this.setAttackCooldown(50, 30);
                this.mob.setAnimationState(0);
            }
        }

        private void tickAugurOfEbrietas() {
            ++this.animationTick;
            Vec3 pos = this.mob.m_20182_();
            Vec3 aim = this.mob.m_20154_();
            this.mob.m_21391_((Entity)this.mob.m_5448_(), 30.0f, 30.0f);
            if (this.animationTick == 6) {
                AugurOfEbrietasEntity tentacle = new AugurOfEbrietasEntity((EntityType)ProjectileInit.AUGUR_OF_EBRIETAS.get(), this.mob.f_19853_, 7.0f);
                tentacle.m_6034_(pos.f_82479_ + 0.75 * aim.f_82479_, pos.f_82480_ + 1.25 + 0.75 * aim.f_82480_, pos.f_82481_ + 0.75 * aim.f_82481_);
                tentacle.m_146926_(this.mob.m_5686_(1.0f) + 90.0f);
                tentacle.m_146922_(180.0f - this.mob.m_5675_(1.0f));
                tentacle.setAim(aim);
                tentacle.setOwner((LivingEntity)this.mob);
                this.mob.f_19853_.m_7967_((Entity)tentacle);
                this.mob.tentacleEntity = tentacle;
            }
            if (this.animationTick > 6) {
                this.mob.tentacleEntity.m_6034_(pos.f_82479_ + 0.75 * aim.f_82479_, pos.f_82480_ + 1.25 + 0.75 * aim.f_82480_, pos.f_82481_ + 0.75 * aim.f_82481_);
                this.mob.tentacleEntity.m_146926_(this.mob.m_5686_(1.0f) + 90.0f);
                this.mob.tentacleEntity.m_146922_(180.0f - this.mob.m_5675_(1.0f));
                this.mob.tentacleEntity.setAim(aim);
            }
            if (this.animationTick >= 35) {
                this.mob.tentacleEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                this.resetAnimationTick();
                this.setAttackCooldown(25, 10);
                this.mob.setAnimationState(0);
            }
        }

        private void tickSummonSkeletons() {
            ++this.animationTick;
            if (this.animationTick == 15) {
                ServerLevel serverlevel = (ServerLevel)this.mob.f_19853_;
                for (int i = 0; i < 2; ++i) {
                    BlockPos blockpos = this.mob.m_142538_().m_142082_(-2 + this.mob.f_19796_.nextInt(5), 1, -2 + this.mob.f_19796_.nextInt(5));
                    SkeletalPuppet skeleton = (SkeletalPuppet)((EntityType)EntityInit.SKELETAL_PUPPET.get()).m_20615_(this.mob.f_19853_);
                    skeleton.m_20035_(blockpos, 0.0f, 0.0f);
                    skeleton.setOwner((LivingEntity)this.mob);
                    serverlevel.m_47205_((Entity)skeleton);
                    skeleton.m_6710_(this.mob.m_5448_());
                }
            }
            if (this.animationTick >= 20) {
                this.resetAnimationTick();
                this.setAttackCooldown(10, 6);
                this.mob.setAnimationState(0);
            }
        }

        private void tickSummonTentaclesBelowTarget() {
            ++this.animationTick;
            if (this.animationTick == 20) {
                LivingEntity target = this.mob.m_5448_();
                double d0 = Math.min(target.m_20186_(), this.mob.m_20186_());
                double d1 = Math.max(target.m_20186_(), this.mob.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.mob.m_20189_()), (double)(target.m_20185_() - this.mob.m_20185_()));
                this.createTentacleFixed(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20189_(), d0, d1, 8.0f);
                for (int i = 0; i < 8; ++i) {
                    float f1 = f + (float)i * (float)Math.PI * 2.0f / 8.0f;
                    this.createTentacleFixed(this.mob.m_5448_().m_20185_() + (double)Mth.m_14089_((float)f1) * 2.0, target.m_20189_() + (double)Mth.m_14031_((float)f1) * 2.0, d0, d1, 4.0f);
                }
            }
            if (this.animationTick >= 25) {
                this.resetAnimationTick();
                this.setAttackCooldown(12, 8);
                this.mob.setAnimationState(0);
            }
        }

        private void createTentacleFixed(double x, double z, double yMin, double yMax, float dmg) {
            BlockPos blockpos = new BlockPos(x, yMax, z);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = this.mob.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.mob.f_19853_, blockpos1, Direction.UP)) continue;
                if (!this.mob.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.mob.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.mob.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)yMin) - 1);
            if (flag) {
                AugurOfEbrietasEntity tentacle = new AugurOfEbrietasEntity((EntityType)ProjectileInit.AUGUR_OF_EBRIETAS.get(), MicolashBossEntity.this.f_19853_, dmg, 50);
                tentacle.setOwner((LivingEntity)this.mob);
                tentacle.m_6034_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
                this.mob.f_19853_.m_7967_((Entity)tentacle);
            }
        }

        private void aCallBeyond() {
            MicolashBossEntity playerIn = this.mob;
            Level worldIn = playerIn.f_19853_;
            double ang = 0.6283185307179586;
            Vec3 pos = playerIn.m_20182_();
            for (int i = 0; i <= 5; ++i) {
                for (int k = 0; k <= 5; ++k) {
                    double x = pos.f_82479_ + 1.25 * Math.cos(ang * (double)i) * Math.cos(ang * (double)k);
                    double z = pos.f_82481_ + 1.25 * Math.cos(ang * (double)i) * Math.sin(ang * (double)k);
                    double y = pos.f_82480_ + 2.5 + 1.25 * Math.sin(ang * 6.0 / 5.0 * (double)i - 0.5235987755982988);
                    CallBeyondProjectileEntity bullet = new CallBeyondProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.CALL_BEYOND.get()), worldIn, 7.0f);
                    bullet.m_6034_(x, y, z);
                    bullet.setTarget((Entity)playerIn.m_5448_());
                    bullet.setOwner((LivingEntity)playerIn);
                    Vec3 aim1 = MathHelpers.AimVector(new Vec3(pos.f_82479_, pos.f_82480_ + 2.5, pos.f_82481_), bullet.m_20182_());
                    bullet.f_36813_ = aim1.f_82479_ * 0.1;
                    bullet.f_36814_ = aim1.f_82480_ * 0.1;
                    bullet.f_36815_ = aim1.f_82481_ * 0.1;
                    worldIn.m_7967_((Entity)bullet);
                }
            }
        }

        private void resetAnimationTick() {
            this.animationTick = 0;
        }

        private void setAttackCooldown(int cooldown) {
            this.setAttackCooldown(cooldown, 0);
        }

        private void setAttackCooldown(int mediumCooldown, int randomizationRange) {
            int k = 2;
            if (this.mob.getEntityState() == 1) {
                k = 1;
            }
            this.attackCooldown = (mediumCooldown + (int)(new Random().nextFloat() * (float)randomizationRange - (float)(randomizationRange / 2))) * k / 2;
        }
    }

    public class MicolashFleeGoal
    extends Goal {
        private final MicolashBossEntity mob;
        private final double speedModifier = 1.5;
        @Nullable
        private LivingEntity target;
        private int attackCooldown;
        private int animationTick;
        private int goalTime;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private final float attackRadiusSqr = 144.0f;
        private int seeTime;

        public MicolashFleeGoal(MicolashBossEntity entity) {
            this.mob = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && this.mob.getCombatState() != 1) {
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.getCombatState() != 1;
        }

        public void m_8056_() {
            LivingEntity livingentity = this.mob.m_5448_();
            Vec3 dVec = new Vec3(livingentity.m_20185_() - this.mob.m_20185_(), livingentity.m_20186_() - this.mob.m_20186_(), livingentity.m_20189_() - this.mob.m_20189_());
            Vec3 pathedPos = this.mob.m_20182_().m_82549_(dVec.m_82541_().m_82490_(-30.0));
            this.path = this.mob.m_21573_().m_26524_(pathedPos.m_7096_(), pathedPos.m_7098_(), pathedPos.m_7094_(), 0);
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
        }

        public void m_8041_() {
            this.mob.setAnimationState(0);
            if (this.mob.tentacleEntity != null) {
                this.mob.tentacleEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            super.m_8041_();
        }

        public void m_8037_() {
            ++this.goalTime;
            if (this.goalTime >= 500) {
                this.mob.teleport1();
                this.mob.setCombatState(1);
                this.goalTime = 0;
                this.m_8041_();
            }
            int animState = this.mob.getAnimationState();
            switch (animState) {
                case 53: {
                    this.tickSummonSkeletons();
                    break;
                }
                case 54: {
                    this.tickSummonTentaclesBelowTarget();
                    break;
                }
                default: {
                    this.tickFleeing();
                    if (this.attackCooldown >= 0) {
                        --this.attackCooldown;
                        break;
                    }
                    LivingEntity livingentity = this.mob.m_5448_();
                    double d0 = this.mob.m_20270_((Entity)livingentity);
                    if (!(d0 >= 5.0) || this.attackCooldown > 0) break;
                    this.selectAttack();
                }
            }
        }

        private void tickFleeing() {
            double d0;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && (d0 = Math.sqrt(this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()))) <= 5.0) {
                Vec3 dVec = new Vec3(livingentity.m_20185_() - this.mob.m_20185_(), livingentity.m_20186_() - this.mob.m_20186_(), livingentity.m_20189_() - this.mob.m_20189_()).m_82541_();
                Vec3 pathedPos = this.mob.m_20182_().m_82549_(dVec.m_82490_(-30.0 + d0));
                this.mob.m_21563_().m_24964_(pathedPos);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                this.pathedTargetX = pathedPos.m_7096_();
                this.pathedTargetY = pathedPos.m_7098_();
                this.pathedTargetZ = pathedPos.m_7094_();
                if (this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_26524_(pathedPos.m_7096_(), pathedPos.m_7098_(), pathedPos.m_7094_(), 0);
                    if (this.path == null || !this.path.m_77403_()) {
                        int i = 0;
                        while (!(this.path != null && this.path.m_77403_() || i > 12)) {
                            Vec3 dVec1 = dVec.m_82542_(Math.cos(Math.PI * (double)(++i) / 6.0), 1.0, Math.sin(Math.PI * (double)i / 6.0)).m_82541_();
                            pathedPos = this.target.m_20182_().m_82549_(dVec1.m_82490_(-30.0 + d0));
                            if (!(pathedPos.m_82554_(this.mob.m_5448_().m_20182_()) >= this.mob.m_20182_().m_82554_(this.mob.m_5448_().m_20182_()))) continue;
                            this.mob.m_21563_().m_24964_(pathedPos);
                            this.pathedTargetX = pathedPos.m_7096_();
                            this.pathedTargetY = pathedPos.m_7098_();
                            this.pathedTargetZ = pathedPos.m_7094_();
                            this.path = this.mob.m_21573_().m_26524_(pathedPos.m_7096_(), pathedPos.m_7098_(), pathedPos.m_7094_(), 0);
                        }
                    }
                    if (this.path != null && this.path.m_77403_()) {
                        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
                        this.ticksUntilNextPathRecalculation = 3;
                    } else {
                        this.ticksUntilNextPathRecalculation = 0;
                    }
                }
            }
        }

        private void selectAttack() {
            if (this.mob.getEntityState() != 1) {
                this.mob.setAnimationState(53);
            } else {
                int rMax = 100;
                int r = Math.round(new Random().nextFloat() * (float)rMax);
                if (r <= rMax * 8 / 12) {
                    this.mob.setAnimationState(54);
                } else {
                    this.mob.setAnimationState(53);
                }
            }
        }

        private void tickSummonSkeletons() {
            ++this.animationTick;
            if (this.animationTick == 7) {
                ServerLevel serverlevel = (ServerLevel)this.mob.f_19853_;
                for (int i = 0; i < 2; ++i) {
                    SkeletalPuppet skeleton = new SkeletalPuppet((EntityType<? extends PathfinderMob>)((EntityType)EntityInit.SKELETAL_PUPPET.get()), this.mob.f_19853_);
                    skeleton.m_146884_(this.mob.m_20182_());
                    skeleton.setOwner((LivingEntity)this.mob);
                    skeleton.setBnMTeam(this.mob.getBnMTeam());
                    serverlevel.m_7967_((Entity)skeleton);
                    skeleton.m_6710_(this.mob.m_5448_());
                }
            }
            if (this.animationTick >= 12) {
                this.resetAnimationTick();
                this.setAttackCooldown(56, 6);
                this.mob.setAnimationState(0);
                if (this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 7.0f) {
                    this.mob.teleport1();
                }
            }
        }

        private void tickSummonTentaclesBelowTarget() {
            ++this.animationTick;
            if (this.animationTick == 6) {
                LivingEntity target = this.mob.m_5448_();
                double d0 = Math.min(target.m_20186_(), this.mob.m_20186_());
                double d1 = Math.max(target.m_20186_(), this.mob.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.mob.m_20189_()), (double)(target.m_20185_() - this.mob.m_20185_()));
                this.createTentacleFixed(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20189_(), d0, d1, 8.0f);
            }
            if (this.animationTick >= 10) {
                this.resetAnimationTick();
                this.setAttackCooldown(15, 8);
                this.mob.setAnimationState(0);
                if (this.mob.m_20270_((Entity)this.mob.m_5448_()) <= 7.0f) {
                    this.mob.teleport1();
                }
            }
        }

        private void createTentacleFixed(double x, double z, double yMin, double yMax, float dmg) {
            BlockPos blockpos = new BlockPos(x, yMax, z);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = this.mob.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.mob.f_19853_, blockpos1, Direction.UP)) continue;
                if (!this.mob.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.mob.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.mob.f_19853_, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)yMin));
            if (flag) {
                AugurOfEbrietasEntity tentacle = new AugurOfEbrietasEntity((EntityType)ProjectileInit.AUGUR_OF_EBRIETAS.get(), MicolashBossEntity.this.f_19853_, dmg, 50);
                tentacle.setOwner((LivingEntity)this.mob);
                tentacle.m_6034_(blockpos.m_123341_(), (double)blockpos.m_123342_() - 0.5, blockpos.m_123343_());
                this.mob.f_19853_.m_7967_((Entity)tentacle);
            }
        }

        private void resetAnimationTick() {
            this.animationTick = 0;
        }

        private void setAttackCooldown(int cooldown) {
            this.setAttackCooldown(cooldown, 0);
        }

        private void setAttackCooldown(int mediumCooldown, int randomizationRange) {
            int k = 2;
            if (this.mob.getEntityState() == 1) {
                k = 1;
            }
            this.attackCooldown = (mediumCooldown + (int)(new Random().nextFloat() * (float)randomizationRange - (float)(randomizationRange / 2))) * k / 2;
            this.ticksUntilNextPathRecalculation = 0;
        }
    }
}

