/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.mobs.beasts;

import com.mojang.math.Vector3f;
import com.nitespring.bloodborne.common.customdamage.CustomDamageType;
import com.nitespring.bloodborne.common.entities.mobs.parent.AbstractBloodborneEntity;
import com.nitespring.bloodborne.common.entities.projectiles.FlameProjectileEntity;
import com.nitespring.bloodborne.config.CommonConfig;
import com.nitespring.bloodborne.core.helpers.AttackHitboxHelpers;
import com.nitespring.bloodborne.core.helpers.MathHelpers;
import com.nitespring.bloodborne.core.init.ProjectileInit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SilverbeastEntity
extends AbstractBloodborneEntity
implements IAnimatable {
    protected AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDimensions CRAWLING_BB = new EntityDimensions(1.4f, 1.2f, false);

    public SilverbeastEntity(EntityType<? extends PathfinderMob> p_i48575_1_, Level p_i48575_2_) {
        super(p_i48575_1_, p_i48575_2_);
        this.f_21364_ = 10;
    }

    @Override
    public void m_8119_() {
        float healthMax = this.m_21233_();
        float health = this.m_21223_();
        if (this.getCombatState() != 2 && health <= healthMax / 2.0f) {
            this.setCombatState(2);
        }
        if (health <= healthMax / 2.0f) {
            this.m_6210_();
        }
        super.m_8119_();
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        if (this.getCombatState() == 2) {
            return CRAWLING_BB;
        }
        return this.m_6095_().m_20680_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        int animState = this.getAnimationState();
        int combatState = this.getCombatState();
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.death", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
        } else {
            block0 : switch (animState) {
                case 11: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.retract", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 21: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_1", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 22: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_2", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 23: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_3", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 24: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_bite", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 25: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_bite2", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 26: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_bite3", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 27: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.breath", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 28: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.explode", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 31: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_1_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 32: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_2_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 33: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_3_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 34: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_bite_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 35: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_bite2_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 36: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_bite3_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 37: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.breath_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 38: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.explode_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 41: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_bite_down", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 42: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.atk_down_worm", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME));
                    break;
                }
                default: {
                    switch (combatState) {
                        case 1: {
                            if (!(event.getLimbSwingAmount() > -0.03f) || !(event.getLimbSwingAmount() < 0.03f)) {
                                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.walk_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                                break block0;
                            }
                            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.idle_retracted", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                            break block0;
                        }
                        case 2: {
                            if (!(event.getLimbSwingAmount() > -0.03f) || !(event.getLimbSwingAmount() < 0.03f)) {
                                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.walk_down", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                                break block0;
                            }
                            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.idle_down", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                            break block0;
                        }
                    }
                    if (!(event.getLimbSwingAmount() > -0.03f) || !(event.getLimbSwingAmount() < 0.03f)) {
                        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                        break;
                    }
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.silverbeast.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "main_controller", 2.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.2).m_22268_(Attributes.f_22282_, 0.1).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22277_, 30.0);
    }

    @Override
    protected int getBnMDefaultTeam() {
        return 2;
    }

    @Override
    public boolean isBoss() {
        return false;
    }

    @Override
    public boolean isBeastly() {
        return true;
    }

    @Override
    public boolean isCorrupted() {
        return false;
    }

    @Override
    public boolean isKin() {
        return false;
    }

    @Override
    public int physRes() {
        return 650;
    }

    @Override
    public int fireRes() {
        return -200;
    }

    @Override
    public int boltRes() {
        return 450;
    }

    @Override
    public int arcRes() {
        return 230;
    }

    @Override
    public int bloodRes() {
        return 270;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new StandingMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(1, (Goal)new CrawlingMeleeAttackGoal(this, 1.2f, true));
        super.m_8099_();
    }

    public static boolean checkSilverbeastSpawnRules(EntityType<? extends AbstractBloodborneEntity> e, ServerLevelAccessor access, MobSpawnType type, BlockPos pos, Random r) {
        return SilverbeastEntity.checkMonsterSpawnRules(e, access, type, pos, r) && (Boolean)CommonConfig.should_silverbeast_spawn.get() != false;
    }

    private class StandingMeleeAttackGoal
    extends Goal {
        protected final SilverbeastEntity mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;

        public StandingMeleeAttackGoal(SilverbeastEntity p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.getCombatState() != 2) {
                long i = this.mob.f_19853_.m_46467_();
                if (i - this.lastCanUseCheck < 20L) {
                    return false;
                }
                this.lastCanUseCheck = i;
                LivingEntity livingentity = this.mob.m_5448_();
                if (livingentity == null) {
                    return false;
                }
                if (!livingentity.m_6084_()) {
                    return false;
                }
                if (this.canPenalize) {
                    if (--this.ticksUntilNextPathRecalculation <= 0) {
                        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                        this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                        return this.path != null;
                    }
                    return true;
                }
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                if (this.path != null) {
                    return true;
                }
                return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.mob.getCombatState() != 2) {
                LivingEntity livingentity = this.mob.m_5448_();
                if (livingentity == null) {
                    return false;
                }
                if (!livingentity.m_6084_()) {
                    return false;
                }
                if (!this.followingTargetEvenIfNotSeen) {
                    return !this.mob.m_21573_().m_26571_();
                }
                if (!this.mob.m_21444_(livingentity.m_142538_())) {
                    return false;
                }
                return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
            }
            return false;
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            Vec3 aim = this.mob.m_20154_();
            Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
            switch (animState) {
                case 11: {
                    this.tickRetractNails();
                    break;
                }
                case 21: {
                    this.tickHandAttack1();
                    break;
                }
                case 22: {
                    this.tickHeavyHandAttack();
                    break;
                }
                case 23: {
                    this.tickHandAttack2();
                    break;
                }
                case 24: {
                    this.tickBiteAttack1();
                    break;
                }
                case 25: {
                    this.tickBiteAttack2();
                    break;
                }
                case 26: {
                    this.tickBiteAttack3();
                    break;
                }
                case 27: {
                    this.tickBreath();
                    break;
                }
                case 28: {
                    this.tickExplode();
                    break;
                }
                case 31: {
                    this.tickHandAttack1();
                    break;
                }
                case 32: {
                    this.tickHeavyHandAttack();
                    break;
                }
                case 33: {
                    this.tickHandAttack2();
                    break;
                }
                case 34: {
                    this.tickBiteAttack1();
                    break;
                }
                case 35: {
                    this.tickBiteAttack2();
                    break;
                }
                case 36: {
                    this.tickBiteAttack3();
                    break;
                }
                case 37: {
                    this.tickBreath();
                    break;
                }
                case 38: {
                    this.tickExplode();
                    break;
                }
                default: {
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                    this.checkForChangeState();
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                if (this.mob.getCombatState() == 1) {
                    int r = this.mob.m_21187_().nextInt(2048);
                    if (r <= 850) {
                        this.mob.setAnimationState(31);
                    } else if (r <= 1000) {
                        this.mob.setAnimationState(32);
                    } else if (r <= 1550) {
                        this.mob.setAnimationState(34);
                    } else if (r <= 1850) {
                        this.mob.setAnimationState(37);
                    } else {
                        this.mob.setAnimationState(38);
                    }
                } else {
                    int r = this.mob.m_21187_().nextInt(2048);
                    if (r <= 850) {
                        this.mob.setAnimationState(21);
                    } else if (r <= 1000) {
                        this.mob.setAnimationState(22);
                    } else if (r <= 1550) {
                        this.mob.setAnimationState(24);
                    } else if (r <= 1850) {
                        this.mob.setAnimationState(27);
                    } else {
                        this.mob.setAnimationState(28);
                    }
                }
            }
        }

        protected void checkForChangeState() {
            int r;
            if (this.mob.getCombatState() != 1 && (r = this.mob.m_21187_().nextInt(2048)) <= 50) {
                this.mob.setAnimationState(11);
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= 1.5 * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickRetractNails() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 6) {
                this.mob.setCombatState(1);
            }
            if (this.animTime >= 10) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickHandAttack1() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 6) {
                this.performAttackHand();
            }
            if (this.animTime >= 8) {
                this.animTime = 0;
                if (this.getRangeCheck()) {
                    if (this.mob.getCombatState() == 1) {
                        this.mob.setAnimationState(33);
                    } else {
                        this.mob.setAnimationState(23);
                    }
                } else {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.ticksUntilNextPathRecalculation = 0;
                }
            }
        }

        protected void tickHandAttack2() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 4) {
                this.performAttackHand();
            }
            if (this.animTime >= 7) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickHeavyHandAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.performHeavyAttackHand();
            }
            if (this.animTime >= 9) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickBiteAttack1() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 7) {
                this.performAttackBite();
            }
            if (this.animTime >= 10) {
                this.animTime = 0;
                if (this.getRangeCheck()) {
                    if (this.mob.getCombatState() == 1) {
                        this.mob.setAnimationState(35);
                    } else {
                        this.mob.setAnimationState(25);
                    }
                } else {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.ticksUntilNextPathRecalculation = 0;
                }
            }
        }

        protected void tickBiteAttack2() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.performAttackBite();
            }
            if (this.animTime >= 7) {
                this.animTime = 0;
                if (this.getRangeCheck()) {
                    if (this.mob.getCombatState() == 1) {
                        this.mob.setAnimationState(36);
                    } else {
                        this.mob.setAnimationState(26);
                    }
                } else {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.ticksUntilNextPathRecalculation = 0;
                }
            }
        }

        protected void tickBiteAttack3() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.performAttackBite();
            }
            if (this.animTime >= 9) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickBreath() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime >= 10 && this.animTime <= 55 && this.animTime % 2 == 0) {
                this.breathFire();
            }
            if (this.animTime >= 66) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickExplode() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 6) {
                this.explode();
            }
            if (this.animTime >= 10) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void breathFire() {
            Vec3 pos = this.mob.m_20182_();
            Vec3 aim = this.mob.m_20154_();
            double a = 0.3141592653589793;
            for (int i = -2; i <= 2; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    FlameProjectileEntity flame = new FlameProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.FLAME.get()), this.mob.f_19853_, (float)this.mob.m_21133_(Attributes.f_22281_) * 0.8f);
                    flame.setOwner((LivingEntity)this.mob);
                    double x = pos.f_82479_ + aim.f_82479_ + 0.75 * (aim.f_82479_ * Math.cos((double)i * a) - aim.f_82481_ * Math.sin((double)i * a));
                    double z = pos.f_82481_ + aim.f_82481_ + 0.75 * (aim.f_82481_ * Math.cos((double)i * a) + aim.f_82479_ * Math.sin((double)i * a));
                    double y = pos.f_82480_ + 2.0 + 0.075 * (aim.f_82480_ + 0.5 * Math.sin((double)k * a));
                    flame.m_6034_(x, y, z);
                    flame.f_36813_ = aim.f_82479_ * 0.04 + 0.005 * (aim.f_82479_ * Math.cos((double)i * a) - aim.f_82481_ * Math.sin((double)i * a));
                    flame.f_36814_ = aim.f_82480_ * 0.04 - 0.025 + 0.03 * Math.sin((double)k * a);
                    flame.f_36815_ = aim.f_82481_ * 0.04 + 0.005 * (aim.f_82481_ * Math.cos((double)i * a) + aim.f_82479_ * Math.sin((double)i * a));
                    this.mob.f_19853_.m_7967_((Entity)flame);
                }
            }
        }

        protected void explode() {
            Vec3 pos = this.mob.m_20182_();
            Vec2 knockVec = MathHelpers.OrizontalAimVector(MathHelpers.AimVector(new Vec3(-this.mob.m_20182_().f_82479_, -this.mob.m_20182_().f_82480_, -this.mob.m_20182_().f_82481_), new Vec3(-this.mob.m_5448_().m_20182_().f_82479_, -this.mob.m_5448_().m_20182_().f_82480_, -this.mob.m_5448_().m_20182_().f_82481_)));
            AABB scanAbove = new AABB(pos.f_82479_ - 8.0, pos.f_82480_ - 4.0, pos.f_82481_ - 8.0, pos.f_82479_ + 8.0, pos.f_82480_ + 8.0, pos.f_82481_ + 8.0);
            ArrayList entities = new ArrayList(this.mob.f_19853_.m_45976_(LivingEntity.class, scanAbove));
            ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
            if (!entities.isEmpty()) {
                for (int n = 0; n < entities.size(); ++n) {
                    LivingEntity target = (LivingEntity)entities.get(n);
                    if (target == this.mob || hitEntities.contains(target)) continue;
                    target.m_6469_(CustomDamageType.BOLT_DAMAGE, (float)this.mob.m_21133_(Attributes.f_22281_) + 10.0f);
                    target.m_6703_((LivingEntity)this.mob);
                    target.m_147240_(1.2, (double)knockVec.f_82470_, (double)knockVec.f_82471_);
                    if (target instanceof Player && target.m_6117_() && target.m_21211_().m_41720_() instanceof ShieldItem) {
                        ((Player)target).m_36335_().m_41524_(target.m_21211_().m_41720_(), 100);
                        this.mob.f_19853_.m_7605_((Entity)target, (byte)30);
                    }
                    hitEntities.add(target);
                }
            }
            this.explosionParticles(pos);
        }

        protected void explosionParticles(Vec3 pos) {
            Level worldIn = this.mob.f_19853_;
            this.mob.m_5496_(SoundEvents.f_12090_, 2.0f, 1.4f);
            DustParticleOptions particle = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 1.0f), 2.0f);
            double x0 = pos.f_82479_;
            double y0 = pos.f_82480_ + 1.5;
            double z0 = pos.f_82481_;
            for (int i = 0; i <= 64; ++i) {
                for (int k = 0; k <= 64; ++k) {
                    double x = x0 + 4.0 * Math.cos((double)i * Math.PI / 32.0) * Math.cos((double)k * Math.PI / 32.0);
                    double y = y0 + 4.0 * Math.sin((double)i * Math.PI / 32.0);
                    double z = z0 + 4.0 * Math.cos((double)i * Math.PI / 32.0) * Math.sin((double)k * Math.PI / 32.0);
                    if (!(worldIn instanceof ServerLevel)) continue;
                    ((ServerLevel)worldIn).m_8767_((ParticleOptions)particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        protected void performAttackHand() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12619_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_), (float)this.mob.m_21133_(Attributes.f_22282_) * 2.0f, this.mob, pos, 2.5, -0.6283185307179586, 0.6283185307179586, -1.0, 3.0);
        }

        protected void performHeavyAttackHand() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12619_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_) * 1.4f, (float)this.mob.m_21133_(Attributes.f_22282_) * 4.0f, this.mob, pos, 2.5, -0.6283185307179586, 0.6283185307179586, -1.0, 3.0);
        }

        protected void performAttackBite() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12619_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_), (float)this.mob.m_21133_(Attributes.f_22282_), this.mob, pos, 2.5, -0.6283185307179586, 0.6283185307179586, -1.0, 3.0);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 20;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 20;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_179512_1_.m_20205_();
        }
    }

    private class CrawlingMeleeAttackGoal
    extends Goal {
        protected final SilverbeastEntity mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;

        public CrawlingMeleeAttackGoal(SilverbeastEntity p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.getCombatState() == 2) {
                long i = this.mob.f_19853_.m_46467_();
                if (i - this.lastCanUseCheck < 20L) {
                    return false;
                }
                this.lastCanUseCheck = i;
                LivingEntity livingentity = this.mob.m_5448_();
                if (livingentity == null) {
                    return false;
                }
                if (!livingentity.m_6084_()) {
                    return false;
                }
                if (this.canPenalize) {
                    if (--this.ticksUntilNextPathRecalculation <= 0) {
                        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                        this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                        return this.path != null;
                    }
                    return true;
                }
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                if (this.path != null) {
                    return true;
                }
                return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.mob.getCombatState() == 2) {
                LivingEntity livingentity = this.mob.m_5448_();
                if (livingentity == null) {
                    return false;
                }
                if (!livingentity.m_6084_()) {
                    return false;
                }
                if (!this.followingTargetEvenIfNotSeen) {
                    return !this.mob.m_21573_().m_26571_();
                }
                if (!this.mob.m_21444_(livingentity.m_142538_())) {
                    return false;
                }
                return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
            }
            return false;
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            Vec3 aim = this.mob.m_20154_();
            Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
            switch (animState) {
                case 41: {
                    this.tickBiteAttack();
                    break;
                }
                case 42: {
                    this.tickWormAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                    this.checkForMediumRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                this.mob.setAnimationState(41);
            }
        }

        protected void checkForMediumRangeAttack(double distance, double reach) {
            int r;
            if (distance <= 4.0 * reach && this.ticksUntilNextAttack <= 0 && (r = this.mob.m_21187_().nextInt(2048)) <= 350) {
                this.mob.setAnimationState(42);
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= 1.5 * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickBiteAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.performAttackBite();
            }
            if (this.animTime >= 7) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickWormAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.performAttackWorm();
            }
            if (this.animTime >= 18) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.ticksUntilNextAttack = 50;
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void performAttackBite() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12619_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_), (float)this.mob.m_21133_(Attributes.f_22282_), this.mob, pos, 2.5, -0.6283185307179586, 0.6283185307179586, -1.0, 3.0, true);
        }

        protected void performAttackWorm() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12619_, 2.0f, 0.2f);
            this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
            AttackHitboxHelpers.LongAttackWithTargetCheck(DamageSource.m_19370_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_) * 1.4f, (float)this.mob.m_21133_(Attributes.f_22282_), this.mob, pos, 6.0, -2.0, 2.0, -1.0, 2.0);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 20;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 20;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_179512_1_.m_20205_();
        }
    }
}

