/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.ai.teams;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class GetTargetByTeamGoal<T extends LivingEntity>
extends TargetGoal {
    protected final int randomInterval = GetTargetByTeamGoal.m_186073_((int)10);
    @Nullable
    protected LivingEntity target;
    protected TargetingConditions targetConditions;

    public GetTargetByTeamGoal(Mob e) {
        this(e, false, false);
    }

    public GetTargetByTeamGoal(Mob e, boolean mustSee, boolean mustReach) {
        super(e, mustSee, mustReach);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_());
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.f_26135_.m_21187_().nextInt(this.randomInterval) != 0 && this.f_26135_.serializeNBT().m_128441_("BnMTeam")) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AABB getTargetSearchArea(double p_26069_) {
        return this.f_26135_.m_142469_().m_82377_(p_26069_, 4.0, p_26069_);
    }

    protected void findTarget() {
        int team = this.f_26135_.serializeNBT().m_128451_("BnMTeam");
        Player playerTarget = this.f_26135_.f_19853_.m_45949_(this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
        switch (team) {
            case 0: {
                this.target = playerTarget;
                break;
            }
            case 1: {
                if (playerTarget == null) {
                    this.target = this.findTargetByPredicate(t -> {
                        CompoundTag nbt = t.serializeNBT();
                        return nbt.m_128441_("BnMTeam") && (nbt.m_128451_("BnMTeam") == 2 || nbt.m_128451_("BnMTeam") == 5) || t instanceof Enemy && !(t instanceof Creeper);
                    });
                    break;
                }
                this.target = playerTarget;
            }
            case 2: {
                if (playerTarget == null) {
                    this.target = this.findTargetByPredicate(t -> {
                        CompoundTag nbt = t.serializeNBT();
                        return nbt.m_128441_("BnMTeam") && (nbt.m_128451_("BnMTeam") == 1 || nbt.m_128451_("BnMTeam") == 3 || nbt.m_128451_("BnMTeam") == 5) || t instanceof Player || t instanceof Villager || t instanceof IronGolem || t instanceof AbstractIllager;
                    });
                    break;
                }
                this.target = playerTarget;
                break;
            }
            case 3: {
                if (playerTarget == null) {
                    this.target = this.findTargetByPredicate(t -> {
                        CompoundTag nbt = t.serializeNBT();
                        return nbt.m_128441_("BnMTeam") && (nbt.m_128451_("BnMTeam") == 2 || nbt.m_128451_("BnMTeam") == 5) || t instanceof Player || t instanceof Enemy && !(t instanceof Creeper);
                    });
                    break;
                }
                this.target = playerTarget;
                break;
            }
            case 5: {
                if (playerTarget == null) {
                    this.target = this.findTargetByPredicate(t -> {
                        CompoundTag nbt = t.serializeNBT();
                        return nbt.m_128441_("BnMTeam") && (nbt.m_128451_("BnMTeam") == 2 || nbt.m_128451_("BnMTeam") == 1 || nbt.m_128451_("BnMTeam") == 3) || nbt.m_128451_("BnMTeam") == 5 || nbt.m_128451_("BnMTeam") == 6 || nbt.m_128451_("BnMTeam") == 7 || t instanceof Villager || t instanceof IronGolem || t instanceof Enemy && !(t instanceof Creeper);
                    });
                    break;
                }
                this.target = playerTarget;
                break;
            }
            case 6: {
                this.target = playerTarget;
                break;
            }
            case 7: {
                this.target = playerTarget == null ? this.findTargetByPredicate(t -> true) : playerTarget;
            }
        }
    }

    protected LivingEntity findTargetByPredicate(Predicate<LivingEntity> predicate) {
        return this.f_26135_.f_19853_.m_45982_(this.f_26135_.f_19853_.m_6443_(LivingEntity.class, this.getTargetSearchArea(this.m_7623_()), p_148152_ -> true), this.targetConditions.m_26888_(predicate), (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.target);
        super.m_8056_();
    }

    public void setTarget(@Nullable LivingEntity p_26071_) {
        this.target = p_26071_;
    }
}

