/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.ai.boss;

import com.nitespring.bloodborne.common.entities.mobs.boss.GascoigneBeastBossEntity;
import com.nitespring.bloodborne.core.helpers.AttackHitboxHelpers;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class GascoigneBeastAttackGoal
extends Goal {
    protected final GascoigneBeastBossEntity mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private int animTime = 0;
    private Vec2 saveAim;

    public GascoigneBeastAttackGoal(GascoigneBeastBossEntity p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
        this.mob = p_i1636_1_;
        this.speedModifier = p_i1636_2_;
        this.followingTargetEvenIfNotSeen = p_i1636_4_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.animTime = 0;
        this.mob.setAnimationState(0);
    }

    public void m_8041_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.setAnimationState(0);
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        double reach = this.getAttackReachSqr(target);
        int animState = this.mob.getAnimationState();
        Vec3 aim = this.mob.m_20154_();
        Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
        double pi = Math.PI;
        switch (animState) {
            case 5: {
                break;
            }
            case 6: {
                this.tickInAir();
                break;
            }
            case 21: {
                this.tickLightAttack(aim2d);
                break;
            }
            case 22: {
                this.tickLightAttack2(aim2d);
                break;
            }
            case 23: {
                this.tickPunchAttack();
                break;
            }
            case 24: {
                this.tickKickAttack();
                break;
            }
            case 25: {
                this.tickSlamAttack();
                break;
            }
            case 26: {
                this.tickJumpAttack(aim2d);
                break;
            }
            default: {
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.doMovement(target, distance);
                this.checkForCloseRangeAttack(distance, reach);
                this.checkForMediumRangeAction(distance, reach);
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
    }

    protected void doMovement(LivingEntity livingentity, Double d0) {
        if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.m_20185_();
            this.pathedTargetY = livingentity.m_20186_();
            this.pathedTargetZ = livingentity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
    }

    protected void checkForCloseRangeAttack(double distance, double reach) {
        if (distance <= reach && this.ticksUntilNextAttack <= 0) {
            int r = this.mob.m_21187_().nextInt(2048);
            if (r <= 600) {
                this.mob.setAnimationState(21);
            } else if (r <= 800) {
                this.mob.setAnimationState(23);
            } else if (r <= 1400) {
                this.mob.setAnimationState(24);
            } else {
                this.mob.setAnimationState(25);
            }
        }
    }

    protected void checkForMediumRangeAction(double distance, double reach) {
        int r;
        if (distance <= 6.5 * reach && this.ticksUntilNextAttack <= 0 && (r = this.mob.m_21187_().nextInt(4096)) <= 350) {
            this.mob.setAnimationState(26);
        }
    }

    protected boolean getRangeCheck() {
        return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= 2.5 * this.getAttackReachSqr(this.mob.m_5448_());
    }

    protected void tickInAir() {
        ++this.animTime;
        this.mob.m_20334_((double)this.saveAim.f_82470_ * 1.25, -1.25, (double)this.saveAim.f_82471_ * 1.25);
        this.performLargeSweepAttack();
        if (this.mob.m_20096_() || this.animTime >= 500) {
            this.animTime = 0;
            this.performLightAttack();
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tickLightAttack(Vec2 aim2d) {
        ++this.animTime;
        if (this.animTime == 5) {
            this.performLightAttack();
            this.mob.m_20334_((double)aim2d.f_82470_ * 1.25, 0.1, (double)aim2d.f_82471_ * 1.25);
        }
        if (this.animTime >= 9) {
            this.animTime = 0;
            if (this.getRangeCheck()) {
                this.mob.setAnimationState(22);
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tickLightAttack2(Vec2 aim2d) {
        ++this.animTime;
        if (this.animTime == 5) {
            this.performLightAttack();
            this.mob.m_20334_((double)aim2d.f_82470_ * 1.25, 0.1, (double)aim2d.f_82471_ * 1.25);
        }
        if (this.animTime >= 9) {
            this.animTime = 0;
            if (this.getRangeCheck()) {
                this.mob.setAnimationState(21);
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tickPunchAttack() {
        ++this.animTime;
        if (this.animTime == 10) {
            this.performLightAttack();
        }
        if (this.animTime >= 14) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tickKickAttack() {
        ++this.animTime;
        if (this.animTime == 10) {
            this.performLightAttack();
        }
        if (this.animTime >= 14) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tickSlamAttack() {
        ++this.animTime;
        if (this.animTime == 10) {
            this.performLightAttack();
        }
        if (this.animTime >= 14) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tickJumpAttack(Vec2 aim2d) {
        ++this.animTime;
        this.mob.m_21573_().m_26573_();
        if (this.animTime >= 8 && this.animTime <= 12) {
            this.mob.m_20334_(0.0, 1.5, 0.0);
        }
        if (this.animTime > 14 && this.animTime <= 17) {
            this.mob.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.animTime == 17) {
            this.saveAim = aim2d;
        }
        if (this.animTime > 17) {
            this.mob.m_20334_((double)this.saveAim.f_82470_ * 1.25, -1.25, (double)this.saveAim.f_82471_ * 1.25);
            this.performLargeSweepAttack();
        }
        if (this.animTime >= 25) {
            this.animTime = 0;
            this.mob.setAnimationState(6);
            this.resetAttackCooldown();
        }
    }

    protected void performLightAttack() {
        Vec3 pos = this.mob.m_20182_();
        this.mob.m_5496_(SoundEvents.f_12317_, 1.5f, 0.1f);
        this.mob.m_5496_(SoundEvents.f_12357_, 1.5f, 0.1f);
        AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 8.0f, 0.6f, this.mob, pos, 5.0, -0.7853981633974483, 0.7853981633974483, 1.0, 3.0);
    }

    protected void performLargeSweepAttack() {
        Vec3 pos = this.mob.m_20182_();
        AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 10.0f, 1.6f, this.mob, pos, 3.0, -Math.PI, Math.PI, 1.0, 3.0);
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 15;
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return 20;
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + p_179512_1_.m_20205_();
    }
}

