/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.entities.ai.boss;

import com.nitespring.bloodborne.common.entities.mobs.boss.FatherGascoigneBossEntity;
import com.nitespring.bloodborne.common.entities.projectiles.BulletProjectileEntity;
import com.nitespring.bloodborne.core.helpers.AttackHitboxHelpers;
import com.nitespring.bloodborne.core.helpers.MathHelpers;
import com.nitespring.bloodborne.core.init.ProjectileInit;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class FatherGascoigneAttackGoal
extends Goal {
    protected final FatherGascoigneBossEntity mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private int animTime = 0;
    private int ticksUntilNextTransform;

    public FatherGascoigneAttackGoal(FatherGascoigneBossEntity p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
        this.mob = p_i1636_1_;
        this.speedModifier = p_i1636_2_;
        this.followingTargetEvenIfNotSeen = p_i1636_4_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.ticksUntilNextTransform = 200;
        this.animTime = 0;
        this.mob.setAnimationState(0);
    }

    public void m_8041_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.setAnimationState(0);
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        double reach = this.getAttackReachSqr(target);
        int animState = this.mob.getAnimationState();
        Vec3 aim = this.mob.m_20154_();
        Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
        switch (animState) {
            case 5: {
                break;
            }
            case 6: {
                this.tickTransformTo2H();
                break;
            }
            case 7: {
                this.tickTransformTo1H();
                break;
            }
            case 11: {
                this.tickRoll(aim2d);
                break;
            }
            case 12: {
                this.tickSidestepR(aim2d);
                break;
            }
            case 13: {
                this.tickSidestepL(aim2d);
                break;
            }
            case 14: {
                this.tickSidestepR(aim2d);
                break;
            }
            case 15: {
                this.tickSidestepL(aim2d);
                break;
            }
            case 21: {
                this.tick1hLightAttack();
                break;
            }
            case 22: {
                this.tick1hLightAttack2();
                break;
            }
            case 23: {
                this.tick1hLightAttack3();
                break;
            }
            case 24: {
                this.tick1hRollAttack();
                break;
            }
            case 25: {
                this.tick1hJumpAttack(aim2d);
                break;
            }
            case 26: {
                this.tickShootGun(aim2d);
                break;
            }
            case 31: {
                this.tick2hLightAttack();
                break;
            }
            case 32: {
                this.tick2hLightAttack2();
                break;
            }
            case 33: {
                this.tick2hLightAttack3();
                break;
            }
            case 34: {
                this.tick2hRollAttack();
                break;
            }
            case 35: {
                this.tick2hJumpAttack(aim2d);
                break;
            }
            case 36: {
                this.tickShootGun(aim2d);
                break;
            }
            case 37: {
                this.tick2hLightAttack4();
                break;
            }
            case 38: {
                this.tick2hLightAttackThrust();
                break;
            }
            case 39: {
                this.tick2hRunAttack();
                break;
            }
            case 40: {
                this.tick2hChargedAttack();
                break;
            }
            default: {
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                --this.ticksUntilNextTransform;
                this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.doMovement(target, distance);
                this.checkForCloseRangeAttack(distance, reach);
                this.checkForMediumRangeAction(distance, reach);
                this.checkForTransform();
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
    }

    protected void doMovement(LivingEntity livingentity, Double d0) {
        if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
            this.pathedTargetX = livingentity.m_20185_();
            this.pathedTargetY = livingentity.m_20186_();
            this.pathedTargetZ = livingentity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
            if (this.canPenalize) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
    }

    protected void checkForCloseRangeAttack(double distance, double reach) {
        if (distance <= reach && this.ticksUntilNextAttack <= 0) {
            if (this.mob.getEntityState() == 1) {
                int r = this.mob.m_21187_().nextInt(2048);
                if (r <= 600) {
                    this.mob.setAnimationState(31);
                } else if (r <= 800) {
                    this.mob.setAnimationState(38);
                } else if (r <= 1400) {
                    this.mob.setAnimationState(39);
                } else {
                    this.mob.setAnimationState(40);
                }
            } else {
                this.mob.setAnimationState(21);
            }
        }
    }

    protected void checkForTransform() {
        int r;
        if (this.ticksUntilNextTransform <= 0 && (r = this.mob.m_21187_().nextInt(2048)) <= 400) {
            if (this.mob.getEntityState() == 1) {
                this.mob.setAnimationState(7);
            } else {
                this.mob.setAnimationState(6);
            }
        }
    }

    protected void checkForMediumRangeAction(double distance, double reach) {
        if (distance <= 6.0 * reach && this.ticksUntilNextAttack <= 0) {
            if (this.mob.getEntityState() == 1) {
                int r = this.mob.m_21187_().nextInt(4096);
                if (r <= 600) {
                    this.mob.setAnimationState(11);
                } else if (r <= 1000) {
                    this.mob.setAnimationState(35);
                } else if (r <= 1200) {
                    this.mob.setAnimationState(36);
                } else if (r <= 1700) {
                    this.mob.setAnimationState(14);
                } else if (r <= 2200) {
                    this.mob.setAnimationState(15);
                }
            } else {
                int r = this.mob.m_21187_().nextInt(4096);
                if (r <= 600) {
                    this.mob.setAnimationState(11);
                } else if (r <= 1000) {
                    this.mob.setAnimationState(25);
                } else if (r <= 1200) {
                    this.mob.setAnimationState(26);
                } else if (r <= 1700) {
                    this.mob.setAnimationState(12);
                } else if (r <= 2200) {
                    this.mob.setAnimationState(13);
                }
            }
        }
    }

    protected boolean getRangeCheck() {
        return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= 1.5 * this.getAttackReachSqr(this.mob.m_5448_());
    }

    protected boolean getRangeCheck2() {
        return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= 3.0 * this.getAttackReachSqr(this.mob.m_5448_());
    }

    protected boolean getRangeCheckRanged() {
        return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= 7.0 * this.getAttackReachSqr(this.mob.m_5448_());
    }

    protected void tickTransformTo2H() {
        ++this.animTime;
        this.mob.m_21573_().m_26573_();
        if (this.animTime >= 20) {
            this.animTime = 0;
            this.mob.setEntityState(1);
            this.mob.setAnimationState(0);
            this.resetTransformCooldown();
        }
    }

    protected void tickTransformTo1H() {
        ++this.animTime;
        this.mob.m_21573_().m_26573_();
        if (this.animTime >= 20) {
            this.animTime = 0;
            this.mob.setEntityState(0);
            this.mob.setAnimationState(0);
            this.resetTransformCooldown();
        }
    }

    protected void tickRoll(Vec2 aim2d) {
        ++this.animTime;
        if (this.animTime == 2) {
            this.mob.m_21573_().m_26573_();
            this.mob.m_20334_((double)aim2d.f_82470_ * 0.7, 0.1, (double)aim2d.f_82471_ * 0.7);
        }
        if (this.animTime >= 12) {
            this.animTime = 0;
            if (this.getRangeCheck2()) {
                if (this.mob.getEntityState() == 1) {
                    this.mob.setAnimationState(34);
                } else {
                    this.mob.setAnimationState(24);
                }
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tickSidestepR(Vec2 aim2d) {
        this.doMovement(this.mob.m_5448_(), this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()));
        ++this.animTime;
        if (this.animTime == 5) {
            double startX = this.mob.m_20185_();
            double startZ = this.mob.m_20189_();
            double destX = startX + 4.0 * ((double)aim2d.f_82470_ * Math.cos(0.7853981633974483) - (double)aim2d.f_82471_ * Math.sin(0.7853981633974483));
            double destZ = startZ + 4.0 * ((double)aim2d.f_82471_ * Math.cos(0.7853981633974483) + (double)aim2d.f_82470_ * Math.sin(0.7853981633974483));
            this.mob.m_20334_((destX - startX) * 0.7 / 2.5, 0.15, (destZ - startZ) * 0.7 / 2.5);
        }
        if (this.animTime >= 20) {
            this.animTime = 0;
            if (this.getRangeCheckRanged()) {
                this.mob.m_21573_().m_26573_();
                if (this.mob.getEntityState() == 1) {
                    this.mob.setAnimationState(36);
                } else {
                    this.mob.setAnimationState(26);
                }
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tickSidestepL(Vec2 aim2d) {
        this.doMovement(this.mob.m_5448_(), this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()));
        ++this.animTime;
        if (this.animTime == 5) {
            double startX = this.mob.m_20185_();
            double startZ = this.mob.m_20189_();
            double destX = startX + 4.0 * ((double)aim2d.f_82470_ * Math.cos(0.7853981633974483) + (double)aim2d.f_82471_ * Math.sin(0.7853981633974483));
            double destZ = startZ + 4.0 * ((double)aim2d.f_82471_ * Math.cos(0.7853981633974483) - (double)aim2d.f_82470_ * Math.sin(0.7853981633974483));
            this.mob.m_20334_((destX - startX) * 0.7 / 2.5, 0.15, (destZ - startZ) * 0.7 / 2.5);
        }
        if (this.animTime >= 20) {
            this.animTime = 0;
            if (this.getRangeCheckRanged()) {
                this.mob.m_21573_().m_26573_();
                if (this.mob.getEntityState() == 1) {
                    this.mob.setAnimationState(36);
                } else {
                    this.mob.setAnimationState(26);
                }
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tick1hLightAttack() {
        ++this.animTime;
        if (this.animTime == 5) {
            this.performLightAttack();
        }
        if (this.animTime >= 10) {
            this.animTime = 0;
            if (this.getRangeCheck()) {
                this.mob.setAnimationState(22);
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tick1hLightAttack2() {
        ++this.animTime;
        if (this.animTime == 6) {
            this.performLightAttack();
        }
        if (this.animTime >= 12) {
            this.animTime = 0;
            if (this.getRangeCheck()) {
                this.mob.setAnimationState(23);
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tick1hLightAttack3() {
        ++this.animTime;
        if (this.animTime == 5) {
            this.performLightAttack();
        }
        if (this.animTime >= 10) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick1hRollAttack() {
        ++this.animTime;
        if (this.animTime <= 3) {
            this.doMovement(this.mob.m_5448_(), this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()));
        }
        if (this.animTime == 4) {
            this.performLightAttack();
        }
        if (this.animTime >= 12) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick1hJumpAttack(Vec2 aim2d) {
        ++this.animTime;
        this.mob.m_21573_().m_26573_();
        if (this.animTime == 5) {
            this.mob.m_20334_((double)aim2d.f_82470_ * 0.5, 0.3, (double)aim2d.f_82471_ * 0.5);
        }
        if (this.animTime == 17) {
            this.performLightAttack();
        }
        if (this.animTime >= 20) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tickShootGun(Vec2 aim2d) {
        ++this.animTime;
        if (this.animTime <= 2) {
            this.doMovement(this.mob.m_5448_(), this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()));
        }
        if (this.animTime == 3) {
            this.mob.m_21573_().m_26573_();
            this.performRangeAttack(aim2d);
        }
        if (this.animTime >= 27) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick2hLightAttack() {
        ++this.animTime;
        if (this.animTime == 8) {
            this.performLightAttack();
        }
        if (this.animTime >= 11) {
            this.animTime = 0;
            if (this.getRangeCheck()) {
                this.mob.setAnimationState(32);
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tick2hLightAttack2() {
        ++this.animTime;
        if (this.animTime == 10) {
            this.performLightAttack();
        }
        if (this.animTime >= 11) {
            this.animTime = 0;
            if (this.getRangeCheck()) {
                this.mob.setAnimationState(33);
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tick2hLightAttack3() {
        ++this.animTime;
        if (this.animTime == 3) {
            this.performLightAttack();
        }
        if (this.animTime >= 9) {
            this.animTime = 0;
            if (this.getRangeCheck()) {
                this.mob.setAnimationState(37);
            } else {
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
            }
        }
    }

    protected void tick2hLightAttack4() {
        ++this.animTime;
        if (this.animTime == 15) {
            this.performLightAttack();
        }
        if (this.animTime >= 18) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick2hLightAttackThrust() {
        ++this.animTime;
        if (this.animTime == 7) {
            this.performLightAttack();
        }
        if (this.animTime >= 14) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick2hRollAttack() {
        ++this.animTime;
        if (this.animTime <= 3) {
            this.doMovement(this.mob.m_5448_(), this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()));
        }
        if (this.animTime == 6) {
            this.performLightAttack();
        }
        if (this.animTime >= 13) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick2hJumpAttack(Vec2 aim2d) {
        ++this.animTime;
        this.mob.m_21573_().m_26573_();
        if (this.animTime == 4) {
            this.mob.m_20334_((double)aim2d.f_82470_ * 0.5, 0.3, (double)aim2d.f_82471_ * 0.5);
        }
        if (this.animTime == 13) {
            this.performLightAttack();
        }
        if (this.animTime >= 17) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick2hRunAttack() {
        ++this.animTime;
        this.mob.m_21573_().m_26573_();
        if (this.animTime <= 5) {
            this.doMovement(this.mob.m_5448_(), this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()));
        }
        if (this.animTime == 5) {
            this.performLightAttack();
        }
        if (this.animTime >= 9) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void tick2hChargedAttack() {
        ++this.animTime;
        this.mob.m_21573_().m_26573_();
        if (this.animTime == 15) {
            this.performLargeSweepAttack();
        }
        if (this.animTime == 17) {
            Vec2 vec = MathHelpers.OrizontalAimVector(MathHelpers.AimVector(this.mob.m_20182_(), this.mob.m_5448_().m_20182_()));
            this.performSweepAttackBehind();
            this.mob.m_20334_((double)vec.f_82470_ * 0.5, 0.1, (double)vec.f_82471_ * 0.5);
        }
        if (this.animTime == 20) {
            this.performLargeSweepAttack();
        }
        if (this.animTime >= 33) {
            this.animTime = 0;
            this.mob.setAnimationState(0);
            this.resetAttackCooldown();
        }
    }

    protected void performLightAttack() {
        Vec3 pos = this.mob.m_20182_();
        this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.2f);
        this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
        AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 6.0f, 0.4f, this.mob, pos, 3.5, -0.7853981633974483, 0.7853981633974483, 1.0, 3.0);
    }

    protected void performLargeSweepAttack() {
        Vec3 pos = this.mob.m_20182_();
        this.mob.m_5496_(SoundEvents.f_12317_, 2.0f, 0.2f);
        this.mob.m_5496_(SoundEvents.f_12579_, 1.0f, 0.2f);
        AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 10.0f, 1.6f, this.mob, pos, 4.5, -1.5707963267948966, 1.5707963267948966, 1.0, 3.0);
    }

    protected void performSweepAttackBehind() {
        Vec3 pos = this.mob.m_20182_();
        AttackHitboxHelpers.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 9.0f, 2.0f, this.mob, pos, 3.5, 0.7853981633974483, -0.7853981633974483, 1.0, 3.0);
    }

    protected void performRangeAttack(Vec2 aim) {
        FatherGascoigneBossEntity playerIn = this.mob;
        Level worldIn = this.mob.f_19853_;
        Vec3 pos = playerIn.m_20182_();
        Random rng = playerIn.m_21187_();
        int sizeVar = rng.nextInt(5) - 2;
        int nBullets = 10 + sizeVar;
        for (int i = -nBullets / 2; i < nBullets / 2; ++i) {
            Random rng1 = playerIn.m_21187_();
            Random rng2 = playerIn.m_21187_();
            int dmgVar = rng1.nextInt(10) - 4;
            double rngPos = (float)rng2.nextInt(1) * 0.1f - 0.4f;
            BulletProjectileEntity bullet = new BulletProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ProjectileInit.BULLET_ENTITY.get()), 7.0f, 60, worldIn, (LivingEntity)this.mob);
            bullet.m_5602_((Entity)this.mob);
            worldIn.m_6263_((Player)null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.HOSTILE, 0.5f, 0.4f);
            bullet.m_6034_(playerIn.m_20185_() + (double)aim.f_82470_ * 0.5, playerIn.m_20186_() + 0.7, playerIn.m_20189_() + (double)aim.f_82471_ * 0.5);
            bullet.f_36813_ = (double)aim.f_82470_ * 0.2 + Math.sin(i) * 0.15 * rngPos;
            bullet.f_36814_ = Math.tan(i) * 0.05 * rngPos;
            bullet.f_36815_ = (double)aim.f_82471_ * 0.2 + Math.cos(i) * 0.15 * rngPos;
            worldIn.m_7967_((Entity)bullet);
        }
    }

    protected void resetTransformCooldown() {
        this.ticksUntilNextTransform = 400;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = 20;
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return 20;
    }

    protected double getAttackReachSqr(LivingEntity p_179512_1_) {
        return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_179512_1_.m_20205_();
    }
}

