/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.containers;

import com.nitespring.bloodborne.common.items.ShardItem;
import com.nitespring.bloodborne.common.items.weapons.parent.BloodborneWeapon;
import com.nitespring.bloodborne.core.init.BlockInit;
import com.nitespring.bloodborne.core.init.ContainerInit;
import com.nitespring.bloodborne.core.init.ItemInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorkshopContainer
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    public static final TranslatableComponent TITLE = new TranslatableComponent("container.bloodandmadness.workshop");
    private Runnable slotUpdateListener = () -> {};
    private final Slot weaponSlot;
    private final Slot shardSlot;
    private final Slot resultSlot;
    private final Container inputContainer = new SimpleContainer(3){

        public void m_6596_() {
            super.m_6596_();
            WorkshopContainer.this.m_6199_((Container)this);
            WorkshopContainer.this.slotUpdateListener.run();
        }
    };
    private final Container outputContainer = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            WorkshopContainer.this.slotUpdateListener.run();
        }
    };

    public WorkshopContainer(int a, Inventory inv) {
        this(a, inv, ContainerLevelAccess.f_39287_);
    }

    public WorkshopContainer(int a, Inventory inv, ContainerLevelAccess posCal) {
        super((MenuType)ContainerInit.WORKSHOP.get(), a);
        this.access = posCal;
        this.weaponSlot = this.m_38897_(new Slot(this.inputContainer, 1, 45, 23){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof BloodborneWeapon;
            }
        });
        this.shardSlot = this.m_38897_(new Slot(this.inputContainer, 2, 45, 76){

            public boolean m_5857_(ItemStack stack1) {
                return stack1.m_41720_() instanceof ShardItem || stack1.m_41720_() instanceof BlockItem && ((BlockItem)stack1.m_41720_()).getRegistryName() == Items.f_41829_.getRegistryName();
            }
        });
        this.resultSlot = this.m_38897_(new Slot(this.outputContainer, 0, 115, 49){

            public boolean m_5857_(ItemStack stack2) {
                return false;
            }

            public void m_142406_(Player playerIn, ItemStack stack3) {
                ItemStack weaponStack = WorkshopContainer.this.weaponSlot.m_7993_();
                ItemStack shardStack = WorkshopContainer.this.shardSlot.m_7993_();
                int quantity = shardStack.m_41613_();
                CompoundTag nbt = weaponStack.m_41782_() ? weaponStack.m_41783_() : new CompoundTag();
                if (nbt.m_128441_("BBLevel")) {
                    int i = nbt.m_128451_("BBLevel");
                    int cost = WorkshopContainer.this.getCostbyLevel(i);
                    if (quantity >= cost) {
                        WorkshopContainer.this.shardSlot.m_6201_(cost);
                    }
                } else {
                    int cost = WorkshopContainer.this.getCostbyLevel(0);
                    if (quantity >= cost) {
                        WorkshopContainer.this.shardSlot.m_6201_(cost);
                    }
                }
                WorkshopContainer.this.weaponSlot.m_6201_(1);
            }
        });
        for (int z = 0; z < 3; ++z) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + z * 9 + 9, 8 + j * 18, 116 + z * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inv, k, 8 + k * 18, 174));
        }
    }

    public void m_6199_(Container p_75130_1_) {
        ItemStack itemstack = this.weaponSlot.m_7993_();
        ItemStack itemstack1 = this.shardSlot.m_7993_();
        ItemStack itemstack3 = this.resultSlot.m_7993_();
        if (itemstack.m_41619_() || itemstack1.m_41619_()) {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.setupResultSlot();
        this.m_38946_();
    }

    public boolean m_6875_(Player playerIn) {
        return WorkshopContainer.m_38889_((ContainerLevelAccess)this.access, (Player)playerIn, (Block)((Block)BlockInit.WORKSHOP.get()));
    }

    public boolean m_6366_(Player p_75140_1_, int p_75140_2_) {
        this.setupResultSlot();
        return true;
    }

    private void setupResultSlot() {
        ItemStack weaponStack = this.weaponSlot.m_7993_();
        ItemStack shardStack = this.shardSlot.m_7993_();
        int quantity = shardStack.m_41613_();
        ItemStack resultStack = ItemStack.f_41583_;
        Component name = weaponStack.m_41611_();
        Item upgradeItem = weaponStack.m_41720_();
        if (!weaponStack.m_41619_() && !shardStack.m_41619_()) {
            CompoundTag nbt = weaponStack.m_41782_() ? weaponStack.m_41783_() : new CompoundTag();
            CompoundTag nbtresult = nbt.m_6426_();
            if (nbtresult.m_128441_("BBLevel")) {
                int i = nbtresult.m_128451_("BBLevel");
                ItemStack needed = this.getMaterialByLevel(i);
                int cost = this.getCostbyLevel(i);
                if (shardStack.m_41720_() == needed.m_41720_() && quantity >= cost) {
                    nbtresult.m_128473_("BBLevel");
                    nbtresult.m_128405_("BBLevel", i + 1);
                    ItemStack upgrade = new ItemStack((ItemLike)upgradeItem, 1, nbtresult).m_41714_(name);
                    this.resultSlot.m_5852_(upgrade);
                    upgrade.m_41751_(nbtresult);
                }
            } else if (shardStack.m_41720_() == this.getMaterialByLevel(0).m_41720_() && quantity >= this.getCostbyLevel(0)) {
                nbtresult.m_128405_("BBLevel", 1);
                ItemStack upgrade = new ItemStack((ItemLike)upgradeItem, 1, nbtresult).m_41714_(name);
                this.resultSlot.m_5852_(upgrade);
                upgrade.m_41751_(nbtresult);
            }
        }
    }

    public ItemStack getMaterialByLevel(int level) {
        if (level <= 2) {
            return new ItemStack((ItemLike)ItemInit.BLOOD_STONE_SHARD.get());
        }
        if (level >= 3 && level <= 5) {
            return new ItemStack((ItemLike)ItemInit.TWIN_BLOOD_STONE_SHARDS.get());
        }
        if (level >= 6 && level <= 8) {
            return new ItemStack((ItemLike)ItemInit.BLOOD_STONE_CHUNK.get());
        }
        if (level == 9) {
            return new ItemStack((ItemLike)ItemInit.BLOOD_ROCK.get());
        }
        return new ItemStack((ItemLike)Items.f_41829_);
    }

    public int getCostbyLevel(int level) {
        if (level <= 0 || level == 3 || level == 6) {
            return 3;
        }
        if (level == 1 || level == 4 || level == 7) {
            return 5;
        }
        if (level == 2 || level == 5 || level == 8) {
            return 8;
        }
        if (level == 9) {
            return 1;
        }
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getWeaponSlot() {
        return this.weaponSlot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getShardSlot() {
        return this.shardSlot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getResultSlot() {
        return this.resultSlot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerUpdateListener(Runnable p_217020_1_) {
        this.slotUpdateListener = p_217020_1_;
    }

    public ItemStack m_7648_(Player playerIn, int i) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(i);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (i == this.resultSlot.f_40219_) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (i != this.weaponSlot.f_40219_ && i != this.shardSlot.f_40219_ ? (itemstack1.m_41720_() instanceof BloodborneWeapon ? !this.m_38903_(itemstack1, this.weaponSlot.f_40219_, this.weaponSlot.f_40219_ + 1, false) : (itemstack1.m_41720_() instanceof ShardItem ? !this.m_38903_(itemstack1, this.shardSlot.f_40219_, this.shardSlot.f_40219_ + 1, false) : (i >= 4 && i < 30 ? !this.m_38903_(itemstack1, 30, 39, false) : i >= 30 && i < 39 && !this.m_38903_(itemstack1, 3, 30, false)))) : !this.m_38903_(itemstack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(Player p_75134_1_) {
        super.m_6877_(p_75134_1_);
        this.access.m_39292_((p_217028_2_, p_217028_3_) -> this.m_150411_(p_75134_1_, this.inputContainer));
    }
}

