/*
 * Decompiled with CFR 0.152.
 */
package com.nitespring.bloodborne.common.blocks;

import com.nitespring.bloodborne.common.containers.WorkshopContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Workshop
extends HorizontalDirectionalBlock {
    private static final Component CONTAINER_TITLE = new TranslatableComponent("container.bloodandmadness.workshop");
    private static final VoxelShape TO_WEST = Block.m_49796_((double)0.01, (double)0.0, (double)-7.99, (double)16.0, (double)20.0, (double)23.99);
    private static final VoxelShape TO_EAST = Block.m_49796_((double)0.01, (double)0.0, (double)-7.99, (double)16.0, (double)20.0, (double)23.99);
    private static final VoxelShape TO_NORTH = Block.m_49796_((double)-7.99, (double)0.0, (double)0.01, (double)23.99, (double)20.0, (double)15.99);
    private static final VoxelShape TO_SOUTH = Block.m_49796_((double)-7.99, (double)0.0, (double)0.01, (double)23.99, (double)20.0, (double)15.99);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public Workshop(BlockBehaviour.Properties p_i48377_1_) {
        super(p_i48377_1_.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_6903_(Explosion p_149659_1_) {
        return true;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static Direction getWorkshopOrientation(BlockGetter p_220174_0_, BlockPos p_220174_1_) {
        BlockState blockstate = p_220174_0_.m_8055_(p_220174_1_);
        return blockstate.m_60734_() instanceof Workshop ? (Direction)blockstate.m_61143_((Property)FACING) : null;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_220071_2_, BlockPos pos, CollisionContext p_220071_4_) {
        Vec3 vector3d = state.m_60824_(p_220071_2_, pos);
        return this.getVoxelShape(state);
    }

    private VoxelShape getVoxelShape(BlockState p_220128_1_) {
        Direction direction = (Direction)p_220128_1_.m_61143_((Property)FACING);
        if (direction == Direction.NORTH) {
            return TO_NORTH;
        }
        if (direction == Direction.SOUTH) {
            return TO_SOUTH;
        }
        return direction == Direction.EAST ? TO_EAST : TO_WEST;
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return this.getVoxelShape(p_220053_1_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public MaterialColor m_60590_() {
        return MaterialColor.f_76411_;
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level worldIn, BlockPos pos, Player playerIn, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        playerIn.m_5893_(this.m_7246_(p_225533_1_, worldIn, pos));
        return InteractionResult.CONSUME;
    }

    public MenuProvider m_7246_(BlockState p_220052_1_, Level worldIn, BlockPos pos) {
        return new SimpleMenuProvider((p_220270_2_, p_220270_3_, p_220270_4_) -> new WorkshopContainer(p_220270_2_, p_220270_3_, ContainerLevelAccess.m_39289_((Level)worldIn, (BlockPos)pos)), CONTAINER_TITLE);
    }
}

