/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.dimension.DimensionType;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.platform.ForgeWorld;

public class BossBarProgress {
    private BossBarProgress() {
    }

    public static void tick(Chunky chunky, MinecraftServer server) {
        int quietInterval = Math.max(1, chunky.getOptions().getQuietInterval() * 20);
        if (server.m_129921_() % quietInterval != 0) {
            return;
        }
        for (ServerLevel world : server.m_129785_()) {
            CustomBossEvent bossBar;
            boolean barExists;
            ResourceLocation worldId = world.m_46472_().m_135782_();
            ResourceLocation barId = ResourceLocation.m_135820_((String)("chunky:progress_" + worldId.toString().replace(':', '_')));
            if (barId == null) continue;
            CustomBossEvents bossBarManager = server.m_129901_();
            ForgeWorld forgeWorld = new ForgeWorld(world);
            GenerationTask task = chunky.getGenerationTasks().get(forgeWorld.getName());
            boolean bl = barExists = bossBarManager.m_136297_(barId) != null;
            if (task == null && !barExists) continue;
            if (barExists) {
                bossBar = bossBarManager.m_136297_(barId);
            } else {
                bossBar = bossBarManager.m_136299_(barId, Component.m_130674_((String)barId.toString()));
                if (DimensionType.f_63840_.equals((Object)worldId)) {
                    bossBar.m_6451_(BossEvent.BossBarColor.GREEN);
                } else if (DimensionType.f_63841_.equals((Object)worldId)) {
                    bossBar.m_6451_(BossEvent.BossBarColor.RED);
                } else if (DimensionType.f_63842_.equals((Object)worldId)) {
                    bossBar.m_6451_(BossEvent.BossBarColor.PURPLE);
                } else {
                    bossBar.m_6451_(BossEvent.BossBarColor.BLUE);
                }
            }
            if (bossBar == null) continue;
            boolean silent = chunky.getOptions().isSilent();
            if (silent && bossBar.m_8323_() || !silent && !bossBar.m_8323_()) {
                bossBar.m_8321_(!silent);
            }
            if (task == null) {
                bossBar.m_7706_();
                bossBarManager.m_136302_(bossBar);
                continue;
            }
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                if (player.m_20310_(2)) {
                    bossBar.m_6543_(player);
                    continue;
                }
                bossBar.m_6539_(player);
            }
            GenerationTask.Progress progress = task.getProgress();
            bossBar.m_6456_(Component.m_130674_((String)String.format("%s | %s%% | %s:%s:%s", worldId, String.format("%.2f", Float.valueOf(progress.getPercentComplete())), String.format("%01d", progress.getHours()), String.format("%02d", progress.getMinutes()), String.format("%02d", progress.getSeconds()))));
            bossBar.m_142711_(task.getProgress().getPercentComplete() / 100.0f);
        }
    }
}

