/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;

public class PauseCommand
extends ChunkyCommand {
    public PauseCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        Map<String, GenerationTask> generationTasks = this.chunky.getGenerationTasks();
        if (generationTasks.isEmpty()) {
            sender.sendMessagePrefixed("format_pause_no_tasks", new Object[0]);
            return;
        }
        if (args.length > 1) {
            Optional<World> world = Input.tryWorld(this.chunky, String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)));
            if (!world.isPresent() || !generationTasks.containsKey(world.get().getName())) {
                sender.sendMessage("help_pause", new Object[0]);
            } else {
                generationTasks.get(world.get().getName()).stop(false);
                sender.sendMessagePrefixed("format_pause", world.get().getName());
            }
            return;
        }
        for (GenerationTask generationTask : this.chunky.getGenerationTasks().values()) {
            generationTask.stop(false);
            sender.sendMessagePrefixed("format_pause", generationTask.getSelection().world().getName());
        }
    }

    @Override
    public List<String> tabSuggestions(String[] args) {
        if (args.length == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        return Collections.emptyList();
    }
}

