/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.List;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class HelpCommand
extends ChunkyCommand {
    private final List<String> helpMessages = new ArrayList<String>();

    public HelpCommand(Chunky chunky) {
        super(chunky);
        this.helpMessages.add("help_start");
        this.helpMessages.add("help_pause");
        this.helpMessages.add("help_continue");
        this.helpMessages.add("help_cancel");
        this.helpMessages.add("help_world");
        this.helpMessages.add("help_worldborder");
        this.helpMessages.add("help_center");
        this.helpMessages.add("help_spawn");
        this.helpMessages.add("help_radius");
        this.helpMessages.add("help_corners");
        this.helpMessages.add("help_shape");
        this.helpMessages.add("help_pattern");
        this.helpMessages.add("help_silent");
        this.helpMessages.add("help_quiet");
        this.helpMessages.add("help_trim");
        this.helpMessages.add("help_progress");
        this.helpMessages.add("help_reload");
    }

    @Override
    public void execute(Sender sender, String[] args) {
        StringBuilder help = new StringBuilder();
        if (sender.isPlayer()) {
            int pageIndexLast = this.helpMessages.size() / 8;
            int pageIndex = (args.length < 2 ? 0 : Math.max(0, Input.tryInteger(args[1]).orElse(1) - 1)) % (pageIndexLast + 1);
            int helpIndexFirst = 8 * pageIndex;
            int helpIndexLast = Math.min(helpIndexFirst + 8, this.helpMessages.size());
            for (int i = helpIndexFirst; i < helpIndexLast; ++i) {
                help.append('\n').append(Translator.translate(this.helpMessages.get(i), new Object[0]));
            }
            if (pageIndex != pageIndexLast) {
                help.append('\n').append(Translator.translate("help_more", "/chunky help " + (pageIndex + 2)));
            }
        } else {
            this.helpMessages.forEach(message -> help.append('\n').append(Translator.translate(message, new Object[0])));
        }
        sender.sendMessage("help_menu", help.toString());
    }
}

