/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.io.File;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.suggestion.SuggestionProviders;
import org.popcraft.chunky.listeners.BossBarProgress;
import org.popcraft.chunky.platform.ForgeSender;
import org.popcraft.chunky.platform.ForgeServer;
import org.popcraft.chunky.platform.impl.GsonConfig;

@Mod(value="chunky")
public class ChunkyForge {
    public static final String MODID = "chunky";
    private Chunky chunky;

    public ChunkyForge() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        File configFile = new File(event.getServer().m_6237_(), "config/chunky.json");
        this.chunky = new Chunky(new ForgeServer(this, server), new GsonConfig(() -> this.chunky, configFile));
        if (this.chunky.getConfig().getContinueOnRestart()) {
            this.chunky.getCommands().get("continue").execute(this.chunky.getServer().getConsole(), new String[0]);
        }
        Command command = context -> {
            String input;
            ForgeSender sender = new ForgeSender((CommandSourceStack)context.getSource());
            Map<String, ChunkyCommand> commands = this.chunky.getCommands();
            int argsIndex = (input = context.getInput()).indexOf(32);
            String[] args = input.substring(argsIndex < 0 ? 0 : argsIndex + 1).split(" ");
            String subCommand = args.length > 0 && commands.containsKey(args[0]) ? args[0] : "help";
            commands.get(subCommand).execute(sender, args);
            return 1;
        };
        server.m_129892_().m_82094_().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cancel").then(Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"center").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"x", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"z", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).then(Commands.m_82127_((String)"confirm").executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"continue").then(Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"corners").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"x1", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"z1", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"x2", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"z2", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"help").then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"pattern").then(Commands.m_82129_((String)"pattern", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.PATTERNS).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"pause").then(Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).executes(command))).executes(command))).then(Commands.m_82127_((String)"progress").executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"quiet").then(Commands.m_82129_((String)"interval", (ArgumentType)IntegerArgumentType.integer()).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"radius").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"radius", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).then(Commands.m_82127_((String)"reload").executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"shape").then(Commands.m_82129_((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES).executes(command))).executes(command))).then(Commands.m_82127_((String)"silent").executes(command))).then(Commands.m_82127_((String)"spawn").executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"start").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"centerX", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"centerZ", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radiusX", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"radiusZ", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).executes(command))).suggests(SuggestionProviders.SHAPES).executes(command))).executes(command))).executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"trim").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"centerX", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"centerZ", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radiusX", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"radiusZ", (ArgumentType)StringArgumentType.word()).executes(command))).executes(command))).executes(command))).executes(command))).suggests(SuggestionProviders.SHAPES).executes(command))).executes(command))).executes(command))).then(Commands.m_82127_((String)"worldborder").executes(command))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"world").then(Commands.m_82129_((String)"world", (ArgumentType)DimensionArgument.m_88805_()).executes(command))).executes(command))).executes(command)).requires(serverCommandSource -> serverCommandSource.m_6761_(2)));
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.chunky.disable();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.END && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            BossBarProgress.tick(this.chunky, server);
        }
    }

    public Chunky getChunky() {
        return this.chunky;
    }
}

