/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.PredicateRegistry;
import harmonised.pmmo.api.TooltipSupplier;
import harmonised.pmmo.api.events.XpEvent;
import harmonised.pmmo.config.AutoValues;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.config.JsonConfig;
import harmonised.pmmo.events.WorldTickHandler;
import harmonised.pmmo.gui.WorldRenderHandler;
import harmonised.pmmo.gui.WorldText;
import harmonised.pmmo.gui.WorldXpDrop;
import harmonised.pmmo.network.MessageUpdateBoolean;
import harmonised.pmmo.network.MessageUpdatePlayerNBT;
import harmonised.pmmo.network.MessageWorldText;
import harmonised.pmmo.network.MessageWorldXp;
import harmonised.pmmo.network.MessageXp;
import harmonised.pmmo.network.NetworkHandler;
import harmonised.pmmo.party.Party;
import harmonised.pmmo.pmmo_saved_data.PmmoSavedData;
import harmonised.pmmo.skills.CheeseTracker;
import harmonised.pmmo.skills.PMMOFireworkEntity;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.NBTHelper;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.ServerUtil;
import harmonised.pmmo.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XP {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Material, String> materialHarvestTool = new HashMap<Material, String>(){
        {
            this.put(Material.f_76281_, "pickaxe");
            this.put(Material.f_76275_, "pickaxe");
            this.put(Material.f_76276_, "pickaxe");
            this.put(Material.f_76279_, "pickaxe");
            this.put(Material.f_76316_, "pickaxe");
            this.put(Material.f_76283_, "pickaxe");
            this.put(Material.f_76312_, "pickaxe");
            this.put(Material.f_76278_, "pickaxe");
            this.put(Material.f_76319_, "pickaxe");
            this.put(Material.f_76282_, "pickaxe");
            this.put(Material.f_76310_, "pickaxe");
            this.put(Material.f_76320_, "axe");
            this.put(Material.f_76274_, "axe");
            this.put(Material.f_76285_, "axe");
            this.put(Material.f_76313_, "shovel");
            this.put(Material.f_76314_, "shovel");
            this.put(Material.f_76317_, "shovel");
            this.put(Material.f_76308_, "shovel");
            this.put(Material.f_76304_, "shovel");
            this.put(Material.f_76280_, "shovel");
            this.put(Material.f_76300_, "hoe");
            this.put(Material.f_76301_, "hoe");
            this.put(Material.f_76277_, "hoe");
            this.put(Material.f_76302_, "hoe");
            this.put(Material.f_76271_, "hoe");
            this.put(Material.f_76270_, "hoe");
            this.put(Material.f_76315_, "hoe");
            this.put(Material.f_76272_, "shears");
            this.put(Material.f_76299_, "shears");
            this.put(Material.f_76273_, "shears");
            this.put(Material.f_76286_, "shears");
            this.put(Material.f_76311_, "shears");
            this.put(Material.f_76287_, "shears");
            this.put(Material.f_76318_, "shears");
        }
    };
    public static Set<UUID> isVeining = new HashSet<UUID>();
    public static Map<String, Style> textStyle = new HashMap<String, Style>(){
        {
            this.put("red", Style.f_131099_.m_131157_(ChatFormatting.RED));
            this.put("green", Style.f_131099_.m_131157_(ChatFormatting.GREEN));
            this.put("dark_green", Style.f_131099_.m_131157_(ChatFormatting.DARK_GREEN));
            this.put("yellow", Style.f_131099_.m_131157_(ChatFormatting.YELLOW));
            this.put("grey", Style.f_131099_.m_131157_(ChatFormatting.GRAY));
            this.put("cyan", Style.f_131099_.m_131157_(ChatFormatting.AQUA));
            this.put("blue", Style.f_131099_.m_131157_(ChatFormatting.BLUE));
            this.put("dark_blue", Style.f_131099_.m_131157_(ChatFormatting.DARK_BLUE));
            this.put("pink", Style.f_131099_.m_131157_(ChatFormatting.LIGHT_PURPLE));
            this.put("dark_purple", Style.f_131099_.m_131157_(ChatFormatting.DARK_PURPLE));
        }
    };
    public static Map<UUID, String> playerNames = new HashMap<UUID, String>();
    public static Map<String, UUID> playerUUIDs = new HashMap<String, UUID>();
    public static Map<UUID, Map<String, Double>> offlineXp = new HashMap<UUID, Map<String, Double>>();
    private static Map<UUID, String> lastBiome = new HashMap<UUID, String>();

    public static Style getColorStyle(int color) {
        return Style.f_131099_.m_131148_(TextColor.m_131266_((int)color));
    }

    public static void initValues() {
        WorldText.init();
    }

    public static String getSkill(BlockState state) {
        String skill = XP.getSkillFromTool(XP.getHarvestTool(state));
        if (skill.equals(Skill.INVALID_SKILL.toString())) {
            return XP.getSkill(state.m_60734_());
        }
        return skill;
    }

    public static String getSkill(Block block) {
        if (ForgeRegistries.BLOCKS.tags().getTag(Reference.FORGE_ORES).contains((Object)block)) {
            return Skill.MINING.toString();
        }
        if (ForgeRegistries.BLOCKS.tags().getTag(Reference.FORGE_LOGS).contains((Object)block)) {
            return Skill.WOODCUTTING.toString();
        }
        if (ForgeRegistries.BLOCKS.tags().getTag(Reference.FORGE_PLANTS).contains((Object)block)) {
            return Skill.FARMING.toString();
        }
        return Skill.INVALID_SKILL.toString();
    }

    public static String getSkillFromTool(String tool) {
        if (tool == null) {
            return Skill.INVALID_SKILL.toString();
        }
        switch (tool) {
            case "pickaxe": {
                return Skill.MINING.toString();
            }
            case "shovel": {
                return Skill.EXCAVATION.toString();
            }
            case "axe": {
                return Skill.WOODCUTTING.toString();
            }
            case "hoe": {
                return Skill.FARMING.toString();
            }
            case "shears": {
                return Skill.CRAFTING.toString();
            }
        }
        return Skill.INVALID_SKILL.toString();
    }

    public static Map<String, Double> getXp(BlockEntity tile, JType jType) {
        ResourceLocation res = tile.m_58900_().m_60734_().getRegistryName();
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return TooltipSupplier.getTooltipData(res, jType, tile);
        }
        return XP.getXp(res, jType);
    }

    public static Map<String, Double> getXp(ItemStack stack, JType jType) {
        ResourceLocation res = stack.m_41720_().getRegistryName();
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return TooltipSupplier.getTooltipData(res, jType, stack);
        }
        return XP.getXp(res, jType);
    }

    public static Map<String, Double> getXp(Entity entity, JType jType) {
        ResourceLocation res = entity.m_6095_().getRegistryName();
        if (TooltipSupplier.tooltipExists(res, jType)) {
            return TooltipSupplier.getTooltipData(res, jType, entity);
        }
        return XP.getXp(res, jType);
    }

    public static Map<String, Double> getXpBypass(ResourceLocation registryName, JType jType) {
        return XP.getXp(registryName, jType);
    }

    public static Map<String, Double> getXpBypass(String registryName, JType jType) {
        return XP.getXp(registryName, jType);
    }

    private static Map<String, Double> getXp(ResourceLocation registryName, JType jType) {
        return XP.getXp(registryName.toString(), jType);
    }

    private static Map<String, Double> getXp(String registryName, JType jType) {
        return new HashMap<String, Double>(((Map)JsonConfig.data.getOrDefault((Object)jType, new HashMap())).getOrDefault(registryName, new HashMap()));
    }

    public static ResourceLocation getBiomeResLoc(Level world, Biome biome) {
        return ((Registry)world.m_5962_().m_6632_(Registry.f_122885_).get()).m_7981_((Object)biome);
    }

    public static ResourceLocation getBiomeResLoc(Level world, BlockPos pos) {
        return ((Biome)world.m_204166_(pos).m_203334_()).getRegistryName();
    }

    public static ResourceLocation getDimResLoc(Level world) {
        return world.m_46472_().m_135782_();
    }

    public static String getHarvestTool(BlockState state) {
        String correctTool = materialHarvestTool.getOrDefault(state.m_60767_(), "none");
        if (correctTool.equals("none")) {
            double pickDestroySpeed = new ItemStack((ItemLike)Items.f_42390_).m_41691_(state);
            double axeDestroySpeed = new ItemStack((ItemLike)Items.f_42391_).m_41691_(state);
            double shovelDestroySpeed = new ItemStack((ItemLike)Items.f_42389_).m_41691_(state);
            double swordDestroySpeed = new ItemStack((ItemLike)Items.f_42388_).m_41691_(state);
            double highestDestroySpeed = pickDestroySpeed;
            correctTool = "pickaxe";
            if (highestDestroySpeed < axeDestroySpeed) {
                highestDestroySpeed = axeDestroySpeed;
                correctTool = "axe";
            }
            if (highestDestroySpeed < shovelDestroySpeed) {
                highestDestroySpeed = shovelDestroySpeed;
                correctTool = "shovel";
            }
            if (highestDestroySpeed < swordDestroySpeed) {
                correctTool = "shears";
            }
        }
        return correctTool;
    }

    public static String checkMaterial(Material material) {
        if (material.equals(Material.f_76296_)) {
            return "AIR";
        }
        if (material.equals(Material.f_76297_)) {
            return "STRUCTURE_VOID";
        }
        if (material.equals(Material.f_76298_)) {
            return "PORTAL";
        }
        if (material.equals(Material.f_76299_)) {
            return "CARPET";
        }
        if (material.equals(Material.f_76300_)) {
            return "PLANTS";
        }
        if (material.equals(Material.f_76301_)) {
            return "OCEAN_PLANT";
        }
        if (material.equals(Material.f_76302_)) {
            return "TALL_PLANTS";
        }
        if (material.equals(Material.f_76304_)) {
            return "SEA_GRASS";
        }
        if (material.equals(Material.f_76305_)) {
            return "WATER";
        }
        if (material.equals(Material.f_76306_)) {
            return "BUBBLE_COLUMN";
        }
        if (material.equals(Material.f_76307_)) {
            return "LAVA";
        }
        if (material.equals(Material.f_76308_)) {
            return "SNOW";
        }
        if (material.equals(Material.f_76309_)) {
            return "FIRE";
        }
        if (material.equals(Material.f_76310_)) {
            return "MISCELLANEOUS";
        }
        if (material.equals(Material.f_76311_)) {
            return "WEB";
        }
        if (material.equals(Material.f_76312_)) {
            return "REDSTONE_LIGHT";
        }
        if (material.equals(Material.f_76313_)) {
            return "CLAY";
        }
        if (material.equals(Material.f_76314_)) {
            return "EARTH";
        }
        if (material.equals(Material.f_76315_)) {
            return "ORGANIC";
        }
        if (material.equals(Material.f_76316_)) {
            return "PACKED_ICE";
        }
        if (material.equals(Material.f_76317_)) {
            return "SAND";
        }
        if (material.equals(Material.f_76318_)) {
            return "SPONGE";
        }
        if (material.equals(Material.f_76319_)) {
            return "SHULKER";
        }
        if (material.equals(Material.f_76320_)) {
            return "WOOD";
        }
        if (material.equals(Material.f_76270_)) {
            return "BAMBOO_SAPLING";
        }
        if (material.equals(Material.f_76271_)) {
            return "BAMBOO";
        }
        if (material.equals(Material.f_76272_)) {
            return "WOOL";
        }
        if (material.equals(Material.f_76273_)) {
            return "TNT";
        }
        if (material.equals(Material.f_76274_)) {
            return "LEAVES";
        }
        if (material.equals(Material.f_76275_)) {
            return "GLASS";
        }
        if (material.equals(Material.f_76276_)) {
            return "ICE";
        }
        if (material.equals(Material.f_76277_)) {
            return "CACTUS";
        }
        if (material.equals(Material.f_76278_)) {
            return "ROCK";
        }
        if (material.equals(Material.f_76279_)) {
            return "IRON";
        }
        if (material.equals(Material.f_76280_)) {
            return "SNOW_BLOCK";
        }
        if (material.equals(Material.f_76281_)) {
            return "ANVIL";
        }
        if (material.equals(Material.f_76282_)) {
            return "BARRIER";
        }
        if (material.equals(Material.f_76283_)) {
            return "PISTON";
        }
        if (material.equals(Material.f_76285_)) {
            return "GOURD";
        }
        if (material.equals(Material.f_76286_)) {
            return "DRAGON_EGG";
        }
        if (material.equals(Material.f_76287_)) {
            return "CAKE";
        }
        return "UNKNOWN";
    }

    public static void sendMessage(String msg, boolean bar, Player player) {
        player.m_5661_((Component)new TextComponent(msg), bar);
    }

    public static void sendMessage(String msg, boolean bar, Player player, ChatFormatting format) {
        player.m_5661_((Component)new TextComponent(msg).m_6270_(Style.f_131099_.m_131157_(format)), bar);
    }

    public static <T> Map<T, Double> addMapsAnyDouble(Map<T, Double> mapOne, Map<T, Double> mapTwo) {
        for (T key : mapTwo.keySet()) {
            if (mapOne.containsKey(key)) {
                mapOne.replace(key, mapOne.get(key) + mapTwo.get(key));
                continue;
            }
            mapOne.put(key, mapTwo.get(key));
        }
        return mapOne;
    }

    private static int doubleDoubleToInt(Double object) {
        return (int)Math.floor(object);
    }

    public static double getExtraChance(UUID uuid, String resLoc, JType jType, boolean offline) {
        return XP.getExtraChance(uuid, XP.getResLoc(resLoc), jType, offline);
    }

    public static double getExtraChance(UUID uuid, ResourceLocation resLoc, JType jType, boolean offline) {
        double extraChance;
        int startLevel;
        String skill;
        String regKey = resLoc.toString();
        double extraChancePerLevel = 0.0;
        int highestReq = 1;
        if (JsonConfig.data.get((Object)JType.REQ_BREAK).containsKey(resLoc.toString())) {
            highestReq = JsonConfig.data.get((Object)JType.REQ_BREAK).get(resLoc.toString()).entrySet().stream().map(a -> XP.doubleDoubleToInt((Double)a.getValue())).reduce(0, Math::max);
        }
        switch (jType) {
            case INFO_ORE: {
                skill = Skill.MINING.toString();
                break;
            }
            case INFO_LOG: {
                skill = Skill.WOODCUTTING.toString();
                break;
            }
            case INFO_PLANT: {
                skill = Skill.FARMING.toString();
                break;
            }
            case INFO_SMELT: {
                skill = Skill.SMITHING.toString();
                break;
            }
            case INFO_COOK: {
                skill = Skill.COOKING.toString();
                break;
            }
            case INFO_BREW: {
                skill = Skill.ALCHEMY.toString();
                break;
            }
            default: {
                LOGGER.error("WRONG getExtraChance CHANCE TYPE! PLEASE REPORT!");
                return 0.0;
            }
        }
        int n = startLevel = offline ? XP.getOfflineLevel(skill, uuid) : Skill.getLevel(skill, uuid);
        if (JsonConfig.data.get((Object)jType).containsKey(regKey) && JsonConfig.data.get((Object)jType).get(regKey).containsKey("extraChance") && JsonConfig.data.get((Object)jType).get(regKey).get("extraChance") != null) {
            extraChancePerLevel = JsonConfig.data.get((Object)jType).get(regKey).get("extraChance");
        }
        if ((extraChance = (double)(startLevel - highestReq) * extraChancePerLevel) < 0.0) {
            extraChance = 0.0;
        }
        return extraChance;
    }

    public static boolean hasElement(ResourceLocation key, JType jType) {
        return XP.hasElement(key.toString(), jType);
    }

    public static boolean hasElement(String key, JType jType) {
        return JsonConfig.data.get((Object)jType).containsKey(key);
    }

    public static boolean rollChance(double extraChance) {
        return Math.random() < extraChance;
    }

    public static void dropItems(int dropsLeft, Item item, Level world, BlockPos pos) {
        if (dropsLeft > 0) {
            while (dropsLeft > 64) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)item, 64));
                dropsLeft -= 64;
            }
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)item, dropsLeft));
        }
    }

    public static void dropItemStack(ItemStack itemStack, Level world, Vec3 pos) {
        XP.dropItemStack(itemStack, world, new BlockPos(pos));
    }

    public static void dropItemStack(ItemStack itemStack, Level world, BlockPos pos) {
        Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)itemStack);
    }

    public static boolean isPlayerSurvival(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    public static Collection<Player> getNearbyPlayers(Entity mob) {
        Level world = mob.m_20193_();
        List allPlayers = world.m_6907_();
        ArrayList<Player> nearbyPlayers = new ArrayList<Player>();
        Float closestDistance = null;
        for (Player player : allPlayers) {
            float tempDistance = mob.m_20270_((Entity)player);
            if (closestDistance != null && !(tempDistance < closestDistance.floatValue())) continue;
            closestDistance = Float.valueOf(tempDistance);
        }
        if (closestDistance != null) {
            float searchRange = closestDistance.floatValue() + 30.0f;
            for (Player player : allPlayers) {
                if (!(mob.m_20270_((Entity)player) < searchRange)) continue;
                nearbyPlayers.add(player);
            }
        }
        return nearbyPlayers;
    }

    public static float getPowerLevel(UUID uuid) {
        int enduranceLevel = Skill.getLevel(Skill.ENDURANCE.toString(), uuid);
        int combatLevel = Skill.getLevel(Skill.COMBAT.toString(), uuid);
        int archeryLevel = Skill.getLevel(Skill.ARCHERY.toString(), uuid);
        int magicLevel = Skill.getLevel(Skill.MAGIC.toString(), uuid);
        int gunslingLevel = Skill.getLevel(Skill.GUNSLINGING.toString(), uuid);
        int maxOffensive = combatLevel;
        if (maxOffensive < archeryLevel) {
            maxOffensive = archeryLevel;
        }
        if (maxOffensive < magicLevel) {
            maxOffensive = magicLevel;
        }
        if (maxOffensive < gunslingLevel) {
            maxOffensive = gunslingLevel;
        }
        return ((float)enduranceLevel + (float)maxOffensive * 1.5f) / 50.0f;
    }

    public static ServerPlayer getPlayerByUUID(UUID uuid) {
        return XP.getPlayerByUUID(uuid, PmmoSavedData.getServer());
    }

    public static ServerPlayer getPlayerByUUID(UUID uuid, MinecraftServer server) {
        ServerPlayer matchedPlayer = null;
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (!player.m_142081_().equals(uuid)) continue;
            matchedPlayer = player;
            break;
        }
        return matchedPlayer;
    }

    public static double getDistance(Vec3 a, Vec3 b) {
        return Math.sqrt(Math.pow(a.m_7096_() - b.m_7096_(), 2.0) + Math.pow(a.m_7098_() - b.m_7098_(), 2.0) + Math.pow(a.m_7094_() - b.m_7094_(), 2.0));
    }

    public static <T extends Entity> Set<T> getEntitiesInRange(Vec3 origin, Set<T> entities, double range) {
        HashSet<Entity> withinRange = new HashSet<Entity>();
        for (Entity entity : entities) {
            Vec3 pos = entity.m_20182_();
            double distance = XP.getDistance(origin, pos);
            if (!(distance <= range)) continue;
            withinRange.add(entity);
        }
        return withinRange;
    }

    public static void syncPlayerDataAndConfig(Player player) {
        XP.syncPlayerData3(player);
        XP.syncPlayerData4(player);
        XP.syncPlayerXpBoost(player);
        XP.syncPlayersSkills(player);
        NetworkHandler.sendToPlayer(new MessageUpdateBoolean(true, 1), (ServerPlayer)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringToNbt(Config.localConfig), 2), (ServerPlayer)player);
    }

    public static void syncPlayersSkills(Player player) {
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.xpMapsToNbt(PmmoSavedData.get().getAllXpMaps()), 3), (ServerPlayer)player);
    }

    public static void syncPlayerXpBoost(Player player) {
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringMapStringToNbt(APIUtils.getXpBoostsMap(player)), 6), (ServerPlayer)player);
    }

    public static void syncPlayerXpBoost(UUID uuid) {
        ServerPlayer player = XP.getPlayerByUUID(uuid, PmmoSavedData.getServer());
        if (player != null) {
            NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(NBTHelper.mapStringMapStringToNbt(APIUtils.getXpBoostsMap((Player)player)), 6), player);
        }
    }

    public static void syncPlayerData3(Player player) {
        CompoundTag fullData = NBTHelper.data3ToNbt(JsonConfig.localData);
        CompoundTag dataChunk = new CompoundTag();
        dataChunk.m_128379_("wipe", true);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayer)player);
        dataChunk = new CompoundTag();
        int i = 0;
        for (String key3 : fullData.m_128431_()) {
            if (!dataChunk.m_128441_(key3)) {
                dataChunk.m_128365_(key3, (Tag)new CompoundTag());
            }
            for (String key2 : fullData.m_128469_(key3).m_128431_()) {
                if (i >= 1000) {
                    i = 0;
                    NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayer)player);
                    dataChunk = new CompoundTag();
                    dataChunk.m_128365_(key3, (Tag)new CompoundTag());
                }
                dataChunk.m_128469_(key3).m_128365_(key2, (Tag)fullData.m_128469_(key3).m_128469_(key2));
                ++i;
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 4), (ServerPlayer)player);
    }

    public static void syncPlayerData4(Player player) {
        CompoundTag fullData = NBTHelper.data4ToNbt(JsonConfig.localData2);
        CompoundTag dataChunk = new CompoundTag();
        dataChunk.m_128379_("wipe", true);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayer)player);
        dataChunk = new CompoundTag();
        int i = 0;
        for (String key4 : fullData.m_128431_()) {
            if (!dataChunk.m_128441_(key4)) {
                dataChunk.m_128365_(key4, (Tag)new CompoundTag());
            }
            for (String key3 : fullData.m_128469_(key4).m_128431_()) {
                if (!dataChunk.m_128469_(key4).m_128441_(key3)) {
                    dataChunk.m_128469_(key4).m_128365_(key3, (Tag)new CompoundTag());
                }
                for (String key2 : fullData.m_128469_(key4).m_128469_(key3).m_128431_()) {
                    if (i >= 1000) {
                        i = 0;
                        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayer)player);
                        dataChunk = new CompoundTag();
                        dataChunk.m_128365_(key4, (Tag)new CompoundTag());
                        dataChunk.m_128469_(key4).m_128365_(key3, (Tag)new CompoundTag());
                    }
                    dataChunk.m_128469_(key4).m_128469_(key3).m_128365_(key2, (Tag)fullData.m_128469_(key4).m_128469_(key3).m_128469_(key2));
                    ++i;
                }
            }
        }
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(dataChunk, 5), (ServerPlayer)player);
    }

    public static void syncPlayer(Player player) {
        CompoundTag prefsTag = NBTHelper.mapStringToNbt(Config.getPreferencesMap(player));
        CompoundTag abilitiesTag = NBTHelper.mapStringToNbt(Config.getAbilitiesMap(player));
        XP.syncPlayerDataAndConfig(player);
        XP.updateRecipes((ServerPlayer)player);
        NetworkHandler.sendToPlayer(new MessageXp(0.0, "42069", 0.0, true), (ServerPlayer)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(prefsTag, 0), (ServerPlayer)player);
        NetworkHandler.sendToPlayer(new MessageUpdatePlayerNBT(abilitiesTag, 1), (ServerPlayer)player);
        WorldTickHandler.updateVein(player, 0.0);
        for (Map.Entry<String, Double> entry : Config.getXpMap(player).entrySet()) {
            NetworkHandler.sendToPlayer(new MessageXp(entry.getValue(), entry.getKey(), 0.0, true), (ServerPlayer)player);
        }
    }

    public static ResourceLocation getResLoc(String regKey) {
        try {
            return new ResourceLocation(regKey);
        }
        catch (Exception e) {
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getResLoc(String firstPart, String secondPart) {
        try {
            return new ResourceLocation(firstPart, secondPart);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Double> getJsonMap(ResourceLocation registryName, JType type) {
        return XP.getJsonMap(registryName.toString(), type);
    }

    public static Map<String, Double> getJsonMap(String registryName, JType type) {
        return ((Map)JsonConfig.data.getOrDefault((Object)type, new HashMap())).getOrDefault(registryName, new HashMap());
    }

    public static boolean checkReq(Player player, String res, JType jType) {
        return XP.checkReq(player, XP.getResLoc(res), jType);
    }

    public static boolean checkReq(Player player, BlockEntity tile, JType jType) {
        if (tile == null) {
            return true;
        }
        if (tile.m_58900_().m_60795_()) {
            return true;
        }
        if (PredicateRegistry.predicateExists(tile.m_58900_().m_60734_().getRegistryName(), jType)) {
            return PredicateRegistry.checkPredicateReq(player, tile, jType);
        }
        return XP.checkReq(player, XP.getJsonMap(tile.m_58900_().m_60734_().getRegistryName().toString(), jType));
    }

    public static boolean checkReq(Player player, ResourceLocation res, JType jType) {
        if (res == null) {
            return true;
        }
        if (res.equals((Object)Items.f_41852_.getRegistryName()) || player.m_7500_()) {
            return true;
        }
        if (PredicateRegistry.predicateExists(res, jType)) {
            return PredicateRegistry.checkPredicateReq(player, res, jType);
        }
        return XP.checkReq(player, XP.getJsonMap(res.toString(), jType));
    }

    public static boolean checkReq(Player player, Map<String, Double> reqMap) {
        boolean failedReq = false;
        try {
            if (JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).containsKey(player.m_142081_().toString()) && JsonConfig.data.get((Object)JType.PLAYER_SPECIFIC).get(player.m_142081_().toString()).containsKey("ignoreReq")) {
                return true;
            }
            if (reqMap != null) {
                for (Map.Entry<String, Double> entry : reqMap.entrySet()) {
                    double startLevel = Skill.getLevel(entry.getKey(), player);
                    if (!(startLevel < entry.getValue())) continue;
                    failedReq = true;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        return !failedReq;
    }

    public static int getHighestReq(String regKey, JType jType) {
        int highestReq = 1;
        Map<String, Double> map = XP.getJsonMap(regKey, jType);
        if (map != null) {
            for (Map.Entry<String, Double> entry : map.entrySet()) {
                if (!((double)highestReq < entry.getValue())) continue;
                highestReq = (int)entry.getValue().doubleValue();
            }
        }
        return highestReq;
    }

    public static Set<String> getElementsFromTag(String tag) {
        ResourceLocation keyRL = new ResourceLocation(tag);
        TagKey itemKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)keyRL);
        TagKey blockKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)keyRL);
        TagKey fluidKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)keyRL);
        TagKey entityKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITIES.getRegistryKey(), (ResourceLocation)keyRL);
        HashSet<String> results = new HashSet<String>();
        for (Item element : ForgeRegistries.ITEMS.tags().getTag(itemKey).stream().toList()) {
            try {
                results.add(element.getRegistryName().toString());
            }
            catch (Exception exception) {}
        }
        for (Item element : ForgeRegistries.BLOCKS.tags().getTag(blockKey).stream().toList()) {
            try {
                results.add(element.getRegistryName().toString());
            }
            catch (Exception exception) {}
        }
        for (Item element : ForgeRegistries.FLUIDS.tags().getTag(fluidKey).stream().toList()) {
            try {
                results.add(element.getRegistryName().toString());
            }
            catch (Exception exception) {}
        }
        for (Item element : ForgeRegistries.ENTITIES.tags().getTag(entityKey).stream().toList()) {
            try {
                results.add(element.getRegistryName().toString());
            }
            catch (Exception exception) {}
        }
        return results;
    }

    public static Block getBlock(String regKey) {
        ResourceLocation resLoc = XP.getResLoc(regKey);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resLoc);
        return block == null ? Blocks.f_50016_ : block;
    }

    public static Item getItem(String regKey) {
        ResourceLocation resLoc = XP.getResLoc(regKey);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(resLoc);
        if (item != null && !item.equals(Items.f_41852_)) {
            return item;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resLoc);
        if (block != null) {
            return block.m_5456_();
        }
        return Items.f_41852_;
    }

    public static Item getItem(ResourceLocation resLoc) {
        return XP.getItem(resLoc.toString());
    }

    public static boolean scanBlock(Block block, int radius, Player player) {
        BlockPos playerPos = XP.vecToBlock(player.m_20182_());
        boolean matched = false;
        for (int x = -radius; x <= radius; ++x) {
            block1: for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block currBlock = player.f_19853_.m_8055_(new BlockPos(playerPos.m_123341_() + x, playerPos.m_123342_() + y, playerPos.m_123343_() + z)).m_60734_();
                    if (!currBlock.equals(block)) continue;
                    matched = true;
                    continue block1;
                }
            }
        }
        return matched;
    }

    public static double getMaxLevel() {
        double serverMaxLevel = Config.getConfig("maxLevel");
        return serverMaxLevel <= 1.0 ? (double)Config.forgeConfig.maxLevel.get().intValue() : serverMaxLevel;
    }

    public static double getXpBoostDurabilityMultiplier(ItemStack itemStack) {
        double scale = 1.0;
        if (itemStack.m_41763_()) {
            double durabilityPercentage = 1.0 - (double)itemStack.m_41773_() / (double)itemStack.m_41776_();
            double scaleStart = Config.getConfig("scaleXpBoostByDurabilityStart") / 100.0;
            double scaleEnd = Math.max(scaleStart, Config.getConfig("scaleXpBoostByDurabilityEnd") / 100.0);
            scale = Util.mapCapped(durabilityPercentage, scaleStart, scaleEnd, 0.0, 1.0);
        }
        return scale;
    }

    public static Map<String, Double> getStackXpBoosts(ItemStack itemStack, boolean type) {
        Item item = itemStack.m_41720_();
        JType jType = type ? JType.XP_BONUS_HELD : JType.XP_BONUS_WORN;
        String regName = item.getRegistryName().toString();
        HashMap<String, Double> itemXpMap = PredicateRegistry.predicateExists(item.getRegistryName(), jType) ? TooltipSupplier.getTooltipData(item.getRegistryName(), jType, itemStack) : (HashMap<String, Double>)JsonConfig.data.get((Object)jType).getOrDefault(regName, new HashMap());
        itemXpMap = new HashMap<String, Double>(itemXpMap);
        if (Config.getConfig("scaleXpBoostByDurability") != 0.0) {
            XP.multiplyMapAnyDouble(itemXpMap, XP.getXpBoostDurabilityMultiplier(itemStack));
        }
        return itemXpMap;
    }

    public static double getStackXpBoost(Player player, ItemStack itemStack, String skill, boolean type) {
        Map itemXpMap;
        if (itemStack == null || itemStack.m_41619_()) {
            return 0.0;
        }
        Item item = itemStack.m_41720_();
        JType jType = type ? JType.XP_BONUS_HELD : JType.XP_BONUS_WORN;
        double boost = 0.0;
        String regName = item.getRegistryName().toString();
        Map map = itemXpMap = PredicateRegistry.predicateExists(item.getRegistryName(), jType) ? TooltipSupplier.getTooltipData(item.getRegistryName(), jType, itemStack) : (Map)JsonConfig.data.get((Object)jType).getOrDefault(regName, new HashMap());
        if (itemXpMap != null && itemXpMap.containsKey(skill) && (type || XP.checkReq(player, item.getRegistryName(), JType.REQ_WEAR))) {
            boost = (Double)itemXpMap.get(skill);
            if (Config.getConfig("scaleXpBoostByDurability") != 0.0 && itemStack.m_41763_()) {
                boost *= XP.getXpBoostDurabilityMultiplier(itemStack);
            }
        }
        return boost;
    }

    public static double getGlobalMultiplier(String skill) {
        return ((Map)JsonConfig.data.get((Object)JType.XP_MULTIPLIER_DIMENSION).getOrDefault("all_dimensions", new HashMap())).getOrDefault(skill, 1.0);
    }

    public static double getDimensionMultiplier(String skill, Player player) {
        try {
            String dimensionKey = XP.getDimResLoc(player.f_19853_).toString();
            return ((Map)JsonConfig.data.get((Object)JType.XP_MULTIPLIER_DIMENSION).getOrDefault(dimensionKey, new HashMap())).getOrDefault(skill, 1.0);
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public static double getDifficultyMultiplier(Player player, String skill) {
        double difficultyMultiplier = 1.0;
        if (skill.equals(Skill.COMBAT.toString()) || skill.equals(Skill.ARCHERY.toString()) || skill.equals(Skill.GUNSLINGING.toString()) || skill.equals(Skill.ENDURANCE.toString())) {
            switch (player.f_19853_.m_46791_()) {
                case PEACEFUL: {
                    difficultyMultiplier = Config.forgeConfig.peacefulMultiplier.get();
                    break;
                }
                case EASY: {
                    difficultyMultiplier = Config.forgeConfig.easyMultiplier.get();
                    break;
                }
                case NORMAL: {
                    difficultyMultiplier = Config.forgeConfig.normalMultiplier.get();
                    break;
                }
                case HARD: {
                    difficultyMultiplier = Config.forgeConfig.hardMultiplier.get();
                    break;
                }
            }
        }
        return difficultyMultiplier;
    }

    public static double getItemBoost(Player player, String skill) {
        if (player.m_21205_().m_41720_().getRegistryName() == null) {
            return 0.0;
        }
        double itemBoost = 0.0;
        skill = skill.toLowerCase();
        Inventory inv = player.m_150109_();
        itemBoost += XP.getStackXpBoost(player, player.m_21205_(), skill, true);
        if (!inv.m_8020_(39).m_41619_()) {
            itemBoost += XP.getStackXpBoost(player, inv.m_8020_(39), skill, false);
        }
        if (!inv.m_8020_(38).m_41619_()) {
            itemBoost += XP.getStackXpBoost(player, inv.m_8020_(38), skill, false);
        }
        if (!inv.m_8020_(37).m_41619_()) {
            itemBoost += XP.getStackXpBoost(player, inv.m_8020_(37), skill, false);
        }
        if (!inv.m_8020_(36).m_41619_()) {
            itemBoost += XP.getStackXpBoost(player, inv.m_8020_(36), skill, false);
        }
        if (!inv.m_8020_(40).m_41619_()) {
            itemBoost += XP.getStackXpBoost(player, inv.m_8020_(40), skill, false);
        }
        return itemBoost;
    }

    public static Map<String, Double> getDimensionBoosts(String dimKey) {
        return JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault(dimKey, new HashMap());
    }

    public static double getDimensionBoost(Player player, String skill) {
        try {
            String dimensionKey = XP.getDimResLoc(player.f_19853_).toString();
            return ((Map)JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault(dimensionKey, new HashMap())).getOrDefault(skill, 0.0);
        }
        catch (NullPointerException e) {
            return 0.0;
        }
    }

    public static double getGlobalBoost(String skill) {
        return ((Map)JsonConfig.data.get((Object)JType.XP_BONUS_DIMENSION).getOrDefault("all_dimensions", new HashMap())).getOrDefault(skill, 0.0);
    }

    public static CompoundTag writeUniqueId(UUID uuid) {
        CompoundTag CompoundTag2 = new CompoundTag();
        CompoundTag2.m_128356_("M", uuid.getMostSignificantBits());
        CompoundTag2.m_128356_("L", uuid.getLeastSignificantBits());
        return CompoundTag2;
    }

    public static Map<String, Double> getBiomeBoosts(Player player) {
        HashMap<String, Double> biomeBoosts = new HashMap<String, Double>();
        double biomePenaltyMultiplier = Config.getConfig("biomePenaltyMultiplier");
        Biome biome = (Biome)player.f_19853_.m_204166_(XP.vecToBlock(player.m_20182_())).m_203334_();
        ResourceLocation resLoc = biome.getRegistryName();
        if (resLoc == null) {
            return new HashMap<String, Double>();
        }
        String biomeKey = resLoc.toString();
        Map<String, Double> biomeMap = XP.getJsonMap(biomeKey, JType.XP_BONUS_BIOME);
        if (biomeMap != null) {
            boolean metReq = XP.checkReq(player, resLoc, JType.REQ_BIOME);
            for (Map.Entry<String, Double> entry : biomeMap.entrySet()) {
                biomeBoosts.put(entry.getKey(), metReq ? entry.getValue() : Math.min(entry.getValue(), -biomePenaltyMultiplier * 100.0));
            }
        }
        return biomeBoosts;
    }

    public static double getMultiplier(Player player, String skill) {
        double multiplier = Config.forgeConfig.globalMultiplier.get();
        double globalMultiplier = XP.getGlobalMultiplier(skill);
        double dimensionMultiplier = XP.getDimensionMultiplier(skill, player);
        double difficultyMultiplier = XP.getDifficultyMultiplier(player, skill);
        double globalBoost = XP.getGlobalBoost(skill);
        double itemBoost = XP.getItemBoost(player, skill);
        double biomeBoost = XP.getBiomeBoosts(player).getOrDefault(skill, 0.0);
        double dimensionBoost = XP.getDimensionBoost(player, skill);
        double playerBoost = PmmoSavedData.get().getPlayerXpBoost(player.m_142081_(), skill);
        double additiveMultiplier = 1.0 + (itemBoost + biomeBoost + dimensionBoost + globalBoost + playerBoost) / 100.0;
        multiplier *= globalMultiplier;
        multiplier *= dimensionMultiplier;
        multiplier *= difficultyMultiplier;
        multiplier *= additiveMultiplier;
        return Math.max(0.0, multiplier *= CheeseTracker.getLazyMultiplier(player.m_142081_(), skill));
    }

    public static double getHorizontalDistance(Vec3 p1, Vec3 p2) {
        return Math.sqrt(Math.pow(p1.m_7096_() - p2.m_7096_(), 2.0) + Math.pow(p1.m_7094_() - p2.m_7094_(), 2.0));
    }

    public static void awardXp(ServerPlayer player, String skill, @Nullable String sourceName, double amount, boolean skip, boolean ignoreBonuses, boolean causedByParty) {
        Party party;
        double nextXpMilestone;
        double nextTotalXpMilestone;
        if (player.f_19853_.f_46443_ || Double.isNaN(amount) || player instanceof FakePlayer) {
            return;
        }
        PmmoSavedData pmmoSavedData = PmmoSavedData.get();
        UUID uuid = player.m_142081_();
        XpEvent xpEvent = new XpEvent((Player)player, skill, sourceName, amount, skip, ignoreBonuses, causedByParty);
        if (MinecraftForge.EVENT_BUS.post((Event)xpEvent)) {
            return;
        }
        skill = xpEvent.getSkill();
        sourceName = xpEvent.getSourceName();
        amount = xpEvent.getAmount();
        skip = xpEvent.isSkip();
        ignoreBonuses = xpEvent.isIgnoreBonuses();
        causedByParty = xpEvent.isCausedByParty();
        if (!ignoreBonuses && !causedByParty) {
            amount *= XP.getMultiplier((Player)player, skill);
        }
        String playerName = player.m_5446_().getString();
        int startLevel = Skill.getLevel(skill, uuid);
        double startXp = Skill.getXp(skill, uuid);
        double startTotalXp = XP.getTotalXpFromMap(Config.getXpMap((Player)player));
        double maxXp = Config.getConfig("maxXp");
        pmmoSavedData.addXp(skill, uuid, amount);
        double i = 0.0;
        while ((nextTotalXpMilestone = Math.pow(10.0, i += 1.0)) < startTotalXp) {
        }
        if (nextTotalXpMilestone < (double)XP.getTotalXpFromMap(Config.getXpMap((Player)player))) {
            ServerUtil.sendMsgToAll((Component)new TranslatableComponent("pmmo.milestoneTotalXp", new Object[]{playerName, nextTotalXpMilestone}).m_6270_(textStyle.get("green")), ChatType.CHAT);
        }
        i = 0.0;
        while ((nextXpMilestone = Math.pow(10.0, i += 1.0)) < startXp) {
        }
        if (nextXpMilestone < Skill.getXp(skill, uuid)) {
            ServerUtil.sendMsgToAll((Component)new TranslatableComponent("pmmo.milestoneXpInSkill", new Object[]{playerName, nextXpMilestone, skill}).m_6270_(Skill.getSkillStyle(skill)), ChatType.CHAT);
        }
        if (!causedByParty && (party = pmmoSavedData.getParty(uuid)) != null) {
            Set<ServerPlayer> membersInRange = party.getOnlineMembersInRange(player);
            int membersInRangeSize = membersInRange.size();
            double partyMultiplier = party.getMultiplier(membersInRangeSize);
            party.submitXpGained(uuid, amount *= partyMultiplier);
            amount /= (double)membersInRangeSize + 1.0;
            for (ServerPlayer partyMember : membersInRange) {
                XP.awardXp(partyMember, skill, sourceName, amount, true, ignoreBonuses, true);
            }
        }
        if (amount == 0.0) {
            return;
        }
        int currLevel = Skill.getLevel(skill, uuid);
        if (startLevel != currLevel) {
            WorldTickHandler.updateVein((Player)player, 0.0);
            XP.updateRecipes(player);
            if (JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skill.toLowerCase()) != null) {
                Map<String, Double> commandMap = JsonConfig.data.get((Object)JType.LEVEL_UP_COMMAND).get(skill.toLowerCase());
                for (Map.Entry<String, Double> entry : commandMap.entrySet()) {
                    int commandLevel = (int)Math.floor(entry.getValue());
                    if (startLevel >= commandLevel || currLevel < commandLevel) continue;
                    String command = entry.getKey().replace(">player<", playerName).replace(">level<", "" + commandLevel);
                    try {
                        player.m_20194_().m_129892_().m_82094_().execute(command, (Object)player.m_20194_().m_129893_());
                        LOGGER.info("Executing command \"" + command + "\"\nTrigger: " + playerName + " level up from " + startLevel + " to " + currLevel + " in " + skill + ", trigger level " + commandLevel);
                    }
                    catch (CommandSyntaxException e) {
                        LOGGER.error("Invalid level up command \"" + command + "\"", (Throwable)e);
                    }
                }
            }
        }
        NetworkHandler.sendToPlayer(new MessageXp(startXp, skill, amount, skip), player);
        if (!skip && Config.forgeConfig.logXpGainedInDebugLog.get().booleanValue()) {
            LOGGER.debug(playerName + " +" + amount + "xp in: " + skill + " for: " + sourceName + " total xp: " + Skill.getXp(skill, uuid));
        }
        if (startXp + amount >= maxXp && startXp < maxXp) {
            XP.sendMessage(skill + " max startLevel reached, you psycho!", false, (Player)player, ChatFormatting.LIGHT_PURPLE);
            LOGGER.info(playerName + " " + skill + " max startLevel reached");
        }
    }

    @Deprecated
    public static void awardXpTrigger(UUID uuid, String triggerKey, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        if (JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).containsKey(triggerKey)) {
            XP.awardXpMap(uuid, JsonConfig.data.get((Object)JType.XP_VALUE_TRIGGER).get(triggerKey), sourceName, skip, ignoreBonuses);
        } else {
            LOGGER.error("TRIGGER XP AWARD \"" + triggerKey + "\" DOES NOT HAVE ANY VALUES, CANNOT AWARD");
        }
    }

    public static void awardXpMap(UUID uuid, Map<String, Double> map, @Nullable String sourceName, boolean skip, boolean ignoreBonuses) {
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            Skill.addXp(entry.getKey(), uuid, (double)entry.getValue(), sourceName, skip, ignoreBonuses);
        }
    }

    public static void updateRecipes(ServerPlayer player) {
        if (Config.forgeConfig.craftReqEnabled.get().booleanValue()) {
            Collection allRecipes = player.m_20194_().m_129894_().m_44051_();
            HashSet<Recipe> removeRecipes = new HashSet<Recipe>();
            HashSet<Recipe> newRecipes = new HashSet<Recipe>();
            for (Recipe recipe : allRecipes) {
                if (recipe == null || recipe.m_8043_() == null) continue;
                if (XP.checkReq((Player)player, recipe.m_8043_().m_41720_().getRegistryName(), JType.REQ_CRAFT)) {
                    newRecipes.add(recipe);
                    continue;
                }
                removeRecipes.add(recipe);
            }
            player.m_8952_().m_12806_(removeRecipes, player);
            player.m_8952_().m_12791_(newRecipes, player);
        }
    }

    public static void scanUnlocks(int level, String skill) {
    }

    public static int getSkillReqGap(Player player, ResourceLocation res, JType jType) {
        Map<String, Double> reqs = XP.getJsonMap(res.toString(), jType);
        if (reqs == null) {
            return 0;
        }
        return XP.getSkillReqGap(player, reqs);
    }

    public static int getSkillReqGap(Player player, Map<String, Double> reqs) {
        int gap = 0;
        if (!XP.checkReq(player, reqs) && reqs != null) {
            gap = (int)Math.floor(reqs.entrySet().stream().map(entry -> (int)Math.floor((Double)entry.getValue()) - Skill.getLevel((String)entry.getKey(), player)).reduce(0, Math::max).intValue());
        }
        return gap;
    }

    public static BlockPos vecToBlock(Vec3 pos) {
        return new BlockPos(pos);
    }

    public static Vec3 blockToVec(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vec3 blockToMiddleVec(BlockPos pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static void spawnRocket(Level world, BlockPos pos, String skill, @Nullable WorldText explosionText) {
        XP.spawnRocket(world, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), skill, explosionText);
    }

    public static void spawnRocket(Level world, Vec3 pos, String skill, @Nullable WorldText explosionText) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag fw = new CompoundTag();
        ListTag explosion = new ListTag();
        CompoundTag l = new CompoundTag();
        int[] colors = new int[]{Skill.getSkillColor(skill)};
        l.m_128405_("Flicker", 1);
        l.m_128405_("Trail", 0);
        l.m_128405_("Type", 1);
        l.m_128365_("Colors", (Tag)new IntArrayTag(colors));
        explosion.add((Object)l);
        fw.m_128365_("Explosions", (Tag)explosion);
        fw.m_128405_("Flight", 0);
        nbt.m_128365_("Fireworks", (Tag)fw);
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42688_);
        itemStack.m_41751_(nbt);
        PMMOFireworkEntity fireworkRocketEntity = new PMMOFireworkEntity(world, pos.m_7096_() + 0.5, pos.m_7098_() + 0.5, pos.m_7094_() + 0.5, itemStack);
        if (explosionText != null) {
            fireworkRocketEntity.setExplosionText(explosionText);
        }
        world.m_7967_((Entity)fireworkRocketEntity);
    }

    public static <T> Map<T, Double> ceilMapAnyDouble(Map<T, Double> input) {
        for (Map.Entry<T, Double> entry : input.entrySet()) {
            input.replace(entry.getKey(), Math.ceil(entry.getValue()));
        }
        return input;
    }

    public static <T> Map<T, Double> multiplyMapAnyDouble(Map<T, Double> input, double multiplier) {
        for (Map.Entry<T, Double> entry : input.entrySet()) {
            input.put(entry.getKey(), entry.getValue() * multiplier);
        }
        return input;
    }

    public static <T> Map<T, Double> mergeMapHighestValue(Map<T, Double> map1, Map<T, Double> map2) {
        for (Map.Entry<T, Double> entry : map2.entrySet()) {
            if (!map1.containsKey(entry.getKey())) {
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(map1.get(entry.getKey()) < entry.getValue())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
        return map1;
    }

    public static Map<String, Double> getEnchantUseReq(ResourceLocation resLoc, int enchantLevel) {
        HashMap<String, Double> reqs = new HashMap<String, Double>();
        int highestSpecifiedLevel = 0;
        if (((Map)JsonConfig.data2.getOrDefault((Object)JType.REQ_USE_ENCHANTMENT, new HashMap())).containsKey(resLoc.toString())) {
            int level;
            Map<String, Map<String, Double>> levelMaps = JsonConfig.data2.get((Object)JType.REQ_USE_ENCHANTMENT).get(resLoc.toString());
            ArrayList<Integer> levels = new ArrayList<Integer>();
            for (String levelKey : levelMaps.keySet()) {
                levels.add(Integer.parseInt(levelKey));
            }
            levels.sort(Comparator.comparingInt(a -> a));
            Iterator<String> iterator = levels.iterator();
            while (iterator.hasNext() && (level = ((Integer)((Object)iterator.next())).intValue()) <= enchantLevel) {
                highestSpecifiedLevel = level;
                Map<String, Double> skillMap = levelMaps.get(String.valueOf(level));
                for (Map.Entry<String, Double> skillElement : skillMap.entrySet()) {
                    String skill = skillElement.getKey();
                    if (!reqs.containsKey(skill)) {
                        reqs.put(skill, skillElement.getValue());
                        continue;
                    }
                    if (!((Double)reqs.get(skill) < skillElement.getValue())) continue;
                    reqs.put(skill, skillElement.getValue());
                }
            }
        }
        if (Config.forgeConfig.enchantUseReqAutoScaleEnabled.get().booleanValue() && enchantLevel > highestSpecifiedLevel) {
            XP.multiplyMapAnyDouble(reqs, (double)enchantLevel / (double)highestSpecifiedLevel);
        }
        return reqs;
    }

    public static Map<String, Double> getEnchantsUseReq(ItemStack itemStack) {
        HashMap<String, Double> reqs = new HashMap<String, Double>();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        for (Map.Entry entry : enchantments.entrySet()) {
            XP.mergeMapHighestValue(reqs, XP.getEnchantUseReq(((Enchantment)entry.getKey()).getRegistryName(), (Integer)entry.getValue()));
        }
        return reqs;
    }

    public static void applyWornPenalty(Player player, ItemStack itemStack) {
        String wearReqSkill;
        if (Config.getConfig("wearReqEnabled") == 0.0) {
            return;
        }
        ResourceLocation resLoc = itemStack.m_41720_().getRegistryName();
        Map<String, Double> wearReq = XP.getJsonMap(resLoc, JType.REQ_WEAR);
        String string = wearReqSkill = Config.forgeConfig.autoGenerateWearReqAsCombat.get() != false ? Skill.COMBAT.toString() : Skill.ENDURANCE.toString();
        if (!wearReq.containsKey(wearReqSkill) && Config.getConfig("autoGenerateValuesEnabled") != 0.0 && Config.getConfig("autoGenerateWearReqDynamicallyEnabled") != 0.0) {
            wearReq.put(wearReqSkill, AutoValues.getWearReqFromStack(itemStack));
        }
        if (!XP.checkReq(player, wearReq)) {
            int gap = XP.getSkillReqGap(player, resLoc, JType.REQ_WEAR);
            if (gap > 9) {
                gap = 9;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 75, gap, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 75, gap, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 75, gap, false, true));
            if (Config.forgeConfig.strictReqWear.get().booleanValue() || EnchantmentHelper.m_44920_((ItemStack)itemStack)) {
                ItemStack droppedItemStack = itemStack.m_41777_();
                player.m_7197_(droppedItemStack, false, false);
                itemStack.m_41764_(0);
                player.m_5661_((Component)new TranslatableComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslatableComponent(droppedItemStack.m_41720_().m_5524_())}).m_6270_(textStyle.get("red")), true);
                player.m_5661_((Component)new TranslatableComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslatableComponent(droppedItemStack.m_41720_().m_5524_())}).m_6270_(textStyle.get("red")), false);
            } else {
                player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToWear", new Object[]{new TranslatableComponent(itemStack.m_41720_().m_5524_())}).m_6270_(textStyle.get("red")), true);
            }
        }
        XP.applyEnchantmentUsePenalty(player, itemStack);
    }

    public static void applyEnchantmentUsePenalty(Player player, ItemStack itemStack) {
        if (Config.getConfig("enchantUseReqEnabled") == 0.0) {
            return;
        }
        ResourceLocation resLoc = itemStack.m_41720_().getRegistryName();
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        for (Map.Entry entry : enchantments.entrySet()) {
            ResourceLocation enchantResLoc = ((Enchantment)entry.getKey()).getRegistryName();
            if (XP.checkReq(player, XP.getEnchantUseReq(enchantResLoc, (Integer)entry.getValue()))) continue;
            int gap = XP.getSkillReqGap(player, resLoc, JType.REQ_USE_ENCHANTMENT);
            if (gap > 9) {
                gap = 9;
            }
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 75, gap, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 75, gap, false, true));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 75, gap, false, true));
            if (Config.forgeConfig.strictReqUseEnchantment.get().booleanValue() || EnchantmentHelper.m_44920_((ItemStack)itemStack)) {
                ItemStack droppedItemStack = itemStack.m_41777_();
                player.m_7197_(droppedItemStack, false, false);
                itemStack.m_41764_(0);
                player.m_5661_((Component)new TranslatableComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslatableComponent(droppedItemStack.m_41720_().m_5524_())}).m_6270_(textStyle.get("red")), true);
                player.m_5661_((Component)new TranslatableComponent("pmmo.gotTooHotDroppedItem", new Object[]{new TranslatableComponent(droppedItemStack.m_41720_().m_5524_())}).m_6270_(textStyle.get("red")), false);
                continue;
            }
            player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToUseEnchantment", new Object[]{new TranslatableComponent(((Enchantment)entry.getKey()).m_44704_()), new TranslatableComponent(itemStack.m_41720_().m_5524_())}).m_6270_(textStyle.get("red")), true);
        }
    }

    public static void checkBiomeLevelReq(Player player) {
        Map<String, Double> negativeEffect;
        Biome biome = (Biome)player.f_19853_.m_204166_(XP.vecToBlock(player.m_20182_())).m_203334_();
        ResourceLocation resLoc = XP.getBiomeResLoc(player.f_19853_, biome);
        if (resLoc == null) {
            return;
        }
        String biomeKey = resLoc.toString();
        UUID playerUUID = player.m_142081_();
        if (!JsonConfig.data.containsKey((Object)JType.REQ_BIOME)) {
            return;
        }
        Map<String, Double> biomeReq = JsonConfig.data.get((Object)JType.REQ_BIOME).get(biomeKey);
        Map<String, Map<String, Double>> negativeEffects = JsonConfig.data.get((Object)JType.BIOME_EFFECT_NEGATIVE);
        Map<String, Map<String, Double>> positiveEffects = JsonConfig.data.get((Object)JType.BIOME_EFFECT_POSITIVE);
        if (!lastBiome.containsKey(playerUUID)) {
            lastBiome.put(playerUUID, "none");
        }
        if (XP.checkReq(player, resLoc, JType.REQ_BIOME)) {
            Map<String, Double> positiveEffect;
            if (positiveEffects != null && (positiveEffect = positiveEffects.get(biomeKey)) != null) {
                for (Map.Entry<String, Double> entry : positiveEffect.entrySet()) {
                    Potion effect = (Potion)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()));
                    if (effect == null) continue;
                    for (MobEffectInstance instance : effect.m_43488_()) {
                        player.m_7292_(instance);
                    }
                }
            }
        } else if (negativeEffects != null && (negativeEffect = negativeEffects.get(biomeKey)) != null) {
            for (Map.Entry<String, Double> entry : negativeEffect.entrySet()) {
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(XP.getResLoc(entry.getKey()));
                if (potion == null) continue;
                for (MobEffectInstance instance : potion.m_43488_()) {
                    player.m_7292_(instance);
                }
            }
            if (player.f_19853_.m_5776_() && !lastBiome.get(playerUUID).equals(biomeKey)) {
                player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslatableComponent(XP.getBiomeResLoc(player.f_19853_, biome).toString())}).m_6270_(textStyle.get("red")), true);
                player.m_5661_((Component)new TranslatableComponent("pmmo.notSkilledEnoughToSurvive", new Object[]{new TranslatableComponent(XP.getBiomeResLoc(player.f_19853_, biome).toString())}).m_6270_(textStyle.get("red")), false);
                XP.sendPlayerSkillList(player, biomeReq);
            }
        }
        lastBiome.put(playerUUID, biomeKey);
    }

    public static int getTotalLevelFromUUID(UUID uuid) {
        return XP.getTotalLevelFromMap(Config.getXpMap(uuid));
    }

    public static <T> int getTotalLevelFromMap(Map<T, Double> input) {
        int sum = 0;
        for (double xp : input.values()) {
            sum += XP.levelAtXp(xp);
        }
        return sum;
    }

    public static <T> int getTotalXpFromMap(Map<T, Double> input) {
        int sum = 0;
        for (double xp : input.values()) {
            sum = (int)((double)sum + xp);
        }
        return sum;
    }

    public static Map<String, Double> getOfflineXpMap(UUID uuid) {
        if (!offlineXp.containsKey(uuid)) {
            offlineXp.put(uuid, new HashMap());
        }
        return offlineXp.get(uuid);
    }

    public static void setOfflineXpMaps(Map<UUID, Map<String, Double>> newOfflineXp) {
        offlineXp = new HashMap<UUID, Map<String, Double>>(newOfflineXp);
    }

    public static void removeOfflineXpUuid(UUID uuid) {
        offlineXp.remove(uuid);
    }

    public static double getOfflineLevelDecimal(String skill, UUID uuid) {
        if (skill.equals("totalLevel")) {
            return XP.getTotalLevelFromMap(XP.getOfflineXpMap(uuid));
        }
        return XP.levelAtXpDecimal(XP.getOfflineXp(skill, uuid));
    }

    public static int getOfflineLevel(String skill, UUID uuid) {
        if (skill.equals("totalLevel")) {
            return XP.getTotalLevelFromMap(XP.getOfflineXpMap(uuid));
        }
        return XP.levelAtXp(XP.getOfflineXp(skill, uuid));
    }

    public static double getOfflineXp(String skill, UUID uuid) {
        return ((Map)offlineXp.getOrDefault(uuid, new HashMap())).getOrDefault(skill, 0.0);
    }

    public static double logBase(double base, double goal) {
        return Math.log(goal) / Math.log(base);
    }

    public static int levelAtXp(float xp) {
        return XP.levelAtXp((double)xp);
    }

    public static int levelAtXp(double xp) {
        boolean useExponentialFormula = Config.getConfig("useExponentialFormula") != 0.0;
        double baseXp = Config.getConfig("baseXp");
        double exponentialBaseXp = Config.getConfig("exponentialBaseXp");
        double exponentialBase = Config.getConfig("exponentialBase");
        double exponentialRate = Config.getConfig("exponentialRate");
        int maxLevel = (int)Math.floor(XP.getMaxLevel());
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        double theXp = 0.0;
        int level = 0;
        while (!(xp < theXp) && level < maxLevel) {
            theXp = useExponentialFormula ? (theXp += exponentialBaseXp * Math.pow(exponentialBase, exponentialRate * (double)level)) : (theXp += baseXp + (double)level * xpIncreasePerLevel);
            ++level;
        }
        return level;
    }

    public static float levelAtXpDecimal(float xp) {
        return (float)XP.levelAtXpDecimal((double)xp);
    }

    public static double levelAtXpDecimal(double xp) {
        double goalXp;
        int maxLevel = (int)Math.floor(XP.getMaxLevel());
        if (XP.levelAtXp(xp) >= maxLevel) {
            return maxLevel;
        }
        int startLevel = XP.levelAtXp(xp);
        double startXp = XP.xpAtLevel(startLevel);
        if (startXp == (goalXp = XP.xpAtLevel(startLevel + 1))) {
            return maxLevel;
        }
        return (double)startLevel + (xp - startXp) / (goalXp - startXp);
    }

    public static double xpAtLevel(int givenLevel) {
        return XP.xpAtLevel((double)givenLevel);
    }

    public static double xpAtLevel(float givenLevel) {
        return XP.xpAtLevel((double)givenLevel);
    }

    public static double xpAtLevel(double givenLevel) {
        boolean useExponentialFormula = Config.getConfig("useExponentialFormula") != 0.0;
        double baseXp = Config.getConfig("baseXp");
        double exponentialBaseXp = Config.getConfig("exponentialBaseXp");
        double exponentialBase = Config.getConfig("exponentialBase");
        double exponentialRate = Config.getConfig("exponentialRate");
        int maxLevel = (int)Math.floor(XP.getMaxLevel());
        if (givenLevel > (double)maxLevel) {
            givenLevel = maxLevel;
        }
        double theXp = 0.0;
        double xpIncreasePerLevel = Config.getConfig("xpIncreasePerLevel");
        int startLevel = 1;
        while ((double)startLevel < givenLevel) {
            theXp = useExponentialFormula ? (theXp += exponentialBaseXp * Math.pow(exponentialBase, exponentialRate * (double)(startLevel - 1))) : (theXp += baseXp + (double)(startLevel - 1) * xpIncreasePerLevel);
            ++startLevel;
        }
        return theXp;
    }

    public static double xpAtLevelDecimal(double givenLevel) {
        double startXp = XP.xpAtLevel(Math.floor(givenLevel));
        double endXp = XP.xpAtLevel(Math.floor(givenLevel + 1.0));
        double pos = givenLevel - Math.floor(givenLevel);
        return startXp + (endXp - startXp) * pos;
    }

    public static boolean isHoldingDebugItemInOffhand(Player player) {
        return XP.isItemDebugItem(player.m_21206_().m_41720_());
    }

    public static boolean isItemDebugItem(Item item) {
        return Items.f_42701_.equals(item);
    }

    public static boolean isNightvisionUnlocked(Player player) {
        return (double)Skill.getLevel(Skill.SWIMMING.toString(), player) >= Config.getConfig("nightvisionUnlockLevel");
    }

    public static void addWorldXpDrop(WorldXpDrop xpDrop, ServerPlayer player) {
        xpDrop.startXp *= (float)XP.getMultiplier((Player)player, xpDrop.getSkill());
        if (Config.getPreferencesMap((Player)player).getOrDefault("worldXpDropsEnabled", 1.0) != 0.0) {
            NetworkHandler.sendToPlayer(new MessageWorldXp(xpDrop), player);
        }
        UUID uuid = player.m_142081_();
        for (ServerPlayer otherPlayer : PmmoSavedData.getServer().m_6846_().m_11314_()) {
            double distance = Util.getDistance(xpDrop.getPos(), otherPlayer.m_20182_());
            if (!(distance < 64.0) || uuid.equals(otherPlayer.m_142081_()) || Config.getPreferencesMap((Player)otherPlayer).getOrDefault("showOthersWorldXpDrops", 0.0) == 0.0) continue;
            NetworkHandler.sendToPlayer(new MessageWorldXp(xpDrop), otherPlayer);
        }
    }

    public static void addWorldXpDrop(WorldXpDrop xpDrop, UUID uuid) {
        ServerPlayer player = PmmoSavedData.getServer().m_6846_().m_11259_(uuid);
        if (player != null) {
            XP.addWorldXpDrop(xpDrop, player);
        }
    }

    public static void addWorldXpDropOffline(WorldXpDrop xpDrop) {
        WorldRenderHandler.addWorldXpDropOffline(xpDrop);
    }

    public static void addWorldText(WorldText worldText, UUID uuid) {
        ServerPlayer player = PmmoSavedData.getServer().m_6846_().m_11259_(uuid);
        if (player != null) {
            XP.addWorldText(worldText, player);
        }
    }

    public static void addWorldTextRadius(ResourceLocation dimResLoc, WorldText worldText, double radius) {
        worldText.updatePos();
        for (ServerPlayer otherPlayer : PmmoSavedData.getServer().m_6846_().m_11314_()) {
            double distance;
            if (dimResLoc != XP.getDimResLoc(otherPlayer.m_20193_()) || !((distance = Util.getDistance(worldText.getPos(), otherPlayer.m_20182_())) < radius)) continue;
            NetworkHandler.sendToPlayer(new MessageWorldText(worldText), otherPlayer);
        }
    }

    public static void addWorldText(WorldText worldText, ServerPlayer player) {
        worldText.updatePos();
        NetworkHandler.sendToPlayer(new MessageWorldText(worldText), player);
    }

    public static void addWorldTextOffline(WorldText worldText) {
        WorldRenderHandler.addWorldTextOffline(worldText);
    }

    public static void sendPlayerSkillList(Player player, Map<String, Double> skills) {
        for (Map.Entry<String, Double> entry : skills.entrySet()) {
            int level = Skill.getLevel(entry.getKey(), player);
            if ((double)level < entry.getValue()) {
                player.m_5661_((Component)new TranslatableComponent("pmmo.levelDisplay", new Object[]{new TranslatableComponent("pmmo." + entry.getKey()), "" + (int)Math.floor(entry.getValue())}).m_6270_(textStyle.get("red")), false);
                continue;
            }
            player.m_5661_((Component)new TranslatableComponent("pmmo.levelDisplay", new Object[]{new TranslatableComponent("pmmo." + entry.getKey()), "" + (int)Math.floor(entry.getValue())}).m_6270_(textStyle.get("green")), false);
        }
    }
}

